/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;

public class ImmutableSchemataBuilderTest {
    private static final String STRING_TYPE = PropertyType.STRING.getName().toUpperCase();
    private ExecutionContext context;
    private ImmutableSchemata.Builder builder;
    private Schemata schemata;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.builder = ImmutableSchemata.createBuilder((TypeSystem)this.context.getValueFactories().getTypeSystem());
    }

    @After
    public void afterEach() {
        this.context = null;
        this.builder = null;
        this.schemata = null;
    }

    @Test
    public void shouldBuildSchemaForSingleTableWithDefaultTypeForColumns() {
        this.builder.addTable("t1", new String[]{"c1", "c2", "c3"});
        this.schemata = this.builder.build();
        Schemata.Table table = this.schemata.getTable(this.selector("t1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c2").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c3").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
    }

    @Test
    public void shouldBuildSchemaForMultipleTablesWithDefaultTypeForColumns() {
        this.builder.addTable("t1", new String[]{"c11", "c12", "c13"});
        this.builder.addTable("t2", new String[]{"c21", "c22", "c23"});
        this.schemata = this.builder.build();
        Schemata.Table table = this.schemata.getTable(this.selector("t1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c11").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c12").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c13").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        table = this.schemata.getTable(this.selector("t2"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c21").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c22").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c23").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
    }

    @Test
    public void shouldBuildSchemaContainingViewOfSingleTable() {
        this.builder.addTable("t1", new String[]{"c1", "c2", "c3"});
        this.builder.addView("t2", "SELECT * FROM t1 WHERE c1=3");
        this.schemata = this.builder.build();
        Schemata.Table table = this.schemata.getTable(this.selector("t1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c2").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c3").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        table = this.schemata.getTable(this.selector("t2"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Schemata.View.class)));
        Assert.assertThat((Object)table.getColumn("c1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c2").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c3").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
    }

    @Test
    public void shouldBuildSchemaContainingViewUsingAliasesOfColumns() {
        this.builder.addTable("t1", new String[]{"c1", "c2", "c3"});
        this.builder.addView("t2", "SELECT c1 as v1, c2 FROM t1 WHERE c1=3");
        this.schemata = this.builder.build();
        Schemata.Table table = this.schemata.getTable(this.selector("t1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c2").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c3").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        table = this.schemata.getTable(this.selector("t2"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Schemata.View.class)));
        Assert.assertThat((Object)table.getColumn("v1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c2").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
    }

    @Test
    public void shouldBuildSchemaContainingViewOfMultiTableJoin() {
        this.builder.addTable("t1", new String[]{"c11", "c12", "c13"});
        this.builder.addTable("t2", new String[]{"c21", "c22", "c23"});
        this.builder.addView("v1", "SELECT t1.c11 as x1, t1.c12, t2.c23 FROM t1 JOIN t2 ON t1.c11=t2.c21 WHERE t1.c11=3");
        this.schemata = this.builder.build();
        Schemata.Table table = this.schemata.getTable(this.selector("t1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c11").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c12").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c13").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        table = this.schemata.getTable(this.selector("t2"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c21").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c22").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c23").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        this.schemata = this.builder.build();
        table = this.schemata.getTable(this.selector("v1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Schemata.View.class)));
        Assert.assertThat((Object)table.getColumn("x1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c12").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c23").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
    }

    @Test
    public void shouldBuildSchemaContainingViewUsingView() {
        this.builder.addTable("t1", new String[]{"c11", "c12", "c13"});
        this.builder.addTable("t2", new String[]{"c21", "c22", "c23"});
        this.builder.addView("v2", "SELECT x1, c12 FROM v1 WHERE x1=3");
        this.builder.addView("v1", "SELECT t1.c11 as x1, t1.c12, t2.c23 FROM t1 JOIN t2 ON t1.c11=t2.c21 WHERE t1.c11=3");
        this.schemata = this.builder.build();
        Schemata.Table table = this.schemata.getTable(this.selector("t1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c11").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c12").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c13").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        table = this.schemata.getTable(this.selector("t2"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)table.getColumn("c21").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c22").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c23").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        this.schemata = this.builder.build();
        table = this.schemata.getTable(this.selector("v1"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Schemata.View.class)));
        Assert.assertThat((Object)table.getColumn("x1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c12").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c23").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        table = this.schemata.getTable(this.selector("v2"));
        Assert.assertThat((Object)table, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Schemata.View.class)));
        Assert.assertThat((Object)table.getColumn("x1").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
        Assert.assertThat((Object)table.getColumn("c12").getPropertyType(), (Matcher)Is.is((Object)STRING_TYPE));
    }

    protected SelectorName selector(String name) {
        return new SelectorName(name);
    }
}

