/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.FunctionRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.function.Function;
import org.modeshape.graph.request.function.FunctionContext;

public class FunctionRequestTest
extends AbstractRequestTest {
    private Function function;
    private FunctionRequest request;
    private FunctionRequest request2;
    private Map<String, Serializable> inputs;
    private Map<String, Serializable> inputs2;
    protected boolean ran = false;

    @Before
    public void beforeEach() {
        super.beforeEach();
        this.ran = false;
        this.inputs = new HashMap<String, Serializable>();
        this.inputs2 = new HashMap<String, Serializable>();
        this.function = new Function(){

            public void run(FunctionContext context) {
                FunctionRequestTest.this.ran = true;
                context.setOutput("success", (Serializable)Boolean.TRUE);
            }
        };
    }

    protected Request createRequest() {
        return new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFunction() {
        new FunctionRequest(null, this.validPathLocation1, this.workspace1, this.inputs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullLocation() {
        new FunctionRequest(this.function, null, this.workspace1, this.inputs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new FunctionRequest(this.function, this.validPathLocation1, null, this.inputs);
    }

    @Test
    public void shouldAllowCreatingRequestWithNullInputMap() {
        new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
        Assert.assertThat((Object)this.request.function(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.function)));
        Assert.assertThat((Object)this.request.at(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.inputs().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocationAndFunctionAndWorkspace() {
        this.request = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
        this.request2 = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)this.request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentFunctions() {
        Function function2 = new Function(){

            public void run(FunctionContext context) {
                FunctionRequestTest.this.ran = true;
                context.setOutput("success", (Serializable)Boolean.TRUE);
            }
        };
        this.request = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
        this.request2 = new FunctionRequest(function2, this.validPathLocation1, this.workspace1, this.inputs);
        Assert.assertThat((Object)this.request.equals((Object)this.request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentInputs() {
        this.inputs2.put("Some input", (Serializable)((Object)"value"));
        this.request = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
        this.request2 = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs2);
        Assert.assertThat((Object)this.request.equals((Object)this.request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
        this.request2 = new FunctionRequest(this.function, this.validPathLocation2, this.workspace1, this.inputs);
        Assert.assertThat((Object)this.request.equals((Object)this.request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new FunctionRequest(this.function, this.validPathLocation1, this.workspace1, this.inputs);
        this.request2 = new FunctionRequest(this.function, this.validPathLocation1, this.workspace2, this.inputs);
        Assert.assertThat((Object)this.request.equals((Object)this.request2), (Matcher)Is.is((Object)false));
    }
}

