/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.Request;

public class ReadPropertyRequestTest
extends AbstractRequestTest {
    private ReadPropertyRequest request;
    private Property validProperty;
    private Name validPropertyName;

    @Before
    public void beforeEach() {
        super.beforeEach();
        this.validProperty = this.validProperty1;
        this.validPropertyName = this.validProperty.getName();
    }

    protected Request createRequest() {
        return new ReadPropertyRequest(this.validPathLocation1, this.workspace1, this.validPropertyName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullLocation() {
        new ReadPropertyRequest(null, this.workspace1, this.validPropertyName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new ReadPropertyRequest(this.validPathLocation, null, this.validPropertyName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullPropertyName() {
        new ReadPropertyRequest(this.validPathLocation, this.workspace1, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new ReadPropertyRequest(this.validPathLocation1, this.workspace1, this.validPropertyName);
        Assert.assertThat((Object)this.request.on(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocationsAndSamePropertyName() {
        this.request = new ReadPropertyRequest(this.validPathLocation1, new String(this.workspace1), this.validPropertyName);
        ReadPropertyRequest request2 = new ReadPropertyRequest(this.validPathLocation1, this.workspace1, this.validPropertyName);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new ReadPropertyRequest(this.validPathLocation1, this.workspace1, this.validPropertyName);
        ReadPropertyRequest request2 = new ReadPropertyRequest(this.validPathLocation2, this.workspace1, this.validPropertyName);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new ReadPropertyRequest(this.validPathLocation1, this.workspace1, this.validPropertyName);
        ReadPropertyRequest request2 = new ReadPropertyRequest(this.validPathLocation1, this.workspace2, this.validPropertyName);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithSameLocationButDifferentPropertyNames() {
        this.request = new ReadPropertyRequest(this.validPathLocation1, this.workspace1, this.validProperty2.getName());
        ReadPropertyRequest request2 = new ReadPropertyRequest(this.validPathLocation2, this.workspace1, this.validPropertyName);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowSettingProperties() {
        this.request = new ReadPropertyRequest(this.validPathLocation, this.workspace1, this.validPropertyName);
        this.request.setProperty(this.validProperty1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowSettingPropertyIfNameDoeNotMatch() {
        this.request = new ReadPropertyRequest(this.validPathLocation, this.workspace1, this.validPropertyName);
        this.request.setProperty(this.validProperty2);
    }
}

