/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.util.Map;
import java.util.Set;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.web.jcr.rest.client.domain.ItemDefinition;
import org.modeshape.web.jcr.rest.client.domain.NodeType;

@Immutable
public class ChildNodeDefinition
extends ItemDefinition
implements NodeDefinition {
    private final Id id;
    private final String defaultPrimaryTypeName;

    public ChildNodeDefinition(String declaringNodeTypeName, String name, Set<String> requiredTypes, boolean isAutoCreated, boolean isMandatory, boolean isProtected, boolean allowsSameNameSiblings, int onParentVersion, String defaultPrimaryTypeName, Map<String, NodeType> nodeTypes) {
        super(declaringNodeTypeName, isAutoCreated, isMandatory, isProtected, onParentVersion, nodeTypes);
        this.id = new Id(name, allowsSameNameSiblings, requiredTypes);
        this.defaultPrimaryTypeName = defaultPrimaryTypeName;
    }

    protected Id id() {
        return this.id;
    }

    public String getName() {
        return this.id.name;
    }

    public boolean allowsSameNameSiblings() {
        return this.id.isMultiple;
    }

    public String[] getRequiredPrimaryTypeNames() {
        return ChildNodeDefinition.toArray(this.id.requiredTypes);
    }

    public NodeType getDefaultPrimaryType() {
        return this.nodeType(this.getDefaultPrimaryTypeName());
    }

    public String getDefaultPrimaryTypeName() {
        return this.defaultPrimaryTypeName;
    }

    public javax.jcr.nodetype.NodeType[] getRequiredPrimaryTypes() {
        return ChildNodeDefinition.nodeTypes(this.id.requiredTypes, this.nodeTypes());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChildNodeDefinition) {
            ChildNodeDefinition that = (ChildNodeDefinition)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" + ");
        sb.append(this.id.name);
        if (this.getRequiredPrimaryTypeNames().length != 0) {
            sb.append(" (");
            boolean first = true;
            for (String typeName : this.getRequiredPrimaryTypeNames()) {
                if (typeName == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(typeName);
            }
            sb.append(')');
        }
        if (this.getDefaultPrimaryTypeName() != null) {
            sb.append(" = ").append(this.getDefaultPrimaryTypeName());
        }
        if (this.isAutoCreated()) {
            sb.append(" autocreated");
        }
        if (this.isMandatory()) {
            sb.append(" mandatory");
        }
        if (this.allowsSameNameSiblings()) {
            sb.append(" sns");
        }
        if (this.isProtected()) {
            sb.append(" protected");
        }
        sb.append(' ').append(OnParentVersionAction.nameFromValue((int)this.getOnParentVersion()));
        return sb.toString();
    }

    protected static class Id {
        protected final String name;
        protected final boolean isMultiple;
        protected final Set<String> requiredTypes;

        protected Id(String name, boolean isMultiple, Set<String> requiredTypes) {
            this.name = name;
            this.isMultiple = isMultiple;
            this.requiredTypes = requiredTypes;
            assert (this.name != null);
            assert (this.requiredTypes != null);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Id) {
                Id that = (Id)obj;
                if (this.isMultiple != that.isMultiple) {
                    return false;
                }
                if (!((Object)this.requiredTypes).equals(that.requiredTypes)) {
                    return false;
                }
                return this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append('(');
            boolean first = true;
            for (String requiredType : this.requiredTypes) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(requiredType);
            }
            sb.append(')');
            sb.append(this.isMultiple ? (char)'*' : '1');
            return sb.toString();
        }
    }
}

