/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrResultSet;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.LocalJcrDriver;
import org.modeshape.jdbc.metadata.MetaDataQueryResult;
import org.modeshape.jdbc.metadata.MetadataProvider;
import org.modeshape.jdbc.metadata.ResultSetMetaDataImpl;
import org.modeshape.jdbc.metadata.ResultsMetadataConstants;

public class JcrMetaData
implements DatabaseMetaData {
    protected static final List<PropertyDefinition> PSEUDO_COLUMN_DEFNS;
    protected static final List<String> PSEUDO_COLUMN_NAMES;
    protected static final String WILDCARD = "%";
    protected static final Integer DEFAULT_ZERO;
    protected static final int NO_LIMIT = 0;
    private JcrConnection connection;
    private String catalogName;

    public JcrMetaData(JcrConnection connection) {
        this.connection = connection;
        assert (this.connection != null);
        this.catalogName = connection.getCatalog();
        assert (this.catalogName != null);
    }

    @Override
    public int getDriverMajorVersion() {
        return this.connection.driverInfo().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.connection.driverInfo().getMinorVersion();
    }

    @Override
    public String getDriverName() {
        return this.connection.driverInfo().getName();
    }

    @Override
    public String getDriverVersion() {
        return this.connection.driverInfo().getVersion();
    }

    @Override
    public int getDatabaseMajorVersion() {
        String[] parts = this.getDatabaseProductVersion().split("[.-]");
        return parts.length > 0 && parts[0] != null ? Integer.parseInt(parts[0]) : 0;
    }

    @Override
    public int getDatabaseMinorVersion() {
        String[] parts = this.getDatabaseProductVersion().split("[.-]");
        return parts.length > 1 && parts[1] != null ? Integer.parseInt(parts[1]) : 0;
    }

    @Override
    public String getDatabaseProductName() {
        return this.connection.getRepositoryDelegate().getDescriptor("jcr.repository.name");
    }

    public String getDatabaseProductUrl() {
        return this.connection.getRepositoryDelegate().getDescriptor("jcr.repository.vendor.url");
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.connection.getRepositoryDelegate().getDescriptor("jcr.repository.version");
    }

    @Override
    public int getJDBCMajorVersion() {
        return 2;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCatalogSeparator() {
        return null;
    }

    @Override
    public String getCatalogTerm() {
        return "Repository";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList records = new ArrayList(1);
        List<String> row = Arrays.asList(this.catalogName);
        records.add(row);
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        JcrStatement stmt = new JcrStatement(this.connection);
        MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
        JcrResultSet rs = new JcrResultSet(stmt, queryresult, resultSetMetaData);
        return rs;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LocalJcrDriver.logger.log(Level.FINE, "getcolumns: " + catalog + ":" + schemaPattern + ":" + tableNamePattern + ":" + columnNamePattern);
        if (tableNamePattern == null) {
            tableNamePattern = WILDCARD;
        }
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "DATA_TYPE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_SIZE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "BUFFER_LENGTH", "Long", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "DECIMAL_DIGITS", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "NUM_PREC_RADIX", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "NULLABLE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "REMARKS", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_DEF", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SQL_DATA_TYPE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SQL_DATETIME_SUB", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "CHAR_OCTET_LENGTH", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "ORDINAL_POSITION", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "IS_NULLABLE", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SCOPE_CATLOG", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SCOPE_SCHEMA", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SCOPE_TABLE", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SOURCE_DATA_TYPE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        ArrayList records = new ArrayList();
        try {
            List<NodeType> nodetypes = this.filterNodeTypes(tableNamePattern);
            for (NodeType type : nodetypes) {
                if (type.getPropertyDefinitions() == null) {
                    throw new SQLException("Program Error:  missing propertydefintions for " + type.getName());
                }
                List<PropertyDefinition> defns = this.filterPropertyDefnitions(columnNamePattern, type);
                int ordinal = 0;
                for (PropertyDefinition propDefn : defns) {
                    JcrType jcrtype = JcrType.typeInfo(propDefn.getRequiredType());
                    Integer nullable = propDefn.isMandatory() ? ResultsMetadataConstants.NULL_TYPES.NOT_NULL : ResultsMetadataConstants.NULL_TYPES.NULLABLE;
                    List<Object> currentRow = this.loadCurrentRow(type.getName(), propDefn.getName(), jcrtype, nullable, propDefn.isMandatory(), ordinal);
                    records.add(currentRow);
                    ++ordinal;
                }
                if (ordinal <= 0 || !this.connection.getRepositoryDelegate().getConnectionInfo().isTeiidSupport() || !this.connection.getRepositoryDelegate().getConnectionInfo().isTeiidSupport()) continue;
                List<Object> currentRow = this.loadCurrentRow(type.getName(), "mode:properties", JcrType.typeInfo(1), ResultsMetadataConstants.NULL_TYPES.NULLABLE, Boolean.FALSE, ordinal);
                records.add(currentRow);
            }
            JcrStatement jcrstmt = new JcrStatement(this.connection);
            MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
            return new JcrResultSet(jcrstmt, queryresult, resultSetMetaData);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    private List<Object> loadCurrentRow(String tableName, String columnName, JcrType jcrtype, Integer nullable, boolean isMandatory, int ordinal) {
        ArrayList<Object> currentRow = new ArrayList<Object>(22);
        currentRow.add(this.catalogName);
        currentRow.add("NULL");
        currentRow.add(tableName);
        currentRow.add(columnName);
        currentRow.add(jcrtype.getJdbcType());
        currentRow.add(jcrtype.getJdbcTypeName());
        currentRow.add(jcrtype.getNominalDisplaySize());
        currentRow.add("NULL");
        currentRow.add(DEFAULT_ZERO);
        currentRow.add(DEFAULT_ZERO);
        currentRow.add(nullable);
        currentRow.add("");
        currentRow.add("NULL");
        currentRow.add(DEFAULT_ZERO);
        currentRow.add(DEFAULT_ZERO);
        currentRow.add(DEFAULT_ZERO);
        currentRow.add(new Integer(ordinal + 1));
        currentRow.add(isMandatory ? "NO" : "YES");
        currentRow.add("NULL");
        currentRow.add("NULL");
        currentRow.add("NULL");
        currentRow.add(DEFAULT_ZERO);
        return currentRow;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getExtraNameCharacters() {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String tableNamePattern, boolean unique, boolean approximate) throws SQLException {
        if (tableNamePattern == null) {
            tableNamePattern = WILDCARD;
        }
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "NON_UNIQUE", "Boolean", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "INDEX_QUALIFIER", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "INDEX_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "ORDINAL_POSITION", "Long", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_NAME", "Long", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "ASC_OR_DESC", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "CARDINALITY", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "PAGES", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "FILTER_CONDITION", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        try {
            Boolean nonUnique = Boolean.FALSE;
            ArrayList records = new ArrayList();
            for (NodeType type : this.filterNodeTypes(tableNamePattern)) {
                if (!type.isNodeType("mix:referenceable")) continue;
                ArrayList<Object> currentRow = new ArrayList<Object>(13);
                currentRow.add(this.catalogName);
                currentRow.add("NULL");
                currentRow.add(type.getName());
                currentRow.add(nonUnique);
                currentRow.add(this.catalogName);
                currentRow.add(type.getName() + "_UK");
                currentRow.add((short)2);
                currentRow.add(new Short(1));
                currentRow.add(type.getName());
                currentRow.add("A");
                currentRow.add(0);
                currentRow.add(1);
                currentRow.add(null);
                records.add(currentRow);
            }
            JcrStatement jcrstmt = new JcrStatement(this.connection);
            MetadataProvider provider = new MetadataProvider(metadataList);
            ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
            MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
            return new JcrResultSet(jcrstmt, queryresult, resultSetMetaData);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public String getNumericFunctions() {
        return null;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String tableNamePattern) throws SQLException {
        if (tableNamePattern == null) {
            tableNamePattern = WILDCARD;
        }
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "KEY_SEQ", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "PK_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        try {
            ArrayList records = new ArrayList();
            for (NodeType type : this.filterNodeTypes(tableNamePattern)) {
                ArrayList<Object> currentRow = new ArrayList<Object>(6);
                currentRow.add(this.catalogName);
                currentRow.add("NULL");
                currentRow.add(type.getName());
                currentRow.add("jcr:path");
                currentRow.add(1);
                currentRow.add(type.getName() + "_PK");
                records.add(currentRow);
            }
            JcrStatement jcrstmt = new JcrStatement(this.connection);
            MetadataProvider provider = new MetadataProvider(metadataList);
            ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
            MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
            return new JcrResultSet(jcrstmt, queryresult, resultSetMetaData);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getProcedureTerm() {
        return null;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() {
        return 0;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() {
        return null;
    }

    @Override
    public int getSQLStateType() {
        return 0;
    }

    @Override
    public String getSchemaTerm() {
        return " ";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ArrayList records = new ArrayList(1);
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        JcrStatement stmt = new JcrStatement(this.connection);
        MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
        JcrResultSet rs = new JcrResultSet(stmt, queryresult, resultSetMetaData);
        return rs;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getSchemas();
    }

    @Override
    public String getSearchStringEscape() {
        return null;
    }

    @Override
    public String getStringFunctions() {
        return null;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSystemFunctions() {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList records = new ArrayList(1);
        List<String> row = Arrays.asList("VIEW");
        records.add(row);
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_TYPE", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        JcrStatement stmt = new JcrStatement(this.connection);
        MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
        JcrResultSet rs = new JcrResultSet(stmt, queryresult, resultSetMetaData);
        return rs;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        LocalJcrDriver.logger.log(Level.FINE, "getTables: " + catalog + ":" + schemaPattern + ":" + tableNamePattern + ":" + types);
        if (tableNamePattern == null) {
            tableNamePattern = WILDCARD;
        }
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_TYPE", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "REMARKS", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SELF_REFERENCING_COL_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "REF_GENERATION", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        ArrayList records = new ArrayList();
        try {
            List<NodeType> nodetypes = this.filterNodeTypes(tableNamePattern);
            for (NodeType type : nodetypes) {
                if (!type.isQueryable()) continue;
                ArrayList<String> currentRow = new ArrayList<String>(10);
                currentRow.add(this.catalogName);
                currentRow.add("NULL");
                currentRow.add(type.getName());
                currentRow.add("VIEW");
                currentRow.add("Is Mixin: " + type.isMixin());
                currentRow.add("NULL");
                currentRow.add("NULL");
                currentRow.add("NULL");
                currentRow.add(type.getPrimaryItemName());
                currentRow.add("DERIVED");
                records.add(currentRow);
            }
            JcrStatement jcrstmt = new JcrStatement(this.connection);
            MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
            return new JcrResultSet(jcrstmt, queryresult, resultSetMetaData);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getTimeDateFunctions() {
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getURL() {
        return this.connection.info().getEffectiveUrl();
    }

    @Override
    public String getUserName() {
        return this.connection.info().getUsername();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return false;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return false;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 2;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(JdbcLocalI18n.classDoesNotImplementInterface.text(new Object[]{DatabaseMetaData.class.getSimpleName(), iface.getName()}));
        }
        return iface.cast(this);
    }

    private List<NodeType> filterNodeTypes(String tableNamePattern) throws RepositoryException {
        List<NodeType> nodetypes = null;
        if (tableNamePattern.trim().equals(WILDCARD)) {
            nodetypes = this.connection.getRepositoryDelegate().nodeTypes();
        } else if (tableNamePattern.contains(WILDCARD)) {
            nodetypes = new ArrayList<NodeType>();
            String partName = null;
            boolean isLeading = false;
            boolean isTrailing = false;
            partName = tableNamePattern;
            if (partName.startsWith(WILDCARD)) {
                partName = partName.substring(1);
                isLeading = true;
            }
            if (partName.endsWith(WILDCARD) && partName.length() > 1) {
                partName = partName.substring(0, partName.length() - 1);
                isTrailing = true;
            }
            List<NodeType> nts = this.connection.getRepositoryDelegate().nodeTypes();
            for (NodeType type : nts) {
                if (isLeading) {
                    if (isTrailing) {
                        if (type.getName().indexOf(partName, 1) <= -1) continue;
                        nodetypes.add(type);
                        continue;
                    }
                    if (!type.getName().endsWith(partName)) continue;
                    nodetypes.add(type);
                    continue;
                }
                if (!isTrailing || !type.getName().startsWith(partName)) continue;
                nodetypes.add(type);
            }
        } else {
            NodeType nt = this.connection.getRepositoryDelegate().nodeType(tableNamePattern);
            nodetypes = new ArrayList<NodeType>(1);
            if (nt != null) {
                nodetypes.add(nt);
            }
        }
        if (nodetypes.size() > 1) {
            Comparator<NodeType> name_order = new Comparator<NodeType>(){

                @Override
                public int compare(NodeType e1, NodeType e2) {
                    return e1.getName().compareTo(e2.getName());
                }
            };
            Collections.sort(nodetypes, name_order);
        }
        return nodetypes;
    }

    private List<PropertyDefinition> filterPropertyDefnitions(String columnNamePattern, NodeType nodeType) {
        ArrayList<PropertyDefinition> allDefns = new ArrayList<PropertyDefinition>();
        this.addPropertyDefinitions(allDefns, nodeType);
        ArrayList<Object> resultDefns = null;
        if (columnNamePattern.trim().equals(WILDCARD)) {
            resultDefns = allDefns;
        } else if (columnNamePattern.contains(WILDCARD)) {
            resultDefns = new ArrayList();
            String partName = null;
            boolean isLeading = false;
            boolean isTrailing = false;
            partName = columnNamePattern;
            if (partName.startsWith(WILDCARD)) {
                partName = partName.substring(1);
                isLeading = true;
            }
            if (partName.endsWith(WILDCARD) && partName.length() > 1) {
                partName = partName.substring(0, partName.length() - 1);
                isTrailing = true;
            }
            for (PropertyDefinition defn : allDefns) {
                if (isLeading) {
                    if (isTrailing) {
                        if (defn.getName().indexOf(partName, 1) <= -1) continue;
                        resultDefns.add(defn);
                        continue;
                    }
                    if (!defn.getName().endsWith(partName)) continue;
                    resultDefns.add(defn);
                    continue;
                }
                if (!isTrailing || !defn.getName().startsWith(partName)) continue;
                resultDefns.add(defn);
            }
        } else {
            resultDefns = new ArrayList();
            for (PropertyDefinition defn : allDefns) {
                if (!defn.getName().equals(columnNamePattern)) continue;
                resultDefns.add(defn);
            }
        }
        if (resultDefns.size() > 1) {
            Comparator<PropertyDefinition> name_order = new Comparator<PropertyDefinition>(){

                @Override
                public int compare(PropertyDefinition e1, PropertyDefinition e2) {
                    return e1.getName().compareTo(e2.getName());
                }
            };
            Collections.sort(resultDefns, name_order);
        }
        return resultDefns;
    }

    private void addPropertyDefinitions(List<PropertyDefinition> mapDefns, NodeType nodetype) {
        HashSet<String> colNames = new HashSet<String>(mapDefns.size());
        mapDefns.addAll(PSEUDO_COLUMN_DEFNS);
        colNames.addAll(PSEUDO_COLUMN_NAMES);
        for (PropertyDefinition defn : nodetype.getPropertyDefinitions()) {
            if (defn.getName().equalsIgnoreCase("*") || defn.isMultiple() || defn.getName().startsWith("modeint:") || colNames.contains(defn.getName())) continue;
            mapDefns.add(defn);
            colNames.add(defn.getName());
        }
    }

    static {
        ArrayList<PseudoPropertyDefinition> defns = new ArrayList<PseudoPropertyDefinition>();
        ArrayList<String> defnNames = new ArrayList<String>();
        boolean auto = true;
        boolean mand = false;
        boolean prot = true;
        boolean mult = false;
        boolean search = true;
        boolean order = true;
        defns.add(new PseudoPropertyDefinition(null, "jcr:path", 8, auto, mand, prot, mult, search, order));
        defnNames.add("jcr:path");
        defns.add(new PseudoPropertyDefinition(null, "jcr:name", 7, auto, mand, prot, mult, search, order));
        defnNames.add("jcr:name");
        defns.add(new PseudoPropertyDefinition(null, "jcr:score", 4, auto, mand, prot, mult, search, order));
        defnNames.add("jcr:score");
        defns.add(new PseudoPropertyDefinition(null, "mode:localName", 1, auto, mand, prot, mult, search, order));
        defnNames.add("mode:localName");
        defns.add(new PseudoPropertyDefinition(null, "mode:depth", 3, auto, mand, prot, mult, search, order));
        defnNames.add("mode:depth");
        PSEUDO_COLUMN_DEFNS = Collections.unmodifiableList(defns);
        PSEUDO_COLUMN_NAMES = Collections.unmodifiableList(defnNames);
        DEFAULT_ZERO = new Integer(0);
    }

    protected static class PseudoPropertyDefinition
    implements PropertyDefinition {
        private static final String[] NO_STRINGS = new String[0];
        private static final Value[] NO_VALUES = new Value[0];
        private final String[] queryOps;
        private final Value[] defaultValues;
        private final int requiredType;
        private final String[] constraints;
        private final boolean isFullTextSearchable;
        private final boolean isMultiple;
        private final boolean isQueryOrderable;
        private final boolean isAutoCreated;
        private final boolean isMandatory;
        private final boolean isProtected;
        private final String name;
        private final NodeType declaringNodeType;
        private final int onParentVersioning;

        protected PseudoPropertyDefinition(NodeType declaringNodeType, String name, int requiredType, boolean autoCreated, boolean mandatory, boolean isProtected, boolean multiple, boolean fullTextSearchable, boolean queryOrderable, Value[] defaultValues, String[] constraints, int onParentVersioning, String[] queryOps) {
            this.declaringNodeType = declaringNodeType;
            this.name = name;
            this.queryOps = queryOps != null ? queryOps : NO_STRINGS;
            this.defaultValues = defaultValues != null ? defaultValues : NO_VALUES;
            this.requiredType = requiredType;
            this.constraints = constraints != null ? constraints : NO_STRINGS;
            this.isFullTextSearchable = fullTextSearchable;
            this.isAutoCreated = autoCreated;
            this.isMultiple = multiple;
            this.isQueryOrderable = queryOrderable;
            this.isMandatory = mandatory;
            this.isProtected = isProtected;
            this.onParentVersioning = onParentVersioning;
        }

        protected PseudoPropertyDefinition(NodeType declaringNodeType, String name, int requiredType, boolean autoCreated, boolean mandatory, boolean isProtected, boolean multiple, boolean fullTextSearchable, boolean queryOrderable) {
            this(declaringNodeType, name, requiredType, autoCreated, mandatory, isProtected, multiple, fullTextSearchable, queryOrderable, null, null, 1, null);
        }

        public String[] getAvailableQueryOperators() {
            return this.queryOps;
        }

        public Value[] getDefaultValues() {
            return this.defaultValues;
        }

        public int getRequiredType() {
            return this.requiredType;
        }

        public String[] getValueConstraints() {
            return this.constraints;
        }

        public boolean isFullTextSearchable() {
            return this.isFullTextSearchable;
        }

        public boolean isMultiple() {
            return this.isMultiple;
        }

        public boolean isQueryOrderable() {
            return this.isQueryOrderable;
        }

        public NodeType getDeclaringNodeType() {
            return this.declaringNodeType;
        }

        public String getName() {
            return this.name;
        }

        public int getOnParentVersion() {
            return this.onParentVersioning;
        }

        public boolean isAutoCreated() {
            return this.isAutoCreated;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }

        public boolean isProtected() {
            return this.isProtected;
        }
    }
}

