/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.postgres;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlLexicon;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;

public class PostgresDdlParserTest
extends DdlParserTestHelper {
    private static final String SPACE = " ";
    public static final String DDL_FILE_PATH = "ddl/dialect/postgres/";

    @Before
    public void beforeEach() {
        this.parser = new PostgresDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.parser.setDoUseTerminator(true);
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
        this.scorer = new DdlParserScorer();
    }

    @Test
    public void shouldParseAlterTableMultipleAddColumns() {
        this.printTest("shouldParseAlterTableMultipleAddColumns()");
        String content = "ALTER TABLE distributors \n        ADD COLUMN nick_name varchar(30), \n        ADD COLUMN address varchar(30);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
        Assert.assertEquals((long)2L, (long)childNode.getChildCount());
    }

    @Test
    public void shouldParseAlterTableMultipleMixedActions() {
        this.printTest("shouldParseAlterTableMultipleAddColumns()");
        String content = "ALTER TABLE distributors \n        ADD COLUMN nick_name varchar(30), \n        ALTER COLUMN address TYPE varchar(255), \n        RENAME COLUMN address TO city, \n        DROP COLUMN address;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
        Assert.assertEquals((long)4L, (long)childNode.getChildCount());
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getChild(2).getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_RENAME_COLUMN));
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getChild(3).getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_DROP_COLUMN_DEFINITION));
    }

    @Test
    public void shouldParseAlterTableMultipleAlterColumns() {
        this.printTest("shouldParseAlterTableMultipleAlterColumns()");
        String content = "ALTER TABLE distributors ALTER COLUMN address TYPE varchar(80), ALTER COLUMN name TYPE varchar(100);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
    }

    @Test
    public void shouldParseAlterTableMultipeAlterColumns_2() {
        this.printTest("shouldParseAlterTableMultipeAlterColumns_2()");
        String content = "ALTER TABLE foo ALTER COLUMN foo_timestamp DROP DEFAULT, ALTER COLUMN foo_timestamp TYPE timestamp with time zone USING timestamp with time zone \u2019epoch\u2019 + foo_timestamp *GO interval \u20191 second\u2019, ALTER COLUMN foo_timestamp SET DEFAULT now();";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
    }

    @Test
    public void shouldParseAlterTableMultipeColumns_3() {
        this.printTest("shouldParseAlterTableMultipeColumns_3()");
        String content = "ALTER TABLE foo ALTER COLUMN foo_timestamp SET DATA TYPE timestamp with time zone USING timestamp with time zone \u2019epoch\u2019 + foo_timestamp * interval \u20191 second\u2019;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
    }

    @Test
    public void shouldParseAlterTableMultipeColumns_4() {
        this.printTest("shouldParseAlterTableMultipeColumns_4()");
        String content = "ALTER TABLE distributors ALTER COLUMN street DROP NOT NULL;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
    }

    @Test
    public void shouldParseAlterTableMultipeColumns_5() {
        this.printTest("shouldParseAlterTableMultipeColumns_5()");
        String content = "ALTER TABLE distributors ADD CONSTRAINT zipchk CHECK (char_length(zipcode) = 5);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
    }

    @Test
    public void shouldParseAlterTableMultipeColumns_6() {
        this.printTest("shouldParseAlterTableMultipeColumns_6()");
        String content = "ALTER TABLE distributors SET TABLESPACE fasttablespace;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_TABLE_STATEMENT_POSTGRES));
    }

    @Test
    public void shouldParseCreateSchema() {
        this.printTest("shouldParseCreateSchema()");
        String content = "CREATE SCHEMA hollywood CREATE TABLE films (title text, release date, awards text[]) CREATE VIEW winners AS SELECT title, release FROM films WHERE awards IS NOT NULL;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_CREATE_SCHEMA_STATEMENT));
    }

    @Test
    public void shouldParseCreateSequence() {
        this.printTest("shouldParseCreateSequence()");
        String content = "CREATE SEQUENCE serial START 101;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_CREATE_SEQUENCE_STATEMENT));
    }

    @Test
    public void shouldParseCreateTable_1() {
        this.printTest("shouldParseCreateTable_1()");
        String content = "CREATE TABLE films ( code        char(5) CONSTRAINT firstkey PRIMARY KEY, title       varchar(40) NOT NULL, did         integer NOT NULL, date_prod   date, kind        varchar(10), len         interval hour to minute );";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT));
    }

    @Test
    public void shouldParseCreateTable_2() {
        this.printTest("shouldParseCreateTable_2()");
        String content = "CREATE TABLE distributors ( did    integer PRIMARY KEY DEFAULT nextval(\u2019serial\u2019), name      varchar(40) NOT NULL CHECK (name <> \u201d) );";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT));
    }

    @Ignore
    @Test
    public void shouldParseCreateTable_3() {
        this.printTest("shouldParseCreateTable_3()");
        String content = "CREATE TABLE distributors ( name      varchar(40) DEFAULT 'xxxx yyyy', name      varchar(40) DEFAULT \u2019Luso Films\u2019, did       integer DEFAULT nextval(\u2019distributors_serial\u2019), modtime   timestamp DEFAULT current_timestamp );";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT));
    }

    @Test
    public void shouldParseCreateTable_4() {
        this.printTest("shouldParseCreateTable_4()");
        String content = "CREATE TABLE films_recent AS SELECT * FROM films WHERE date_prod >= \u20192002-01-01\u2019;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT));
    }

    @Test
    public void shouldParseListen() {
        this.printTest("shouldParseListen()");
        String content = "LISTEN virtual;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_LISTEN_STATEMENT));
    }

    @Test
    public void shouldParseCreateTempTable() {
        this.printTest("shouldParseCreateTempTable()");
        String content = "CREATE TEMP TABLE films_recent WITH (OIDS) ON COMMIT DROP AS EXECUTE recentfilms(\u20192002-01-01\u2019);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT));
    }

    @Test
    public void shouldParseCreateRule() {
        this.printTest("shouldParseCreateRule()");
        String content = "CREATE RULE notify_me AS ON UPDATE TO mytable DO ALSO NOTIFY mytable;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_CREATE_RULE_STATEMENT));
    }

    @Test
    public void shouldParseAlterForeignDataWrapper() {
        this.printTest("");
        String content = "ALTER FOREIGN DATA WRAPPER dbi OPTIONS (ADD foo \u20191\u2019, DROP \u2019bar\u2019);";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_ALTER_FOREIGN_DATA_WRAPPER_STATEMENT));
    }

    @Test
    public void shouldParseCommentOn() {
        this.printTest("shouldParseCommentOn()");
        String content = "COMMENT ON TABLE mytable IS \u2019This is my table.\u2019;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_COMMENT_ON_STATEMENT));
    }

    @Test
    public void shouldParseCreateFunctionWithMultipleSemicolons() {
        this.printTest("shouldParseCreateFunctionWithMultipleSemicolons()");
        String content = "CREATE OR REPLACE FUNCTION increment(i integer) RETURNS integer AS $$ BEGIN RETURN i + 1; END; CREATE TABLE tblName_A (col_1 varchar(255));";
        this.assertScoreAndParse(content, null, 2);
    }

    @Test
    public void shouldParseLockTable() {
        this.printTest("shouldParseLockTable()");
        String content = "LOCK TABLE films IN SHARE MODE;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParsePrepareStatement() {
        this.printTest("shouldParsePrepareStatement()");
        String content = "PREPARE fooplan (int, text, bool, numeric) AS INSERT INTO foo VALUES($1, $2, $3, $4);";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseDropDomain() {
        this.printTest("shouldParseDropDomain()");
        String content = "DROP DOMAIN IF EXISTS domain_name CASCADE;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseDropTableMultiple() {
        this.printTest("shouldParseDropDomain()");
        String content = "DROP TABLE films, distributors;";
        this.assertScoreAndParse(content, null, 2);
    }

    @Test
    public void shouldParseGrantOnTable() {
        this.printTest("shouldParseGrantOnTable()");
        String content = "GRANT UPDATE, TRIGGER ON TABLE t TO anita,zhi;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseGrantOnMultipleTables() {
        this.printTest("shouldParseGrantOnMultipleTables()");
        String content = "GRANT UPDATE, TRIGGER ON TABLE t1, t2, t3 TO anita,zhi;";
        this.assertScoreAndParse(content, null, 3);
    }

    @Test
    public void shouldParseGrantExecuteOnFunction() {
        this.printTest("shouldParseGrantExecuteOnFunction()");
        String content = "GRANT EXECUTE ON FUNCTION divideByTwo(numerator int, IN demoninator int) TO george;";
        this.assertScoreAndParse(content, null, 1);
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_GRANT_ON_FUNCTION_STATEMENT));
    }

    @Test
    public void shouldParseGrantExecuteAndUpdateOnMultipleFunctions() {
        this.printTest("shouldParseGrantExecuteOnMultipleFunctions()");
        String content = "GRANT EXECUTE, UPDATE ON FUNCTION cos(), sin(b double precision) TO peter;";
        this.assertScoreAndParse(content, null, 2);
        AstNode childNode = this.rootNode.getChild(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), PostgresDdlLexicon.TYPE_GRANT_ON_FUNCTION_STATEMENT));
        Assert.assertEquals((long)3L, (long)childNode.getChildCount());
        childNode = this.rootNode.getChild(1);
        Assert.assertEquals((long)4L, (long)childNode.getChildCount());
    }

    @Test
    public void shouldParsePostgresStatements_1() {
        this.printTest("shouldParsePostgresStatements_1()");
        String content = this.getFileContent("ddl/dialect/postgres/postgres_test_statements_1.ddl");
        this.assertScoreAndParse(content, "postgres_test_statements_1.ddl", 82);
    }

    @Ignore
    @Test
    public void shouldParsePostgresStatements_2() {
        this.printTest("shouldParsePostgresStatements_2()");
        String content = this.getFileContent("ddl/dialect/postgres/postgres_test_statements_2.ddl");
        this.assertScoreAndParse(content, "postgres_test_statements_2.ddl", 101);
    }

    @Test
    public void shouldParsePostgresStatements_3() {
        this.printTest("shouldParsePostgresStatements_3()");
        String content = this.getFileContent("ddl/dialect/postgres/postgres_test_statements_3.ddl");
        this.assertScoreAndParse(content, "postgres_test_statements_3.ddl", 143);
    }

    @Test
    public void shouldParsePostgresStatements_4() {
        this.printTest("shouldParsePostgresStatements_4()");
        String content = this.getFileContent("ddl/dialect/postgres/postgres_test_statements_4.ddl");
        this.assertScoreAndParse(content, "postgres_test_statements_4.ddl", 34);
    }
}

