/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.java.JavaMetadataLexicon;
import org.modeshape.sequencer.java.JavaMetadataSequencer;
import org.modeshape.sequencer.java.OriginalFormatSourceFileRecorder;
import org.modeshape.sequencer.java.SourceFileRecorder;

public class JavaMetadataSequencerTest {
    private JavaMetadataSequencer sequencer;
    private InputStream content;
    private MockSequencerOutput output;
    private File source;
    private StreamSequencerContext context;
    private PathFactory pathFactory;

    @Before
    public void beforeEach() {
        this.pathFactory = new ExecutionContext().getValueFactories().getPathFactory();
        this.context = new MockSequencerContext();
        this.context.getNamespaceRegistry().register("java", "http://www.modeshape.org/java/1.0");
        this.sequencer = new JavaMetadataSequencer();
        this.output = new MockSequencerOutput(this.context);
        this.source = new File("src/test/workspace/projectX/src/org/acme/MySource.java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.content != null) {
            try {
                this.content.close();
            }
            finally {
                this.content = null;
            }
        }
    }

    protected FileInputStream getJavaSrc(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private Path path(Name ... names) {
        return this.pathFactory.createRelativePath(names);
    }

    private Path path(Path path, Name name, int index) {
        return this.pathFactory.create(path, new Path.Segment[]{this.pathFactory.createSegment(name, index)});
    }

    private Path path(Path path, Name ... names) {
        for (Name name : names) {
            path = this.pathFactory.create(path, new Name[]{name});
        }
        return path;
    }

    @Test
    public void shouldGenerateMetadataForJavaSourceFile() throws IOException {
        this.content = this.getJavaSrc(this.source);
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.setSourceFileRecorder((SourceFileRecorder)new OriginalFormatSourceFileRecorder());
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE), "jcr:primaryType"), (Matcher)Is.is((Object)new Object[]{JavaMetadataLexicon.COMPILATION_UNIT_NODE}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.PACKAGE_CHILD_NODE, JavaMetadataLexicon.PACKAGE_DECLARATION_CHILD_NODE), "java:packageName"), (Matcher)Is.is((Object)new Object[]{"org.acme"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.IMPORT_CHILD_NODE, JavaMetadataLexicon.IMPORT_DECLARATION_CHILD_NODE, JavaMetadataLexicon.SINGLE_IMPORT_CHILD_NODE), JavaMetadataLexicon.SINGLE_IMPORT_TYPE_DECLARATION_CHILD_NODE, 1), "java:singleImportName"), (Matcher)Is.is((Object)new Object[]{"org.acme.annotation.MyClassAnnotation"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.IMPORT_CHILD_NODE, JavaMetadataLexicon.IMPORT_DECLARATION_CHILD_NODE, JavaMetadataLexicon.ON_DEMAND_IMPORT_CHILD_NODE), JavaMetadataLexicon.ON_DEMAND_IMPORT_TYPE_DECLARATION_CHILD_NODE, 1), "java:onDemandImportName"), (Matcher)Is.is((Object)new Object[]{"java.util"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.MODIFIER_CHILD_NODE), JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE, 1), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE), "java:normalClassName"), (Matcher)Is.is((Object)new Object[]{"MySource"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"private"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"i"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE), JavaMetadataLexicon.VARIABLE, 2), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"j"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, 2), JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"private"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, 2), JavaMetadataLexicon.MODIFIER_CHILD_NODE), JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE, 2), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"static"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, 2), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"double"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, 2), JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"a"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PARAMETERIZED_TYPE_MODIFIER_CHILD_NODE), "java:parameterizedTypeName"), (Matcher)Is.is((Object)new Object[]{"List"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.PARAMETERIZED_TYPE_MODIFIER_CHILD_NODE, 2), "java:parameterizedTypeName"), (Matcher)Is.is((Object)new Object[]{"A"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_CHILD_NODE), "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"X"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"x"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE), "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"ia"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE, 2), "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE, 2), JavaMetadataLexicon.ARRAY_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"oa"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE, 3), "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"Collection"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.FIELD_CHILD_NODE, JavaMetadataLexicon.FIELD_TYPE_CHILD_NODE, JavaMetadataLexicon.TYPE_CHILD_NODE), JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE, 3), JavaMetadataLexicon.ARRAY_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"ca"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE), "java:constructorName"), (Matcher)Is.is((Object)new Object[]{"MySource"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), "java:constructorName"), (Matcher)Is.is((Object)new Object[]{"MySource"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"i"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 2), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 2), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"j"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 3), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_CHILD_NODE), "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.CONSTRUCTOR_CHILD_NODE), JavaMetadataLexicon.CONSTRUCTOR_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 3), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"o"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE, JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE, JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, JavaMetadataLexicon.RETURN_TYPE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE, JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE), "java:methodName"), (Matcher)Is.is((Object)new Object[]{"getI"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.RETURN_TYPE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"void"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 2), "java:methodName"), (Matcher)Is.is((Object)new Object[]{"setI"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 2), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"i"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.RETURN_TYPE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"void"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), "java:methodName"), (Matcher)Is.is((Object)new Object[]{"doSomething"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"p1"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 2), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"double"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 2), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE, JavaMetadataLexicon.PRIMITIVE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"p2"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 3), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_CHILD_NODE), "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 4), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 3), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_CHILD_NODE, JavaMetadataLexicon.SIMPLE_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"o"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 5), JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"private"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 5), JavaMetadataLexicon.RETURN_TYPE, JavaMetadataLexicon.PRIMITIVE_TYPE_CHILD_NODE), "java:primitiveTypeName"), (Matcher)Is.is((Object)new Object[]{"double"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 5), "java:methodName"), (Matcher)Is.is((Object)new Object[]{"doSomething2"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 5), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE), "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 5), JavaMetadataLexicon.PARAMETER, JavaMetadataLexicon.FORMAL_PARAMETER, JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"oa"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 5), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 2), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE), "java:arrayTypeName"), (Matcher)Is.is((Object)new Object[]{"int"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 5), JavaMetadataLexicon.PARAMETER), JavaMetadataLexicon.FORMAL_PARAMETER, 2), JavaMetadataLexicon.TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_CHILD_NODE, JavaMetadataLexicon.ARRAY_TYPE_VARIABLE, JavaMetadataLexicon.VARIABLE), "java:variableName"), (Matcher)Is.is((Object)new Object[]{"ia"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 6), JavaMetadataLexicon.MODIFIER_CHILD_NODE, JavaMetadataLexicon.MODIFIER_DECLARATION_CHILD_NODE), "java:modifierName"), (Matcher)Is.is((Object)new Object[]{"public"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 6), JavaMetadataLexicon.RETURN_TYPE, JavaMetadataLexicon.SIMPLE_TYPE_CHILD_NODE), "java:simpleTypeName"), (Matcher)Is.is((Object)new Object[]{"Object"}));
        Assert.assertThat((Object)this.output.getPropertyValues(this.path(this.path(JavaMetadataLexicon.COMPILATION_UNIT_NODE, JavaMetadataLexicon.UNIT_TYPE_CHILD_NODE, JavaMetadataLexicon.CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_CHILD_NODE, JavaMetadataLexicon.NORMAL_CLASS_DECLARATION_CHILD_NODE, JavaMetadataLexicon.METHOD_CHILD_NODE), JavaMetadataLexicon.METHOD_DECLARATION_CHILD_NODE, 6), "java:methodName"), (Matcher)Is.is((Object)new Object[]{"doSomething3"}));
    }
}

