/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.java.CompilationUnitParser;
import org.modeshape.sequencer.java.JavaMetadataUtil;
import org.modeshape.sequencer.java.metadata.AnnotationMetadata;
import org.modeshape.sequencer.java.metadata.ArrayTypeFieldMetadata;
import org.modeshape.sequencer.java.metadata.ClassMetadata;
import org.modeshape.sequencer.java.metadata.ConstructorMetadata;
import org.modeshape.sequencer.java.metadata.ImportOnDemandMetadata;
import org.modeshape.sequencer.java.metadata.JavaMetadata;
import org.modeshape.sequencer.java.metadata.MarkerAnnotationMetadata;
import org.modeshape.sequencer.java.metadata.MethodMetadata;
import org.modeshape.sequencer.java.metadata.MethodTypeMemberMetadata;
import org.modeshape.sequencer.java.metadata.ModifierMetadata;
import org.modeshape.sequencer.java.metadata.PackageMetadata;
import org.modeshape.sequencer.java.metadata.ParameterizedTypeFieldMetadata;
import org.modeshape.sequencer.java.metadata.PrimitiveFieldMetadata;
import org.modeshape.sequencer.java.metadata.SimpleTypeFieldMetadata;
import org.modeshape.sequencer.java.metadata.SingleImportMetadata;
import org.modeshape.sequencer.java.metadata.TypeMetadata;
import org.modeshape.sequencer.java.metadata.Variable;

public class JavaMetadataTest {
    private File source;
    private InputStream stream;
    private JavaMetadata javaMetadata;
    private ASTNode rootNode = null;

    @Before
    public void beforeEach() throws Exception {
        this.source = new File("src/test/workspace/projectX/src/org/acme/MySource.java");
        this.stream = this.getJavaSrc(this.source);
        this.javaMetadata = JavaMetadata.instance((InputStream)this.stream, (long)JavaMetadataUtil.length((InputStream)this.stream), null);
        this.rootNode = CompilationUnitParser.runJLS3Conversion((char[])JavaMetadataUtil.getJavaSourceFromTheInputStream((InputStream)this.getJavaSrc(this.source), (long)this.source.length(), null), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            finally {
                this.stream = null;
            }
        }
    }

    protected FileInputStream getJavaSrc(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    @Test
    public void shouldGetJavaSourceFromTheInputStream() throws Exception {
        char[] c = JavaMetadataUtil.getJavaSourceFromTheInputStream((InputStream)this.stream, (long)JavaMetadataUtil.length((InputStream)this.stream), null);
        Assert.assertThat((Object)c, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldRunJLS3Conversion() throws Exception {
        Assert.assertThat((Object)this.rootNode, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertTrue((String)"Not a compilation unit", (this.rootNode.getNodeType() == 15 ? 1 : 0) != 0);
    }

    @Test
    public void shouldCreatePackageMetadata() throws Exception {
        PackageMetadata packageMetadata = this.javaMetadata.createPackageMetadata((CompilationUnit)this.rootNode);
        Assert.assertThat((Object)packageMetadata, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)packageMetadata.getName(), (Matcher)Is.is((Object)"org.acme"));
        List annotations = packageMetadata.getAnnotationMetada();
        for (AnnotationMetadata annotationMetadata : annotations) {
            if (!(annotationMetadata instanceof MarkerAnnotationMetadata)) continue;
            MarkerAnnotationMetadata maker = (MarkerAnnotationMetadata)annotationMetadata;
            Assert.assertThat((Object)maker.getName(), (Matcher)Is.is((Object)"org.acme.annotation.MyPackageAnnotation"));
        }
    }

    @Test
    public void shouldCreateImportMetadata() throws Exception {
        List data = this.javaMetadata.createImportMetadata((CompilationUnit)this.rootNode);
        for (Object o : data) {
            if (o instanceof ImportOnDemandMetadata) {
                ImportOnDemandMetadata onDemand = (ImportOnDemandMetadata)o;
                Assert.assertThat((Object)onDemand.getName(), (Matcher)Is.is((Object)"java.util"));
                continue;
            }
            SingleImportMetadata singleImport = (SingleImportMetadata)o;
            Assert.assertThat((Object)singleImport.getName(), (Matcher)Is.is((Object)"org.acme.annotation.MyClassAnnotation"));
        }
    }

    @Test
    public void shouldCreateTopLevelTypeMetadata() throws Exception {
        List data = this.javaMetadata.createTypeMetadata((CompilationUnit)this.rootNode);
        Assert.assertTrue((data.size() > 0 ? 1 : 0) != 0);
        for (TypeMetadata typeMetadata : data) {
            if (!(typeMetadata instanceof ClassMetadata)) continue;
            ClassMetadata classMetadata = (ClassMetadata)typeMetadata;
            Assert.assertThat((Object)classMetadata.getName(), (Matcher)Is.is((Object)"MySource"));
            Assert.assertNotNull((Object)classMetadata.getModifiers());
            Assert.assertTrue((!classMetadata.getModifiers().isEmpty() ? 1 : 0) != 0);
            Assert.assertThat((Object)((ModifierMetadata)classMetadata.getModifiers().get(0)).getName(), (Matcher)Is.is((Object)"public"));
            List annotations = classMetadata.getAnnotations();
            for (AnnotationMetadata annotationMetadata : annotations) {
                if (!(annotationMetadata instanceof MarkerAnnotationMetadata)) continue;
                MarkerAnnotationMetadata marker = (MarkerAnnotationMetadata)annotationMetadata;
                Assert.assertNotNull((Object)marker);
                Assert.assertThat((Object)marker.getName(), (Matcher)Is.is((Object)"MyClassAnnotation"));
            }
            List fields = classMetadata.getFields();
            Assert.assertNotNull((Object)fields);
            Assert.assertTrue((fields.size() > 0 ? 1 : 0) != 0);
            PrimitiveFieldMetadata primitiveFieldMetadata = (PrimitiveFieldMetadata)fields.get(0);
            Assert.assertTrue((primitiveFieldMetadata.getModifiers().size() > 0 ? 1 : 0) != 0);
            Assert.assertThat((Object)primitiveFieldMetadata.getType(), (Matcher)Is.is((Object)"int"));
            Assert.assertThat((Object)((Variable)primitiveFieldMetadata.getVariables().get(0)).getName(), (Matcher)Is.is((Object)"i"));
            Assert.assertThat((Object)((Variable)primitiveFieldMetadata.getVariables().get(1)).getName(), (Matcher)Is.is((Object)"j"));
            PrimitiveFieldMetadata primitiveFieldMetadata2 = (PrimitiveFieldMetadata)fields.get(1);
            Assert.assertTrue((primitiveFieldMetadata2.getModifiers().size() > 0 ? 1 : 0) != 0);
            Assert.assertThat((Object)primitiveFieldMetadata2.getType(), (Matcher)Is.is((Object)"double"));
            Assert.assertThat((Object)((Variable)primitiveFieldMetadata2.getVariables().get(0)).getName(), (Matcher)Is.is((Object)"a"));
            ParameterizedTypeFieldMetadata parameterizedFieldMetadata1 = (ParameterizedTypeFieldMetadata)fields.get(2);
            Assert.assertNotNull((Object)parameterizedFieldMetadata1);
            Assert.assertTrue((parameterizedFieldMetadata1.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertThat((Object)parameterizedFieldMetadata1.getType(), (Matcher)Is.is((Object)"List"));
            Assert.assertThat((Object)((Variable)parameterizedFieldMetadata1.getVariables().get(0)).getName(), (Matcher)Is.is((Object)"l"));
            ParameterizedTypeFieldMetadata parameterizedFieldMetadata2 = (ParameterizedTypeFieldMetadata)fields.get(3);
            Assert.assertNotNull((Object)parameterizedFieldMetadata2);
            Assert.assertTrue((parameterizedFieldMetadata2.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertThat((Object)parameterizedFieldMetadata2.getType(), (Matcher)Is.is((Object)"A"));
            Assert.assertThat((Object)((Variable)parameterizedFieldMetadata2.getVariables().get(0)).getName(), (Matcher)Is.is((Object)"o"));
            SimpleTypeFieldMetadata simpleFieldMetadata = (SimpleTypeFieldMetadata)fields.get(4);
            Assert.assertNotNull((Object)simpleFieldMetadata);
            Assert.assertTrue((simpleFieldMetadata.getModifiers().size() > 0 ? 1 : 0) != 0);
            Assert.assertThat((Object)simpleFieldMetadata.getType(), (Matcher)Is.is((Object)"X"));
            Assert.assertThat((Object)((Variable)simpleFieldMetadata.getVariables().get(0)).getName(), (Matcher)Is.is((Object)"x"));
            ArrayTypeFieldMetadata arrayTypeFieldMetadata1 = (ArrayTypeFieldMetadata)fields.get(5);
            Assert.assertNotNull((Object)arrayTypeFieldMetadata1);
            Assert.assertTrue((arrayTypeFieldMetadata1.getModifiers().size() > 0 ? 1 : 0) != 0);
            Assert.assertThat((Object)arrayTypeFieldMetadata1.getType(), (Matcher)Is.is((Object)"int"));
            Assert.assertThat((Object)((Variable)arrayTypeFieldMetadata1.getVariables().get(0)).getName(), (Matcher)Is.is((Object)"ia"));
            ArrayTypeFieldMetadata arrayTypeFieldMetadata2 = (ArrayTypeFieldMetadata)fields.get(6);
            Assert.assertNotNull((Object)arrayTypeFieldMetadata2);
            Assert.assertTrue((arrayTypeFieldMetadata2.getModifiers().size() > 0 ? 1 : 0) != 0);
            Assert.assertThat((Object)arrayTypeFieldMetadata2.getType(), (Matcher)Is.is((Object)"Object"));
            Assert.assertThat((Object)((Variable)arrayTypeFieldMetadata2.getVariables().get(0)).getName(), (Matcher)Is.is((Object)"oa"));
            List methods = classMetadata.getMethods();
            Assert.assertNotNull((Object)methods);
            Assert.assertTrue((methods.size() > 0 ? 1 : 0) != 0);
            MethodMetadata methodMetadata = (MethodMetadata)methods.get(0);
            ConstructorMetadata constructorMetadata = (ConstructorMetadata)methodMetadata;
            Assert.assertNotNull((Object)constructorMetadata);
            Assert.assertTrue((constructorMetadata.getModifiers().size() == 0 ? 1 : 0) != 0);
            Assert.assertThat((Object)constructorMetadata.getName(), (Matcher)Is.is((Object)"MySource"));
            Assert.assertTrue((constructorMetadata.getParameters().size() == 0 ? 1 : 0) != 0);
            MethodMetadata methodMetadata2 = (MethodMetadata)methods.get(1);
            ConstructorMetadata constructorMetadata2 = (ConstructorMetadata)methodMetadata2;
            Assert.assertNotNull((Object)constructorMetadata2);
            Assert.assertTrue((constructorMetadata2.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertThat((Object)constructorMetadata2.getName(), (Matcher)Is.is((Object)"MySource"));
            Assert.assertTrue((constructorMetadata2.getParameters().size() > 0 ? 1 : 0) != 0);
            MethodTypeMemberMetadata methodTypeMemberMetadata1 = (MethodTypeMemberMetadata)methods.get(2);
            Assert.assertTrue((methodTypeMemberMetadata1.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)methodTypeMemberMetadata1.getReturnType().getType(), (Object)"int");
            Assert.assertNotNull((Object)methodTypeMemberMetadata1);
            Assert.assertThat((Object)methodTypeMemberMetadata1.getName(), (Matcher)Is.is((Object)"getI"));
            Assert.assertTrue((methodTypeMemberMetadata1.getParameters().size() == 0 ? 1 : 0) != 0);
            MethodTypeMemberMetadata methodTypeMemberMetadata3 = (MethodTypeMemberMetadata)methods.get(3);
            Assert.assertTrue((methodTypeMemberMetadata3.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)methodTypeMemberMetadata3.getReturnType().getType(), (Object)"void");
            Assert.assertNotNull((Object)methodTypeMemberMetadata3);
            Assert.assertThat((Object)methodTypeMemberMetadata3.getName(), (Matcher)Is.is((Object)"setI"));
            Assert.assertTrue((methodTypeMemberMetadata3.getParameters().size() == 1 ? 1 : 0) != 0);
            MethodTypeMemberMetadata methodTypeMemberMetadata4 = (MethodTypeMemberMetadata)methods.get(4);
            Assert.assertTrue((methodTypeMemberMetadata4.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)methodTypeMemberMetadata4.getReturnType().getType(), (Object)"void");
            Assert.assertNotNull((Object)methodTypeMemberMetadata4);
            Assert.assertThat((Object)methodTypeMemberMetadata4.getName(), (Matcher)Is.is((Object)"setJ"));
            Assert.assertTrue((methodTypeMemberMetadata4.getParameters().size() == 1 ? 1 : 0) != 0);
            MethodTypeMemberMetadata methodTypeMemberMetadata5 = (MethodTypeMemberMetadata)methods.get(5);
            Assert.assertTrue((methodTypeMemberMetadata5.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)methodTypeMemberMetadata5.getReturnType().getType(), (Object)"void");
            Assert.assertNotNull((Object)methodTypeMemberMetadata5);
            Assert.assertThat((Object)methodTypeMemberMetadata5.getName(), (Matcher)Is.is((Object)"doSomething"));
            Assert.assertTrue((methodTypeMemberMetadata5.getParameters().size() > 0 ? 1 : 0) != 0);
            MethodTypeMemberMetadata methodTypeMemberMetadata6 = (MethodTypeMemberMetadata)methods.get(6);
            Assert.assertTrue((methodTypeMemberMetadata6.getModifiers().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)methodTypeMemberMetadata6.getReturnType().getType(), (Object)"double");
            Assert.assertNotNull((Object)methodTypeMemberMetadata6);
            Assert.assertThat((Object)methodTypeMemberMetadata6.getName(), (Matcher)Is.is((Object)"doSomething2"));
            Assert.assertTrue((methodTypeMemberMetadata6.getParameters().size() > 0 ? 1 : 0) != 0);
        }
    }
}

