/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hibernate.ejb.Ejb3Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.TestEnvironment;
import org.modeshape.connector.store.jpa.model.common.WorkspaceEntity;
import org.modeshape.connector.store.jpa.model.simple.SimpleModel;
import org.modeshape.graph.connector.RepositoryConnection;

public class JdbcConnectionTest {
    private EntityManagerFactory factory;
    private EntityManager manager;
    private SimpleModel model;

    @Before
    public void beforeEach() throws Exception {
        this.model = new SimpleModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        try {
            if (this.manager != null) {
                this.manager.close();
            }
        }
        finally {
            this.manager = null;
            if (this.factory != null) {
                try {
                    this.factory.close();
                }
                finally {
                    this.factory = null;
                }
            }
        }
    }

    protected EntityManager startEntityManager() {
        if (this.manager == null) {
            JpaSource source = TestEnvironment.configureJpaSource("Test Repository", this);
            Ejb3Configuration configurator = new Ejb3Configuration();
            for (Class clazz : this.model.getEntityClasses()) {
                configurator.addAnnotatedClass(clazz);
            }
            configurator.setProperty("hibernate.dialect", source.getDialect());
            configurator.setProperty("hibernate.connection.driver_class", source.getDriverClassName());
            configurator.setProperty("hibernate.connection.username", source.getUsername());
            configurator.setProperty("hibernate.connection.password", source.getPassword());
            configurator.setProperty("hibernate.connection.url", source.getUrl());
            configurator.setProperty("hibernate.show_sql", "false");
            configurator.setProperty("hibernate.format_sql", "true");
            configurator.setProperty("hibernate.use_sql_comments", "true");
            configurator.setProperty("hibernate.hbm2ddl.auto", "create");
            configurator.setProperty("hibernate.cache.use_second_level_cache", "false");
            this.factory = configurator.buildEntityManagerFactory();
            this.manager = this.factory.createEntityManager();
        }
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConnectToDatabaseAndPersistWorkspace() {
        this.startEntityManager();
        WorkspaceEntity workspace = new WorkspaceEntity();
        workspace.setName("connection test");
        this.manager.getTransaction().begin();
        try {
            this.manager.persist((Object)workspace);
            this.manager.getTransaction().commit();
        }
        catch (RuntimeException t) {
            this.manager.getTransaction().rollback();
            throw t;
        }
        this.manager.getTransaction().begin();
        try {
            WorkspaceEntity workspace2 = (WorkspaceEntity)this.manager.find(WorkspaceEntity.class, (Object)workspace.getId());
            Assert.assertThat((Object)workspace2.getName(), (Matcher)Is.is((Object)workspace.getName()));
        }
        finally {
            this.manager.getTransaction().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAutoDetectDialectAndSetOnJpaSource() {
        JpaSource source = TestEnvironment.configureJpaSource("Test Repository", this);
        String expectedDialect = source.getDialect();
        source.setDialect(null);
        RepositoryConnection connection = null;
        try {
            connection = source.getConnection();
            Assert.assertThat((Object)source.getDialect(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            if (expectedDialect != null) {
                if (expectedDialect.toLowerCase().contains("mysql")) {
                    Assert.assertThat((Object)source.getDialect().toLowerCase().contains("mysql"), (Matcher)Is.is((Object)true));
                } else {
                    Assert.assertThat((Object)source.getDialect(), (Matcher)Is.is((Object)expectedDialect));
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

