/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.TestEnvironment;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Workspace;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.WorkspaceConnectorTest;

public class JpaConnectorCreateWorkspacesTest
extends WorkspaceConnectorTest {
    protected String[] predefinedWorkspaces;

    protected RepositorySource setUpSource() {
        this.predefinedWorkspaces = new String[]{"default", "workspace1", "workspace2", "workspace3"};
        JpaSource source = TestEnvironment.configureJpaSource("Test Repository", (Object)this);
        source.setCreatingWorkspacesAllowed(false);
        source.setPredefinedWorkspaceNames(this.predefinedWorkspaces);
        return source;
    }

    protected void initializeContent(Graph graph) {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 4;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        for (String workspaceName : this.predefinedWorkspaces) {
            graph.useWorkspace(workspaceName);
            this.createSubgraph(graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, null, null);
        }
    }

    protected String[] generateInvalidNamesForNewWorkspaces() {
        return null;
    }

    protected String[] generateValidNamesForNewWorkspaces() {
        return new String[]{"new workspace1", "new workspace2", "new workspace3", "new workspace4"};
    }

    @Test
    public void shouldReturnListOfWorkspaces() {
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : this.graph.getWorkspaces()) {
            Workspace workspace = this.graph.useWorkspace(workspaceName);
            workspaceNames.add(workspace.getName());
        }
        for (String expectedName : this.predefinedWorkspaces) {
            Assert.assertThat((Object)workspaceNames.remove(expectedName), (Matcher)Is.is((Object)true));
        }
        Assert.assertThat((Object)workspaceNames.isEmpty(), (Matcher)Is.is((Object)true));
        workspaceNames = new HashSet(this.graph.getWorkspaces());
        for (String expectedName : this.predefinedWorkspaces) {
            Assert.assertThat((Object)workspaceNames.remove(expectedName), (Matcher)Is.is((Object)true));
        }
        Assert.assertThat((Object)workspaceNames.isEmpty(), (Matcher)Is.is((Object)true));
    }
}

