/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.ArrayList;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.connector.store.jpa.HibernateAdapter;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.TestEnvironment;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;

public class JpaSourceTest {
    private JpaSource source;
    private RepositoryConnection connection;

    @Before
    public void beforeEach() throws Exception {
        this.source = TestEnvironment.configureJpaSource("Test Repository", this);
        this.source.setDefaultWorkspaceName("default");
        this.source.setCreatingWorkspacesAllowed(true);
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldFailToCreateConnectionIfSourceHasNoName() {
        this.source.setName(null);
        this.source.getConnection();
    }

    @Test
    public void shouldHaveNoDefaultModelUponConstruction() {
        JpaSource source = new JpaSource();
        Assert.assertThat((Object)source.getModel(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCreateConnection() throws Exception {
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowMultipleConnectionsToBeOpenAtTheSameTime() throws Exception {
        ArrayList<RepositoryConnection> connections = new ArrayList<RepositoryConnection>();
        try {
            for (int i = 0; i != 10; ++i) {
                RepositoryConnection conn = this.source.getConnection();
                Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                connections.add(conn);
            }
        }
        finally {
            for (RepositoryConnection conn : connections) {
                if (conn == null) continue;
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Test
    @FixFor(value={"MODE-1102"})
    public void shouldDefaultAutoGenerateSchemaValueToValidate() {
        this.source = new JpaSource();
        this.source.setName("Some name");
        Assert.assertThat((Object)this.source.getAutoGenerateSchema(), (Matcher)Is.is((Object)"validate"));
        HibernateAdapter adapter = new HibernateAdapter();
        Properties config = adapter.getProperties(this.source);
        Assert.assertThat((Object)config.get("hibernate.hbm2ddl.auto").toString(), (Matcher)Is.is((Object)"validate"));
    }

    @Test
    @FixFor(value={"MODE-1102"})
    public void shouldTreatNullValueForAutoGenerateSchemaAsDefault() {
        this.source = new JpaSource();
        this.source.setName("Some name");
        this.source.setAutoGenerateSchema(null);
        Assert.assertThat((Object)this.source.getAutoGenerateSchema(), (Matcher)Is.is((Object)"validate"));
        HibernateAdapter adapter = new HibernateAdapter();
        Properties config = adapter.getProperties(this.source);
        Assert.assertThat((Object)config.get("hibernate.hbm2ddl.auto").toString(), (Matcher)Is.is((Object)"validate"));
    }

    @Test
    @FixFor(value={"MODE-1102"})
    public void shouldValidStringValueForAutoGenerateSchemaAsDisable() {
        String[] values;
        for (String value : values = new String[]{"create", "create-drop", "update", "validate"}) {
            this.source = new JpaSource();
            this.source.setName("Some name");
            this.source.setAutoGenerateSchema(value);
            Assert.assertThat((Object)this.source.getAutoGenerateSchema(), (Matcher)Is.is((Object)value));
            HibernateAdapter adapter = new HibernateAdapter();
            Properties config = adapter.getProperties(this.source);
            Assert.assertThat((Object)config.get("hibernate.hbm2ddl.auto").toString(), (Matcher)Is.is((Object)value));
        }
    }

    @Test
    @FixFor(value={"MODE-1102"})
    public void shouldTreatEmptyStringValueForAutoGenerateSchemaAsDefault() {
        this.source = new JpaSource();
        this.source.setName("Some name");
        this.source.setAutoGenerateSchema("");
        Assert.assertThat((Object)this.source.getAutoGenerateSchema(), (Matcher)Is.is((Object)"validate"));
        HibernateAdapter adapter = new HibernateAdapter();
        Properties config = adapter.getProperties(this.source);
        Assert.assertThat((Object)config.get("hibernate.hbm2ddl.auto").toString(), (Matcher)Is.is((Object)"validate"));
    }

    @Test
    @FixFor(value={"MODE-1102"})
    public void shouldTreatUpperCaseDisableStringValueForAutoGenerateSchemaAsDisable() {
        this.source = new JpaSource();
        this.source.setName("Some name");
        this.source.setAutoGenerateSchema("disable".toUpperCase());
        Assert.assertThat((Object)this.source.getAutoGenerateSchema(), (Matcher)Is.is((Object)"disable"));
        HibernateAdapter adapter = new HibernateAdapter();
        Properties config = adapter.getProperties(this.source);
        Assert.assertThat((Object)config.get("hibernate.hbm2ddl.auto"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }
}

