/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.io.IOException;
import java.util.Properties;
import org.modeshape.connector.store.jpa.JpaSource;

public class TestEnvironment {
    public static JpaSource configureJpaSource(String sourceName, Object testCase) {
        Properties properties = new Properties();
        ClassLoader loader = testCase instanceof Class ? ((Class)testCase).getClassLoader() : testCase.getClass().getClassLoader();
        try {
            properties.load(loader.getResourceAsStream("database.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JpaSource source = new JpaSource();
        source.setName(sourceName);
        source.setDialect(properties.getProperty("jpaSource.dialect"));
        source.setDriverClassName(properties.getProperty("jpaSource.driverClassName"));
        source.setUsername(properties.getProperty("jpaSource.username"));
        source.setPassword(properties.getProperty("jpaSource.password"));
        source.setUrl(properties.getProperty("jpaSource.url"));
        String value = properties.getProperty("jpaSource.maximumConnectionsInPool");
        if (TestEnvironment.isValue(value)) {
            source.setMaximumConnectionsInPool(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.minimumConnectionsInPool"))) {
            source.setMinimumConnectionsInPool(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.maximumSizeOfStatementCache"))) {
            source.setMaximumSizeOfStatementCache(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.maximumConnectionIdleTimeInSeconds"))) {
            source.setMaximumConnectionIdleTimeInSeconds(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.largeValueSizeInBytes"))) {
            source.setLargeValueSizeInBytes(Long.parseLong(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.autoGenerateSchema"))) {
            source.setAutoGenerateSchema(value);
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.compressData"))) {
            source.setCompressData(Boolean.parseBoolean(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.cacheTimeToLiveInMilliseconds"))) {
            source.setCacheTimeToLiveInMilliseconds(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.creatingWorkspacesAllowed"))) {
            source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.defaultWorkspaceName"))) {
            source.setDefaultWorkspaceName(value);
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.predefinedWorkspaceNames"))) {
            source.setPredefinedWorkspaceNames(TestEnvironment.splitValues(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.model"))) {
            source.setModel(value);
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.numberOfConnectionsToAcquireAsNeeded"))) {
            source.setNumberOfConnectionsToAcquireAsNeeded(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.referentialIntegrityEnforced"))) {
            source.setReferentialIntegrityEnforced(Boolean.parseBoolean(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.retryLimit"))) {
            source.setRetryLimit(Integer.parseInt(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.rootNodeUuid"))) {
            source.setRootNodeUuid(value);
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.showSql"))) {
            source.setShowSql(Boolean.parseBoolean(value));
        }
        if (TestEnvironment.isValue(value = properties.getProperty("jpaSource.jpaCacheProviderClassName"))) {
            source.setDefaultWorkspaceName(value);
        }
        return source;
    }

    protected static boolean isValue(String value) {
        return value != null && value.trim().length() != 0;
    }

    protected static String[] splitValues(String value) {
        String[] results = value.split(", ");
        for (int i = 0; i != results.length; ++i) {
            results[i] = results[i].trim();
            results[i] = results[i].replaceFirst("^['\"]+", "").replaceAll("['\"]+$", "").trim();
        }
        return results;
    }
}

