/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.PathSegment;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.Types;

public class PathParamInjector
implements ValueInjector {
    private StringParameterInjector extractor;
    private String paramName;
    private boolean encode;
    private Class type;
    private boolean pathSegment = false;
    private boolean pathSegmentArray = false;
    private boolean pathSegmentList = false;

    public PathParamInjector(Class type, Type genericType, AccessibleObject target, String paramName, String defaultValue, boolean encode, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        if (this.isPathSegmentArray(type)) {
            this.pathSegmentArray = true;
        } else if (this.isPathSegmentList(type, genericType)) {
            this.pathSegmentList = true;
        } else if (type.equals(PathSegment.class)) {
            this.pathSegment = true;
        } else {
            this.extractor = new StringParameterInjector(type, genericType, paramName, PathParam.class, defaultValue, target, annotations, factory);
        }
        this.paramName = paramName;
        this.encode = encode;
    }

    private boolean isPathSegmentArray(Class type) {
        return type.isArray() && type.getComponentType().equals(PathSegment.class);
    }

    private boolean isPathSegmentList(Class type, Type genericType) {
        Class collectionBaseType = Types.getCollectionBaseType(type, genericType);
        return List.class.equals((Object)type) && collectionBaseType != null && collectionBaseType.equals(PathSegment.class);
    }

    public Object inject(HttpRequest request, HttpResponse response) {
        if (this.extractor == null) {
            UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
            List list = null;
            list = this.encode ? (List)uriInfo.getEncodedPathParameterPathSegments().get(this.paramName) : (List)uriInfo.getPathParameterPathSegments().get(this.paramName);
            if (list == null) {
                throw new InternalServerErrorException("Unknown @PathParam: " + this.paramName + " for path: " + uriInfo.getPath());
            }
            PathSegment[] segments = (PathSegment[])list.get(list.size() - 1);
            if (this.pathSegmentArray) {
                return segments;
            }
            if (this.pathSegmentList) {
                ArrayList<PathSegment> pathlist = new ArrayList<PathSegment>();
                for (PathSegment seg : segments) {
                    pathlist.add(seg);
                }
                return pathlist;
            }
            return segments[segments.length - 1];
        }
        List list = (List)request.getUri().getPathParameters(!this.encode).get(this.paramName);
        if (list == null) {
            throw new InternalServerErrorException("Unknown @PathParam: " + this.paramName + " for path: " + request.getUri().getPath());
        }
        if (this.extractor.isCollectionOrArray()) {
            return this.extractor.extractValues(list);
        }
        return this.extractor.extractValue((String)list.get(list.size() - 1));
    }

    public Object inject() {
        throw new RuntimeException("It is illegal to inject a @PathParam into a singleton");
    }
}

