/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.tjws;

import Acme.Serve.SSLAcceptor;
import Acme.Serve.Serve;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TJWSServletServer {
    protected Serve server = new Serve();
    protected Properties props = new Properties();
    private static final Logger logger = LoggerFactory.getLogger(TJWSServletServer.class);

    public void addServlet(String bindPath, HttpServlet servlet) {
        this.server.addServlet(bindPath, (Servlet)servlet);
    }

    public void addServlet(String bindPath, HttpServlet servlet, Hashtable initParams) {
        this.server.addServlet(bindPath, (Servlet)servlet, initParams);
    }

    public void setProps(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public void setPort(int port) {
        this.props.put("port", (Object)port);
    }

    public void setBindAddress(String address) {
        this.props.put("bind-address", address);
    }

    public void setSessionTimeout(long timeout) {
        this.props.put("session-timeout", Long.toString(timeout));
    }

    public void setKeepAlive(boolean keepAlive) {
        this.props.put("keep-alive", Boolean.toString(keepAlive));
    }

    public void setKeepAliveTimeout(long timeout) {
        this.props.put("timeout-keep-alive", Long.toString(timeout));
    }

    public void setMaxKeepAliveConnections(int max) {
        this.props.put("max-alive-conn-use", Integer.toString(max));
    }

    public void setThreadPoolSize(int max) {
        this.props.put("Acme.Utils.ThreadPool.maxpooledthreads", Integer.toString(max));
    }

    public void setSSLAlgorithm(String algorithm) {
        this.props.put("algorithm", algorithm);
    }

    public void setSSLKeyStoreFile(String path) {
        this.props.put("keystoreFile", path);
    }

    public void setSSLKeyStorePass(String passwd) {
        this.props.put("keystorePass", passwd);
    }

    public void setSSLKeyStoreType(String type) {
        this.props.put("keystoreType", type);
    }

    public void setSSLProtocol(String protocol) {
        this.props.put("protocol", protocol);
    }

    public void setSSLPort(int port) {
        this.props.put("ssl-port", Integer.toString(port));
    }

    public void start() {
        if (this.props == null) {
            this.props = new Properties();
        }
        if (!this.props.containsKey("port") && !this.props.containsKey("ssl-port")) {
            throw new RuntimeException("You must set the port or ssl port");
        }
        if (this.props.containsKey("port") && this.props.containsKey("ssl-port")) {
            throw new RuntimeException("You must set either the port or ssl port, not both");
        }
        if (this.props.containsKey("ssl-port")) {
            this.props.put("acceptorImpl", SSLAcceptor.class.getName());
        }
        this.props.setProperty("nohup", "nohup");
        this.server.arguments = this.props;
        this.server.addDefaultServlets(null);
        new Thread(){

            public void run() {
                try {
                    TJWSServletServer.this.server.serve();
                }
                catch (Exception e) {
                    logger.error("Failure in TJWS server", e);
                }
            }
        }.start();
    }

    public void stop() {
        try {
            this.server.notifyStop();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

