/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.federation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import junit.framework.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.test.ModeShapeSingleUseTest;

public class FederationMixedSourcesTest
extends ModeShapeSingleUseTest {
    private static final String FS_PROJECTION = "fs";
    private static final String JPA_PROJECTION = "jpa";
    private static final String INMEMORY_PROJECTION = "inmemory";
    private Session session;

    public void beforeEach() throws Exception {
        super.beforeEach();
        this.session = this.sessionTo("test-federated", "default");
    }

    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForFederatedMixedSources.xml";
    }

    @Test
    @FixFor(value={"MODE-1235"})
    public void shouldSupportReferenceableNodesAcrossSources() throws Exception {
        String referenceableNodeProjection = FS_PROJECTION;
        String targetNodeProjection = JPA_PROJECTION;
        String filePath = "/file_" + String.valueOf(System.currentTimeMillis());
        Node file = this.session.getRootNode().addNode(referenceableNodeProjection + filePath, "{http://www.jcp.org/jcr/nt/1.0}file");
        Node fileContent = file.addNode("jcr:content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        fileContent.setProperty("jcr:data", this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream("content".getBytes())));
        String testNodePath = "/testNode_" + String.valueOf(System.currentTimeMillis());
        this.session().getRootNode().addNode(targetNodeProjection + testNodePath);
        this.session.save();
        fileContent = this.session.getNode("/" + referenceableNodeProjection + filePath + "/jcr:content");
        fileContent.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        Node testNode = this.session.getNode("/" + targetNodeProjection + testNodePath);
        testNode.setProperty("contentRef", fileContent);
        this.session.save();
        Property contentRef = testNode.getProperty("contentRef");
        String fileContentUuid = fileContent.getProperty("jcr:uuid").getString();
        Assert.assertEquals((String)fileContentUuid, (String)contentRef.getString());
        Assert.assertNotNull((Object)contentRef.getNode());
        Assert.assertEquals((String)fileContentUuid, (String)contentRef.getNode().getIdentifier());
    }
}

