/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.property.basic.FileSystemBinary;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class FileSystemRepositoryScalabilityTest {
    private static final String TEST_REPOSITORY = "Source Code Repository";
    private static JcrConfiguration configuration;
    private static JcrEngine engine;
    private static List<Session> sessions;
    private boolean print = false;
    private Stopwatch sw;

    @BeforeClass
    public static void beforeAll() throws Exception {
        new FileSystemBinary(new File("."));
        configuration = new JcrConfiguration();
        configuration.loadFrom("src/test/resources/config/configRepositoryForSourceCodeFileSystem.xml");
        engine = configuration.build();
        try {
            engine.start();
        }
        catch (RuntimeException e) {
            System.err.println("There were problems starting the engine:");
            for (Problem problem : engine.getProblems()) {
                System.err.println(problem);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void afterAll() throws Exception {
        for (Session session : sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        sessions.clear();
        if (engine != null) {
            try {
                engine.shutdown();
            }
            finally {
                engine = null;
            }
        }
    }

    @Before
    public void beforeEach() {
        this.sw = new Stopwatch();
        this.print = false;
    }

    @Test
    public void shouldHaveContentInWorkspace() throws Exception {
        Session session = this.sessionFrom(engine, "modeshape-integration-tests");
        Node node1 = session.getRootNode().getNode("pom.xml");
        Assert.assertThat((Object)node1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node1.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:file"));
        Node node1Content = node1.getNode(this.stringFrom(JcrLexicon.CONTENT));
        Assert.assertThat((Object)node1Content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node1Content.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)this.stringFrom(JcrNtLexicon.RESOURCE)));
    }

    @Test
    public void shouldAccessDirectoryWithManyFiles() throws Exception {
        this.print = true;
        Session session = this.sessionFrom(engine, "modeshape-integration-tests");
        this.sw.start();
        Node node1 = session.getNode("/src/test/resources/svn/local_repos/dummy_svn_repos/db/revprops");
        this.sw.stop();
        if (this.print) {
            System.out.println(this.sw);
        }
        Assert.assertThat((Object)node1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node1.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:folder"));
        Assert.assertThat((Object)node1.getNodes().getSize(), (Matcher)Is.is((Object)33L));
    }

    protected Session sessionFrom(JcrEngine engine, String workspace) throws RepositoryException {
        JcrRepository repository = engine.getRepository(TEST_REPOSITORY);
        Session session = repository.login(workspace);
        sessions.add(session);
        return session;
    }

    protected String stringFrom(Object object) {
        return (String)engine.getExecutionContext().getValueFactories().getStringFactory().create(object);
    }

    static {
        sessions = new ArrayList<Session>();
    }
}

