/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.performance;

import java.io.File;
import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.FileUtil;
import org.modeshape.test.ModeShapeSingleUseTest;

@RunWith(value=BMUnitRunner.class)
public class JcrEnginePerformanceTest
extends ModeShapeSingleUseTest {
    @Ignore
    @BMScript(value="jcr-configuration-failure", dir="src/test/byteman")
    @Test(expected=SecurityException.class)
    public void shouldThrowSecurityExceptionWhenBuildingEngine() throws Exception {
        this.startEngineUsing("config/configRepositoryForJdbc.xml");
    }

    @Ignore
    @BMScript(value="jcr-performance", dir="src/test/byteman")
    @Test
    public void shouldStartEngineAndRecordPerformanceTrace() throws Exception {
        this.startEngineUsing("config/configRepositoryForJdbc.xml");
        this.assertNode("/");
        this.assertNodeType("car:Car", false, false, true, false, null, 0, 11, new String[]{"nt:unstructured"});
        this.importContent("jdbc/cars-system-view-with-uuids.xml");
        this.session().save();
        this.print = true;
        this.printSubgraph(this.assertNode("/Cars"));
        this.logout();
        Node utility = this.session().getNode("/Cars/Utility");
        Assert.assertThat((Object)utility, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Ignore
    @BMScript(value="jcr-performance-check-permissions", dir="src/test/byteman")
    @Test
    public void shouldStartEngineAndGetRootNode() throws Exception {
        this.startEngineUsing("config/configRepositoryForJdbc.xml");
        this.assertNode("/");
    }

    @Test
    public void shouldStartUpQuicklyAfterBeingShutdown() throws Exception {
        File root = new File("./target/repoRoot");
        if (root.exists()) {
            FileUtil.delete((File)root);
        }
        root.mkdir();
        File indexDir = new File("./target/index");
        if (indexDir.exists()) {
            FileUtil.delete((File)indexDir);
        }
        Assert.assertThat((Object)indexDir.exists(), (Matcher)Is.is((Object)false));
        int FILE_CONTENT_SIZE = 1024;
        StringBuilder buff = new StringBuilder(1024);
        for (int x = 0; x < 1024; ++x) {
            buff.append('x');
        }
        String longString = buff.toString();
        Stopwatch sw = new Stopwatch();
        sw.start();
        this.startEngineUsing("config/configRepositoryForFileSystem.xml");
        Node rootNode = this.assertNode("/");
        sw.stop();
        System.out.println("Initial Startup (creating schema): " + sw);
        sw.reset();
        sw.start();
        for (int i = 0; i < 10; ++i) {
            Node iNode = rootNode.addNode(String.valueOf(i), "nt:folder");
            for (int j = 0; j < 10; ++j) {
                Node jNode = iNode.addNode(String.valueOf(j), "nt:folder");
                for (int k = 0; k < 10; ++k) {
                    Node kNode = jNode.addNode(String.valueOf(k), "nt:file");
                    Node content = kNode.addNode("jcr:content", "mode:resource");
                    content.setProperty("jcr:data", longString);
                }
                this.session().save();
            }
        }
        sw.stop();
        System.out.println("Inserted nodes: " + sw);
        sw.reset();
        JcrEnginePerformanceTest.stopEngine();
        sw.start();
        System.out.println("Restarting engine...");
        this.startEngineUsing("config/configRepositoryForFileSystem.xml");
        this.assertNode("/");
        sw.stop();
        System.out.println("Subsequent Startup (no schema validation): " + sw);
    }
}

