/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.test.ModeShapeUnitTest;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class CndSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForCndSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldSequenceJsr283CndFile() throws Exception {
        this.uploadFile("sequencers/cnd/jsr_283_builtins.cnd", "/files/");
        String path = "/sequenced/cnd/jsr_283_builtins.cnd";
        Node cnd = this.waitUntilSequencedNodeIsAvailable(path, "nt:unstructured", new String[0]);
        this.printSubgraph(cnd);
        Node file1 = this.assertNode(path + "/nt:activity", "nt:nodeType", new String[]{"mode:derived"});
        Assert.assertThat((Object)file1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/files", "nt:folder", new String[0]);
        this.assertNode("/files/jsr_283_builtins.cnd", "nt:file", new String[0]);
        this.assertNode("/files/jsr_283_builtins.cnd/jcr:content");
        this.assertNode("/sequenced/cnd", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/cnd/jsr_283_builtins.cnd");
        this.printQuery("SELECT * FROM [nt:nodeType]", 34L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:propertyDefinition]", 86L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:childNodeDefinition]", 10L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    public void shouldSequenceJsr283CndFileBelowSequencedPath() throws Exception {
        this.uploadFile("sequencers/cnd/jsr_283_builtins.cnd", "/files/a/b");
        String path = "/sequenced/cnd/a/b/jsr_283_builtins.cnd";
        Node cnd = this.waitUntilSequencedNodeIsAvailable(path, "nt:unstructured", new String[0]);
        this.printSubgraph(cnd);
        Node file1 = this.assertNode(path + "/nt:activity", "nt:nodeType", new String[]{"mode:derived"});
        Assert.assertThat((Object)file1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/files", "nt:folder", new String[0]);
        this.assertNode("/files/a", "nt:folder", new String[0]);
        this.assertNode("/files/a/b", "nt:folder", new String[0]);
        this.assertNode("/files/a/b/jsr_283_builtins.cnd", "nt:file", new String[0]);
        this.assertNode("/files/a/b/jsr_283_builtins.cnd/jcr:content");
        this.assertNode("/sequenced/cnd", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/cnd/a", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/cnd/a/b", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/cnd/a/b/jsr_283_builtins.cnd");
        this.printQuery("SELECT * FROM [nt:nodeType]", 34L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:propertyDefinition]", 86L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:childNodeDefinition]", 10L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    @FixFor(value={"MODE-1073"})
    public void shouldNotCreateExtraIntermediateNodesWhenUploadingAndSequencingMultipleFiles() throws Exception {
        this.uploadFile("sequencers/cnd/jsr_283_builtins.cnd", "/files/a/b");
        this.uploadFile("sequencers/cnd/images.cnd", "/files/a/b");
        String path = "/sequenced/cnd/a/b/jsr_283_builtins.cnd";
        String path2 = "/sequenced/cnd/a/b/images.cnd";
        Node cnd = this.waitUntilSequencedNodeIsAvailable(path, "nt:unstructured", new String[0]);
        Node cnd2 = this.waitUntilSequencedNodeIsAvailable(path2, "nt:unstructured", new String[0]);
        this.printSubgraph(cnd);
        this.printSubgraph(cnd2);
        Node file1 = this.assertNode(path + "/nt:activity", "nt:nodeType", new String[]{"mode:derived"});
        Assert.assertThat((Object)file1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNode("/files", "nt:folder", new String[0]);
        this.assertNode("/files/a", "nt:folder", new String[0]);
        this.assertNode("/files/a/b", "nt:folder", new String[0]);
        this.assertNode("/files/a/b/jsr_283_builtins.cnd", "nt:file", new String[0]);
        this.assertNode("/files/a/b/jsr_283_builtins.cnd/jcr:content");
        this.assertNode("/sequenced/cnd", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/cnd/a", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/cnd/a/b", "nt:unstructured", new String[0]);
        this.assertNode("/sequenced/cnd/a/b/jsr_283_builtins.cnd");
        this.assertNode("/sequenced/cnd/a/b/images.cnd");
        this.assertNoNode("/sequenced/cnd[2]");
        this.assertNoNode("/sequenced/cnd/a[2]");
        this.assertNoNode("/sequenced/cnd/a/b[2]");
    }
}

