/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class MSOfficeSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForTextExtraction.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldStartEngineWithRegisteredMSOfficeNodeTypes() throws Exception {
        this.assertNodeType("msoffice:metadata", false, false, true, false, null, 3, 18, new String[]{"nt:unstructured", "mix:mimeType"});
    }

    @Test
    public void shouldSequenceWordDocument() throws Exception {
        this.uploadAndAssertSequencedNode("word.doc");
    }

    @Test
    public void shouldSequenceExcelDocument() throws Exception {
        this.uploadAndAssertSequencedNode("excel.xls");
    }

    @Test
    public void shouldSequencePowerpointDocument() throws Exception {
        this.uploadAndAssertSequencedNode("powerpoint.ppt");
    }

    private void uploadAndAssertSequencedNode(String fileName) throws RepositoryException, IOException, InterruptedException {
        this.uploadFile("sequencers/msoffice/" + fileName, "/files/");
        this.waitUntilSequencingFinishes();
        Node sequenced = this.session().getNode("/sequenced");
        Assert.assertThat((Object)sequenced, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.printSubgraph(sequenced);
        Node node = this.waitUntilSequencedNodeIsAvailable("/sequenced/msoffice/" + fileName, "nt:unstructured", new String[0]);
        Assert.assertNotNull((Object)node);
        this.printSubgraph(node);
        AbstractSequencerTest.SequencedNodeValidator.validateSequencedNodeType(node);
    }
}

