/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import javax.jcr.Node;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.test.ModeShapeUnitTest;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class TeiidSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForTeiidSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldStartEngineWithRegisteredTeiidNodeTypes() throws Exception {
        this.assertNodeType("relational:column", false, false, true, false, null, 0, 42, new String[]{"nt:unstructured", "relational:relationalEntity"});
        this.assertNodeType("relational:baseTable", false, false, true, true, null, 0, 0, new String[]{"relational:table"});
        this.assertNodeTypes(new String[]{"relational:relationalEntity", "relational:column", "relational:columnSet", "relational:uniqueKey", "relational:primaryKey", "relational:foreignKey", "vdb:virtualDatabase", "vdb:model", "jdbcs:imported"});
    }

    @Test
    public void shouldSequenceQuickEmployeesVdbWithoutVersionNumberInFileName() throws Exception {
        this.uploadFile("sequencers/teiid/vdb/qe.vdb", "/files/");
        this.waitUntilSequencingFinishes();
        Node vdb = this.waitUntilSequencedNodeIsAvailable("/sequenced/teiid/vdbs/qe", "vdb:virtualDatabase", new String[]{"mix:referenceable", "mode:derived"});
        this.printSubgraph(vdb);
        this.printQuery("SELECT * FROM [vdb:virtualDatabase]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [vdb:model]", 3L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:table]", 2L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:column]", 30L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:primaryKey]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:foreignKey]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedure]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureParameter]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureResult]", 1L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    public void shouldSequenceQuickEmployeesVdbWithoutVersionNumberInFileNameUploadedBelowSequencingPath() throws Exception {
        this.uploadFile("sequencers/teiid/vdb/qe.vdb", "/files/my/favorites");
        this.waitUntilSequencingFinishes();
        Node vdb = this.waitUntilSequencedNodeIsAvailable("/sequenced/teiid/vdbs/my/favorites/qe", "vdb:virtualDatabase", new String[]{"mix:referenceable", "mode:derived"});
        this.printSubgraph(vdb);
        this.printQuery("SELECT * FROM [vdb:virtualDatabase]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [vdb:model]", 3L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:table]", 2L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:column]", 30L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:primaryKey]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:foreignKey]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedure]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureParameter]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureResult]", 1L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    public void shouldSequencePartsFromXmlVdb() throws Exception {
        this.uploadFile("sequencers/teiid/vdb/PartsFromXml.vdb", "/files/");
        this.waitUntilSequencingFinishes();
        Node vdb = this.waitUntilSequencedNodeIsAvailable("/sequenced/teiid/vdbs/PartsFromXml", "vdb:virtualDatabase", new String[]{"mix:referenceable", "mode:derived"});
        this.printSubgraph(vdb);
        this.printQuery("SELECT * FROM [vdb:virtualDatabase]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [vdb:model]", 2L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:table]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:column]", 6L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:primaryKey]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:foreignKey]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedure]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureParameter]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureResult]", 1L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    public void shouldSequenceYahooUdfTestVdb() throws Exception {
        this.uploadFile("sequencers/teiid/vdb/YahooUdfTest.vdb", "/files/");
        this.waitUntilSequencingFinishes();
        Node vdb = this.waitUntilSequencedNodeIsAvailable("/sequenced/teiid/vdbs/YahooUdfTest", "vdb:virtualDatabase", new String[]{"mix:referenceable", "mode:derived"});
        this.printSubgraph(vdb);
        this.printQuery("SELECT * FROM [vdb:virtualDatabase]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [vdb:model]", 4L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:table]", 7L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:column]", 55L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:primaryKey]", 6L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:foreignKey]", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedure]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureParameter]", 0L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [relational:procedureResult]", 0L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    @FixFor(value={"MODE-860"})
    public void shouldFindVdbsUsingQueryWithMultipleVariables() throws Exception {
        String[] vdbFiles = new String[]{"YahooUdfTest.vdb", "qe.vdb", "qe.2.vdb", "qe.3.vdb", "qe.4.vdb", "PartsFromXml.vdb"};
        this.uploadVdbs("/files/", vdbFiles);
        Node files = this.waitUntilSequencedNodeIsAvailable("/files");
        this.printSubgraph(files, 5);
        this.waitUntilSequencedNodesIs(vdbFiles.length, 20);
        this.session().refresh(false);
        Node vdbs = this.waitUntilSequencedNodeIsAvailable("/sequenced");
        this.printSubgraph(vdbs, 4);
        this.printQuery("SELECT * FROM [nt:file] WHERE PATH() LIKE '/file*/*.vdb'", 6L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:file] WHERE PATH() LIKE '*/Yah*.vdb'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:file] WHERE PATH() LIKE '/files/q*.vdb'", 4L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:file] WHERE PATH() LIKE '/files/q*.2.vdb'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT file.*,content.* FROM [nt:file] AS file JOIN [nt:resource] AS content ON ISCHILDNODE(content,file) WHERE PATH(file) LIKE '/files/q*.2.vdb'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT file.*,content.[jcr:lastModified],content.[jcr:lastModifiedBy] FROM [nt:file] AS file JOIN [nt:resource] AS content ON ISCHILDNODE(content,file) WHERE PATH(file) LIKE '/files/q*.2.vdb'", 1L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:file] WHERE PATH() LIKE $path", 1L, new ModeShapeUnitTest.Variable[]{this.var("path", "/files/q*.2.vdb")});
        this.printQuery("SELECT [jcr:primaryType],[jcr:created],[jcr:createdBy] FROM [nt:file] WHERE PATH() LIKE $path", 1L, new ModeShapeUnitTest.Variable[]{this.var("path", "/files/q*.2.vdb")});
        this.printQuery("SELECT [jcr:primaryType],[jcr:created],[jcr:createdBy] FROM [nt:file] WHERE PATH() IN ( SELECT [vdb:originalFile] FROM [vdb:virtualDatabase] WHERE [vdb:version] BETWEEN $minVersion AND $maxVersion )", 3L, new ModeShapeUnitTest.Variable[]{this.var("minVersion", "2"), this.var("maxVersion", "5")});
        this.printQuery("SELECT [jcr:primaryType],[jcr:created],[jcr:createdBy] FROM [nt:file] WHERE PATH() IN ( SELECT [vdb:originalFile] FROM [vdb:virtualDatabase] WHERE [vdb:version] <= $maxVersion AND CONTAINS([vdb:description],'xml OR maybe'))", 4L, new ModeShapeUnitTest.Variable[]{this.var("description", "*"), this.var("maxVersion", "3")});
        this.printQuery("SELECT [jcr:primaryType],[jcr:created],[jcr:createdBy] FROM [nt:file] WHERE PATH() IN ( SELECT [vdb:originalFile] FROM [vdb:virtualDatabase] WHERE [vdb:version] <= $maxVersion AND CONTAINS([vdb:description],'xml maybe'))", 1L, new ModeShapeUnitTest.Variable[]{this.var("description", "*"), this.var("maxVersion", "3")});
        this.printQuery("SELECT [jcr:primaryType],[jcr:created],[jcr:createdBy] FROM [nt:file] WHERE PATH() IN ( SELECT [vdb:originalFile] FROM [vdb:virtualDatabase] WHERE [vdb:version] <= $maxVersion AND CONTAINS([vdb:description],'xml OR xml maybe'))", 4L, new ModeShapeUnitTest.Variable[]{this.var("description", "*"), this.var("maxVersion", "3")});
    }

    protected void uploadVdbs(String destinationPath, String ... resourcePaths) throws Exception {
        for (String resourcePath : resourcePaths) {
            this.uploadFile("sequencers/teiid/vdb/" + resourcePath, destinationPath);
        }
    }
}

