/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.test.ModeShapeUnitTest;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class ZipSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForZipSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldStartEngineWithRegisteredZipNodeTypes() throws Exception {
        this.assertNodeType("zip:content", false, false, true, false, null, 2, 0, new String[]{"nt:unstructured", "mix:mimeType"});
    }

    @Test
    public void shouldSequenceZipFile() throws Exception {
        this.uploadFile("sequencers/zip/test-files.zip", "/files/");
        String path = "/sequenced/zip/test-files.zip";
        Node zipped = this.waitUntilSequencedNodeIsAvailable(path, "zip:file", new String[]{"mode:derived"});
        Node file1 = this.assertNode(path + "/MODE-966-fix.patch", "nt:file", new String[0]);
        Node data1 = this.assertNode(path + "/MODE-966-fix.patch/jcr:content", "nt:resource", new String[0]);
        Node fold1 = this.assertNode(path + "/testFolder", "nt:folder", new String[0]);
        Node file2 = this.assertNode(path + "/testFolder/MODE-962-fix.patch", "nt:file", new String[0]);
        Node data2 = this.assertNode(path + "/testFolder/MODE-962-fix.patch/jcr:content", "nt:resource", new String[0]);
        Node fold3 = this.assertNode(path + "/testFolder/testInnerFolder", "nt:folder", new String[0]);
        Node file4 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix.patch", "nt:file", new String[0]);
        Node data4 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix.patch/jcr:content", "nt:resource", new String[0]);
        Node file5 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix2.patch", "nt:file", new String[0]);
        Node data5 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix2.patch/jcr:content", "nt:resource", new String[0]);
        Assert.assertThat((Object)file1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)file2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)fold1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)fold3, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)file4, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data4, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)file5, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data5, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.printSubgraph(zipped);
        this.printQuery("SELECT * FROM [nt:file]", 5L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:folder]", 4L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [zip:file]", 1L, new ModeShapeUnitTest.Variable[0]);
    }

    @Test
    public void shouldSequenceZipFileBelowSequencedPath() throws Exception {
        this.uploadFile("sequencers/zip/test-files.zip", "/files/a/b");
        String path = "/sequenced/zip/a/b/test-files.zip";
        Node zipped = this.waitUntilSequencedNodeIsAvailable(path, "zip:file", new String[]{"mode:derived"});
        Node file1 = this.assertNode(path + "/MODE-966-fix.patch", "nt:file", new String[0]);
        Node data1 = this.assertNode(path + "/MODE-966-fix.patch/jcr:content", "nt:resource", new String[0]);
        Node fold1 = this.assertNode(path + "/testFolder", "nt:folder", new String[0]);
        Node file2 = this.assertNode(path + "/testFolder/MODE-962-fix.patch", "nt:file", new String[0]);
        Node data2 = this.assertNode(path + "/testFolder/MODE-962-fix.patch/jcr:content", "nt:resource", new String[0]);
        Node fold3 = this.assertNode(path + "/testFolder/testInnerFolder", "nt:folder", new String[0]);
        Node file4 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix.patch", "nt:file", new String[0]);
        Node data4 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix.patch/jcr:content", "nt:resource", new String[0]);
        Node file5 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix2.patch", "nt:file", new String[0]);
        Node data5 = this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix2.patch/jcr:content", "nt:resource", new String[0]);
        Assert.assertThat((Object)file1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)file2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)fold1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)fold3, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)file4, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data4, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)file5, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)data5, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.printSubgraph(zipped);
        this.printSubgraph(this.assertNode("/sequenced/zip"));
        this.printQuery("SELECT * FROM [nt:file]", 5L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [nt:folder]", 6L, new ModeShapeUnitTest.Variable[0]);
        this.printQuery("SELECT * FROM [zip:file]", 1L, new ModeShapeUnitTest.Variable[0]);
    }
}

