/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import java.io.InputStream;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.xsd.XsdSequencer;

public class XsdSequencerTest {
    private ExecutionContext execContext;
    private MockSequencerOutput output;
    private StreamSequencerContext context;
    private static XsdSequencer sequencer;
    private boolean print;

    @Before
    public void beforeEach() {
        this.print = false;
        this.execContext = new ExecutionContext();
        this.execContext.getNamespaceRegistry().register("xsd", "http://www.w3.org/2001/XMLSchema");
        this.execContext.getNamespaceRegistry().register("sramp", "http://s-ramp.org/xmlns/2010/s-ramp");
        if (sequencer == null) {
            sequencer = new XsdSequencer();
        }
    }

    @After
    public void afterEach() {
        System.out.flush();
        System.err.flush();
        this.context = null;
        this.output = null;
    }

    protected void sequence(String pathToFile) {
        InputStream stream = this.load(pathToFile);
        this.context = new MockSequencerContext(this.execContext, pathToFile);
        this.output = new MockSequencerOutput(this.context, true);
        sequencer.sequence(stream, (SequencerOutput)this.output, this.context);
        if (this.context.getProblems().hasProblems()) {
            System.out.println(this.context.getProblems());
            Assert.fail((String)("At least one problem sequencing \"" + pathToFile + "\""));
        }
    }

    @Test
    public void shouldBeAbleToParseXsdForStockQuote() {
        this.sequence("stockQuote.xsd");
        this.print = true;
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdForUddiV3() {
        this.sequence("uddi_v3.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdForUddiV3ASecondTime() {
        this.sequence("uddi_v3.xsd");
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter01() {
        this.sequence("definitiveXmlSchema/chapter01.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03env() {
        this.sequence("definitiveXmlSchema/chapter03env.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03ord() {
        this.sequence("definitiveXmlSchema/chapter03ord.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03prod() {
        this.sequence("definitiveXmlSchema/chapter03prod.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter03prod2() {
        this.sequence("definitiveXmlSchema/chapter03prod.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter04ord1() {
        this.sequence("definitiveXmlSchema/chapter04ord1.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter04ord2() {
        this.sequence("definitiveXmlSchema/chapter04ord2.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter04prod() {
        this.sequence("definitiveXmlSchema/chapter04prod.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter05ord() {
        this.sequence("definitiveXmlSchema/chapter05ord.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter05prod() {
        this.sequence("definitiveXmlSchema/chapter05prod.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter07() {
        this.sequence("definitiveXmlSchema/chapter07.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter08() {
        this.sequence("definitiveXmlSchema/chapter08.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter09() {
        this.sequence("definitiveXmlSchema/chapter09.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter11() {
        this.sequence("definitiveXmlSchema/chapter11.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter13() {
        this.sequence("definitiveXmlSchema/chapter13.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter14() {
        this.sequence("definitiveXmlSchema/chapter14.xsd");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParseXsdFromDefinitiveXmlSchemaExampleChapter15() {
        this.sequence("definitiveXmlSchema/chapter15.xsd");
        this.printOutput();
    }

    protected void printOutput() {
        if (this.print) {
            for (Path path : this.output.getOrderOfCreation()) {
                Map props = this.output.getProperties(path);
                for (Map.Entry entry : props.entrySet()) {
                    System.out.println(this.string(path) + " " + ((Property)entry.getValue()).getString(this.context.getNamespaceRegistry()));
                }
            }
        }
    }

    protected InputStream load(String resourcePath) {
        InputStream stream = this.getClass().getResourceAsStream("/" + resourcePath);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        return stream;
    }

    protected final Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected final Path relativePath(Name ... segments) {
        return this.context.getValueFactories().getPathFactory().createRelativePath(segments);
    }

    protected final String string(String path) {
        return (String)this.context.getValueFactories().getStringFactory().create(path);
    }

    protected final String string(Object value) {
        return (String)this.context.getValueFactories().getStringFactory().create(value);
    }

    protected final Name name(String path) {
        return (Name)this.context.getValueFactories().getNameFactory().create(path);
    }
}

