/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrTest;
import org.modeshape.jcr.SessionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionCacheTest2
extends AbstractJcrTest {
    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @Override
    protected String getResourceNameOfXmlFileToImport() {
        return "vehicles.xml";
    }

    protected void walkInfosForNodesUnder(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node, Stopwatch sw) throws Exception {
        for (GraphSession.Node child : node.getChildren()) {
            sw.start();
            child.getPath();
            sw.stop();
            this.walkInfosForNodesUnder((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)child, sw);
        }
    }

    @Test
    public void shouldFindInfoForAllNodesInGraph() throws Exception {
        for (int i = 0; i != 3; ++i) {
            this.numberOfConnections = 0;
            Stopwatch sw = new Stopwatch();
            sw.start();
            GraphSession.Node root = this.cache.findNode(null, this.path("/"));
            root.getPath();
            root.getPayload();
            sw.stop();
            this.walkInfosForNodesUnder((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)root, sw);
            System.out.println("Statistics for walking nodes using SessionCache: " + sw.getSimpleStatistics() + "  -> " + this.numberOfConnections);
        }
    }

    @Test
    public void shouldFindInfoForAllNodesInGraphWithLoadingDepthOf2() throws Exception {
        this.cache.graphSession().setDepthForLoadingNodes(2);
        for (int i = 0; i != 3; ++i) {
            this.numberOfConnections = 0;
            Stopwatch sw = new Stopwatch();
            sw.start();
            GraphSession.Node root = this.cache.findNode(null, this.path("/"));
            root.getPath();
            root.getPayload();
            sw.stop();
            this.walkInfosForNodesUnder((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)root, sw);
            System.out.println("Statistics for walking nodes using SessionCache: " + sw.getSimpleStatistics() + "  -> " + this.numberOfConnections);
        }
    }

    @Test
    public void shouldFindInfoForAllNodesInGraphWithLoadingDepthOf4() throws Exception {
        this.cache.graphSession().setDepthForLoadingNodes(6);
        for (int i = 0; i != 3; ++i) {
            Stopwatch sw = new Stopwatch();
            this.numberOfConnections = 0;
            sw.start();
            GraphSession.Node root = this.cache.findNode(null, this.path("/"));
            root.getPath();
            root.getPayload();
            sw.stop();
            this.walkInfosForNodesUnder((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)root, sw);
            System.out.println("Statistics for walking nodes using SessionCache: " + sw.getSimpleStatistics() + "  -> " + this.numberOfConnections);
        }
    }
}

