/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.modeshape.connector.infinispan.RemoteInfinispanSource;
import org.modeshape.connector.infinispan.RemoteInfinispanTestHelper;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.ReadableConnectorTest;
import org.xml.sax.SAXException;

public class RemoteInfinispanConnectorReadableTest
extends ReadableConnectorTest {
    @BeforeClass
    public static void createContainer() throws Exception {
        RemoteInfinispanTestHelper.createServer();
    }

    @AfterClass
    public static void closeConnection() throws Exception {
        RemoteInfinispanTestHelper.releaseServer();
    }

    protected RepositorySource setUpSource() {
        String[] predefinedWorkspaceNames = new String[]{"aircraft", "cars"};
        RemoteInfinispanSource source = new RemoteInfinispanSource();
        source.setName("Test Repository");
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(false);
        source.setRemoteInfinispanServerList(String.format("%s:%s", RemoteInfinispanTestHelper.hostAddress(), RemoteInfinispanTestHelper.hostPort()));
        return source;
    }

    protected void initializeContent(Graph graph) throws IOException, SAXException {
        graph.useWorkspace("aircraft");
        graph.importXmlFrom(new File("src/test/resources/aircraft.xml")).into("/");
        graph.useWorkspace("cars");
        graph.importXmlFrom(new File("src/test/resources/cars.xml")).into("/");
    }
}

