/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Properties;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.Main;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.modeshape.common.util.FileUtil;

public class RemoteInfinispanTestHelper {
    protected static final int PORT = 11311;
    protected static final int TIMEOUT = 0;
    protected static final String CONFIG_FILE = "src/test/resources/infinispan_remote_config.xml";
    private static EmbeddedCacheManager cacheManager = null;
    private static HotRodServer server = null;
    private static int count = 0;

    public static synchronized HotRodServer createServer() throws IOException {
        ++count;
        if (server == null) {
            FileUtil.delete((File)new File("target/infinispan-remote/jcr"));
            FileUtil.delete((File)new File("target/infinispan-remote-cars/jcr"));
            FileUtil.delete((File)new File("target/infinispan-remote-aircraft/jcr"));
            cacheManager = TestCacheManagerFactory.fromXml((String)CONFIG_FILE);
            server = new HotRodServer();
            String hostAddress = RemoteInfinispanTestHelper.hostAddress();
            String hostPort = Integer.toString(RemoteInfinispanTestHelper.hostPort());
            String timeoutStr = Integer.toString(0);
            Properties props = new Properties();
            props.setProperty(Main.PROP_KEY_HOST(), hostAddress);
            props.setProperty(Main.PROP_KEY_PORT(), hostPort);
            props.setProperty(Main.PROP_KEY_IDLE_TIMEOUT(), timeoutStr);
            props.setProperty(Main.PROP_KEY_PROXY_HOST(), hostAddress);
            props.setProperty(Main.PROP_KEY_PROXY_PORT(), hostPort);
            server.start(props, cacheManager);
        }
        return server;
    }

    public static int hostPort() {
        return 11311;
    }

    public static String hostAddress() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet4Address) {
                return "127.0.0.1";
            }
            return "::1";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void releaseServer() {
        if (--count <= 0) {
            try {
                if (server != null) {
                    server.stop();
                }
                server = null;
            }
            catch (Throwable throwable) {
                server = null;
                TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
                FileUtil.delete((File)new File("target/infinispan-remote/jcr"));
                FileUtil.delete((File)new File("target/infinispan-remote-cars/jcr"));
                FileUtil.delete((File)new File("target/infinispan-remote-aircraft/jcr"));
                throw throwable;
            }
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            FileUtil.delete((File)new File("target/infinispan-remote/jcr"));
            FileUtil.delete((File)new File("target/infinispan-remote-cars/jcr"));
            FileUtil.delete((File)new File("target/infinispan-remote-aircraft/jcr"));
        }
    }
}

