/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.zip.ZipLexicon;
import org.modeshape.sequencer.zip.ZipSequencer;

public class ZipSequencerTest {
    private static final Logger LOGGER = Logger.getLogger(ZipSequencerTest.class);
    private InputStream zipStream;
    private MockSequencerContext seqContext;
    private MockSequencerOutput seqOutput;

    @Before
    public void beforeEach() {
        this.seqContext = new MockSequencerContext();
        this.seqOutput = new MockSequencerOutput((StreamSequencerContext)this.seqContext);
    }

    @After
    public void afterEach() throws Exception {
        this.logPotentialErrors();
        this.closeZipStream();
    }

    private void logPotentialErrors() {
        if (this.seqContext.getProblems().hasErrors()) {
            this.seqContext.getProblems().writeTo(LOGGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeZipStream() throws IOException {
        if (this.zipStream != null) {
            try {
                this.zipStream.close();
            }
            finally {
                this.zipStream = null;
            }
        }
    }

    @Test
    public void shouldBeAbleToExtractZip() {
        this.loadZipStream("testzip.zip");
        new ZipSequencer().sequence(this.zipStream, (SequencerOutput)this.seqOutput, (StreamSequencerContext)this.seqContext);
        PathFactory pathFactory = this.seqContext.getValueFactories().getPathFactory();
        NameFactory nameFactory = this.seqContext.getValueFactories().getNameFactory();
        ValueFactory stringFactory = this.seqContext.getValueFactories().getStringFactory();
        Name folderName = (Name)nameFactory.create("test subfolder");
        Name fileName = (Name)nameFactory.create("test2.txt");
        Path nodePath = pathFactory.createRelativePath(new Name[]{ZipLexicon.CONTENT, folderName, fileName, JcrLexicon.CONTENT});
        Property property = this.seqOutput.getProperty(nodePath, JcrLexicon.DATA);
        Assert.assertThat((Object)property, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)stringFactory.create(property.getFirstValue()), (Matcher)Is.is((Object)"This is a test content of file2\n"));
    }

    private void loadZipStream(String resourcePath) {
        this.zipStream = this.getClass().getResourceAsStream("/" + resourcePath);
        Assert.assertNotNull((Object)this.zipStream);
    }
}

