/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.NoSuchElementException;
import javax.jcr.NodeIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.JcrEmptyNodeIterator;

public class JcrEmptyNodeIteratorTest {
    private NodeIterator iter;

    @Before
    public void beforeEach() {
        this.iter = new JcrEmptyNodeIterator();
    }

    @Test
    public void shouldNotHaveNext() {
        Assert.assertThat((Object)this.iter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHavePositionOfZero() {
        Assert.assertThat((Object)this.iter.getPosition(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void shouldHaveSizeOfZero() {
        Assert.assertThat((Object)this.iter.getSize(), (Matcher)Is.is((Object)0L));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRemove() {
        this.iter.remove();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldFailWhenNextIsCalled() {
        this.iter.next();
    }
}

