/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import junit.framework.TestSuite;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.DateTime;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public final class JcrObservationManagerTest
extends TestSuite {
    private static final int ALL_EVENTS = 31;
    private static final String LOCK_MIXIN = "mix:lockable";
    private static final String LOCK_OWNER = "jcr:lockOwner";
    private static final String LOCK_IS_DEEP = "jcr:lockIsDeep";
    private static final String REF_MIXIN = "mix:referenceable";
    private static final String UNSTRUCTURED = "nt:unstructured";
    private static final String USER_ID = "superuser";
    protected static final String WORKSPACE = "ws1";
    protected static final String WORKSPACE2 = "ws2";
    protected static final String REPOSITORY = "r1";
    protected static final String SOURCE = "store";
    private JcrEngine engine;
    private Session session;
    private Node testRootNode;
    private List<Session> sessions;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas("security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    TestListener addListener(int expectedEventsCount, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws Exception {
        return this.addListener(expectedEventsCount, 1, eventTypes, absPath, isDeep, uuids, nodeTypeNames, noLocal);
    }

    TestListener addListener(int expectedEventsCount, int numIterators, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws Exception {
        return this.addListener(this.session, expectedEventsCount, numIterators, eventTypes, absPath, isDeep, uuids, nodeTypeNames, noLocal);
    }

    TestListener addListener(Session session, int expectedEventsCount, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws Exception {
        return this.addListener(session, expectedEventsCount, 1, eventTypes, absPath, isDeep, uuids, nodeTypeNames, noLocal);
    }

    TestListener addListener(Session session, int expectedEventsCount, int numIterators, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws Exception {
        TestListener listener = new TestListener(expectedEventsCount, numIterators, eventTypes);
        session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, eventTypes, absPath, isDeep, uuids, nodeTypeNames, noLocal);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        Object v1;
        block6: {
            try {
                for (Session session : this.sessions) {
                    if (session == null || !session.isLive()) continue;
                    session.logout();
                }
                Object var4_3 = null;
                this.session = null;
                this.sessions.clear();
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                this.session = null;
                this.sessions.clear();
                try {
                    this.engine.shutdown();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var6_8 = v0;
                this.engine = null;
                throw throwable;
            }
            try {
                this.engine.shutdown();
                v1 = null;
                break block6;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var6_7 = v1;
        this.engine = null;
    }

    @Before
    public void beforeEach() throws RepositoryException {
        this.sessions = new ArrayList<Session>();
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource(SOURCE).usingClass(InMemoryRepositorySource.class)).setRetryLimit(100).setProperty("predefinedWorkspaceNames", (Object[])new String[]{WORKSPACE, WORKSPACE2})).setProperty("defaultWorkspaceName", WORKSPACE);
        config.repository(REPOSITORY).setSource(SOURCE).setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        config.save();
        this.engine = config.build();
        this.engine.start();
        this.session = this.login(REPOSITORY, WORKSPACE, USER_ID, USER_ID.toCharArray());
        this.testRootNode = this.session.getRootNode().addNode("testroot", UNSTRUCTURED);
        this.save();
    }

    protected Session login(String repositoryName, String workspaceName, String userId, char[] password) throws RepositoryException {
        SimpleCredentials credentials;
        JcrRepository repository = this.engine.getRepository(repositoryName);
        Session session = repository.login((Credentials)(credentials = new SimpleCredentials(userId, password)), workspaceName);
        if (session != null) {
            this.sessions.add(session);
        }
        return session;
    }

    void checkResults(TestListener listener) {
        if (listener.getActualEventCount() != listener.getExpectedEventCount()) {
            StringBuilder sb = new StringBuilder(" Actual events were: ");
            for (Event event : listener.getEvents()) {
                sb.append('\n').append(event);
            }
            Assert.assertThat((String)("Received incorrect number of events." + sb.toString()), (Object)listener.getActualEventCount(), (Matcher)Is.is((Object)listener.getExpectedEventCount()));
            Assert.assertThat((String)listener.getErrorMessage(), (Object)listener.getErrorMessage(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    boolean containsPath(TestListener listener, String path) throws Exception {
        for (Event event : listener.getEvents()) {
            if (!event.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    ObservationManager getObservationManager() throws RepositoryException {
        return this.session.getWorkspace().getObservationManager();
    }

    Node getRoot() {
        return this.testRootNode;
    }

    Workspace getWorkspace() {
        return this.session.getWorkspace();
    }

    void removeListener(TestListener listener) throws Exception {
        this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)listener);
    }

    void save() throws RepositoryException {
        this.session.save();
    }

    @Test
    public void shouldNotReceiveEventIfUuidDoesNotMatch() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addMixin(REF_MIXIN);
        this.save();
        TestListener listener = this.addListener(0, 4, this.getRoot().getPath(), true, new String[]{UUID.randomUUID().toString()}, null, false);
        n1.setProperty("prop1", "foo");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldNotReceiveEventIfNodeTypeDoesNotMatch() throws Exception {
        Node node1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(0, 31, null, false, null, new String[]{REF_MIXIN}, false);
        node1.setProperty("newProperty", "newValue");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldReceiveNodeAddedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node root = this.getRoot();
        this.save();
        TestListener listener = this.addListener(4, 31, null, false, null, null, false);
        Node addedNode = root.addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    public void shouldReceiveNodeRemovedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        String path = addedNode.getPath();
        addedNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + path), (boolean)this.containsPath(listener, path));
    }

    @Test
    public void shouldReceivePropertyAddedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldReceivePropertyChangedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for changed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldReceivePropertyRemovedEventWhenRegisteredToReceiveAllEvents() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop = node.setProperty("prop1", "prop1 content");
        String propPath = prop.getPath();
        this.save();
        TestListener listener = this.addListener(1, 31, null, false, null, null, false);
        prop.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener, propPath));
    }

    @Test
    public void shouldReceivePropertyAddedEventWhenRegisteredToReceiveEventsBasedUponNodeTypeName() throws Exception {
        String[] nodeTypeNames = new String[]{"mode:root"};
        TestListener listener = this.addListener(1, 31, null, true, null, nodeTypeNames, false);
        this.session.getRootNode().setProperty("fooProp", "bar");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        String propPath = "/fooProp";
        Assert.assertTrue((String)("Path for added property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener, propPath));
    }

    @Test
    public void shouldTestEventIteratorTest_testGetPosition() throws Exception {
        TestListener listener = this.addListener(3, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.getRoot().addNode("node2", UNSTRUCTURED);
        this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldTestEventIteratorTest_testGetSize() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldTestEventIteratorTest_testSkip() throws Exception {
        ArrayList<JcrObservationManager.JcrEvent> events = new ArrayList<JcrObservationManager.JcrEvent>();
        DateTime now = this.engine.getExecutionContext().getValueFactories().getDateFactory().create();
        JcrObservationManager jcrObservationManager = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager.getClass();
        JcrObservationManager.JcrEventBundle bundle = new JcrObservationManager.JcrEventBundle(jcrObservationManager, now, "userId", null);
        String id1 = UUID.randomUUID().toString();
        String id2 = UUID.randomUUID().toString();
        String id3 = UUID.randomUUID().toString();
        JcrObservationManager jcrObservationManager2 = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager2.getClass();
        events.add(new JcrObservationManager.JcrEvent(jcrObservationManager2, bundle, 1, "/testroot/node1", id1));
        JcrObservationManager jcrObservationManager3 = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager3.getClass();
        events.add(new JcrObservationManager.JcrEvent(jcrObservationManager3, bundle, 1, "/testroot/node2", id2));
        JcrObservationManager jcrObservationManager4 = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager4.getClass();
        events.add(new JcrObservationManager.JcrEvent(jcrObservationManager4, bundle, 1, "/testroot/node3", id3));
        JcrObservationManager jcrObservationManager5 = (JcrObservationManager)this.getObservationManager();
        jcrObservationManager5.getClass();
        JcrObservationManager.JcrEventIterator itr = new JcrObservationManager.JcrEventIterator(jcrObservationManager5, events);
        itr.skip(0L);
        Assert.assertThat((String)"getPosition() for first element should return 0.", (Object)itr.getPosition(), (Matcher)Is.is((Object)0L));
        itr.skip(2L);
        Assert.assertThat((String)"Wrong value when skipping ", (Object)itr.getPosition(), (Matcher)Is.is((Object)2L));
        try {
            itr.skip(2L);
            Assert.fail((String)"EventIterator must throw NoSuchElementException when skipping past the end");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldTestEventTest_testGetNodePath() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    public void shouldTestEventTest_testGetType() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertThat((String)"Event did not return correct event type", (Object)listener.getEvents().get(0).getType(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldTestEventTest_testGetUserId() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertThat((String)"UserId of event is not equal to userId of session", (Object)listener.getEvents().get(0).getUserID(), (Matcher)Is.is((Object)USER_ID));
    }

    @Test
    public void shouldTestGetRegisteredEventListenersTest_testGetSize() throws Exception {
        Assert.assertThat((String)"A new session must not have any event listeners registered.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)0L));
        TestListener listener = this.addListener(0, 31, null, false, null, null, false);
        this.addListener(0, 31, null, false, null, null, false);
        Assert.assertThat((String)"Wrong number of event listeners.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)2L));
        this.getObservationManager().addEventListener((EventListener)listener, 31, null, false, null, null, false);
        Assert.assertThat((String)"The same listener should not be added more than once.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)2L));
    }

    @Test
    public void shouldTestGetRegisteredEventListenersTest_testRemoveEventListener() throws Exception {
        TestListener listener1 = this.addListener(0, 31, null, false, null, null, false);
        TestListener listener2 = this.addListener(0, 31, null, false, null, null, false);
        Assert.assertThat((String)"Wrong number of event listeners.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)2L));
        this.removeListener(listener1);
        Assert.assertThat((String)"Wrong number of event listeners after removing a listener.", (Object)this.getObservationManager().getRegisteredEventListeners().getSize(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((String)"Wrong number of event listeners after removing a listener.", (Object)this.getObservationManager().getRegisteredEventListeners().nextEventListener(), (Matcher)Is.is((Object)listener2));
    }

    @Test
    public void shouldTestLockingTest_testAddLockToNode() throws Exception {
        String node1 = "node1";
        Node lockable = this.getRoot().addNode(node1, UNSTRUCTURED);
        lockable.addMixin(LOCK_MIXIN);
        this.save();
        TestListener listener = this.addListener(2, 2, 4, this.testRootNode.getPath(), true, null, null, false);
        this.session.getWorkspace().getLockManager().lock(lockable.getPath(), false, true, 1L, "me");
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"No event created for jcr:lockOwner", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_OWNER));
        Assert.assertTrue((String)"No event created for jcr:lockIsDeep", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_IS_DEEP));
    }

    @Test
    public void shouldTestLockingTest_testRemoveLockFromNode() throws Exception {
        String node1 = "node1";
        Node lockable = this.getRoot().addNode(node1, UNSTRUCTURED);
        lockable.addMixin(LOCK_MIXIN);
        this.save();
        this.session.getWorkspace().getLockManager().lock(lockable.getPath(), false, true, 1L, "me");
        TestListener listener = this.addListener(2, 8, null, false, null, null, false);
        this.session.getWorkspace().getLockManager().unlock(lockable.getPath());
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"No event created for jcr:lockOwner", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_OWNER));
        Assert.assertTrue((String)"No event created for jcr:lockIsDeep", (boolean)this.containsPath(listener, lockable.getPath() + '/' + LOCK_IS_DEEP));
    }

    @Test
    public void shouldTestNodeAddedTest_testMultipleNodeAdded1() throws Exception {
        TestListener listener = this.addListener(2, 1, null, false, null, null, false);
        Node addedNode1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node addedNode2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for first added node is wrong", (boolean)this.containsPath(listener, addedNode1.getPath()));
        Assert.assertTrue((String)"Path for second added node is wrong", (boolean)this.containsPath(listener, addedNode2.getPath()));
    }

    @Test
    public void shouldTestNodeAddedTest_testMultipleNodeAdded2() throws Exception {
        TestListener listener = this.addListener(2, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node addedChildNode = addedNode.addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for added node is wrong", (boolean)this.containsPath(listener, addedNode.getPath()));
        Assert.assertTrue((String)"Path for added child node is wrong", (boolean)this.containsPath(listener, addedChildNode.getPath()));
    }

    @Test
    public void shouldTestNodeAddedTest_testSingleNodeAdded() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    public void shouldTestNodeAddedTest_testTransientNodeAddedRemoved() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node transientNode = addedNode.addNode("node2", UNSTRUCTURED);
        transientNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
    }

    @Test
    @Ignore
    public void shouldTestNodeRemovedTest_testMultiNodesRemoved() throws Exception {
        TestListener listener = this.addListener(2, 2, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node childNode = addedNode.addNode("node2", UNSTRUCTURED);
        this.save();
        String parentPath = addedNode.getPath();
        String childPath = childNode.getPath();
        addedNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for removed node is wrong", (boolean)this.containsPath(listener, parentPath));
        Assert.assertTrue((String)"Path for removed child node is wrong", (boolean)this.containsPath(listener, childPath));
    }

    @Test
    public void shouldTestNodeRemovedTest_testSingleNodeRemoved() throws Exception {
        TestListener listener = this.addListener(1, 2, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        String path = addedNode.getPath();
        addedNode.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + path), (boolean)this.containsPath(listener, path));
    }

    @Test
    public void shouldTestNodeMovedTest_testMoveNode() throws Exception {
        String node1 = "node1";
        String node2 = "node2";
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        Node n2 = n1.addNode(node2, UNSTRUCTURED);
        String oldPath = n2.getPath();
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String newPath = this.getRoot().getPath() + '/' + node2;
        this.getWorkspace().move(oldPath, newPath);
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(moveNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Object)oldPath));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Object)newPath));
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(moveNodeListener, newPath));
        Assert.assertTrue((String)("Path for new location of added node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(addNodeListener, newPath));
        Assert.assertTrue((String)("Path for new location of removed node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldTestNodeMovedTest_testMoveTree() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        String oldPath = n1.getPath();
        n1.addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String newPath = this.getRoot().getPath() + "/node3";
        this.getWorkspace().move(oldPath, newPath);
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(moveNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Object)oldPath));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Object)newPath));
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(moveNodeListener, newPath));
        Assert.assertTrue((String)("Path for new location of added node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(addNodeListener, newPath));
        Assert.assertTrue((String)("Path for new location of removed node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldTestNodeMovedTest_testMoveWithRemove() throws Exception {
        String node2 = "node2";
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node n2 = n1.addNode(node2, UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(2, 2, 2, null, false, null, null, false);
        String oldPath = n2.getPath();
        String newPath = n3.getPath() + '/' + node2;
        this.getWorkspace().move(oldPath, newPath);
        String removedNodePath = n1.getPath();
        n1.remove();
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(moveNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Object)oldPath));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Object)newPath));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(moveNodeListener, newPath));
        Assert.assertTrue((String)("Path for new location of added node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + newPath), (boolean)this.containsPath(addNodeListener, newPath));
        Assert.assertTrue((String)("Path for new location of removed node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
        Assert.assertTrue((String)"Path for removed node is wrong", (boolean)this.containsPath(removeNodeListener, removedNodePath));
    }

    @Test
    public void shouldTestNodeReorderTest_testNodeReorder() throws Exception {
        this.getRoot().addNode("node1", UNSTRUCTURED);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        this.getRoot().orderBefore(n3.getName(), n2.getName());
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(moveNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Object)"node3"));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Object)"node2"));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + n3.getPath()), (boolean)this.containsPath(moveNodeListener, n3.getPath()));
        Assert.assertTrue((String)("Added reordered node has wrong path: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + n3.getPath()), (boolean)this.containsPath(addNodeListener, n3.getPath()));
        Assert.assertTrue((String)("Removed reordered node has wrong path: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + n3.getPath()), (boolean)this.containsPath(addNodeListener, n3.getPath()));
    }

    @Test
    public void shouldTestNodeReorderTest_testNodeReorderSameName() throws Exception {
        String node1 = "node1";
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        this.getRoot().orderBefore(node1 + "[3]", node1 + "[2]");
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(moveNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Object)(node1 + "[3]")));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Object)(node1 + "[2]")));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + this.getRoot().getPath() + "/" + node1 + "[2]"), (boolean)this.containsPath(moveNodeListener, this.getRoot().getPath() + "/" + node1 + "[2]"));
        Assert.assertTrue((String)("Added reordered node has wrong path: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + n1.getPath() + "[2]"), (boolean)this.containsPath(addNodeListener, n1.getPath() + "[2]"));
        Assert.assertTrue((String)("Removed reordered node has wrong path: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + n1.getPath() + "[3]"), (boolean)this.containsPath(removeNodeListener, n1.getPath() + "[3]"));
    }

    @Test
    public void shouldTestNodeReorderTest_testNodeReorderSameNameWithRemove() throws Exception {
        String node1 = "node1";
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode("node2", UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        this.getRoot().addNode(node1, UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(2, 2, null, false, null, null, false);
        this.getRoot().orderBefore(node1 + "[2]", null);
        String removedPath = n3.getPath();
        n3.remove();
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Object)(node1 + "[2]")));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + this.getRoot().getPath() + "/" + node1 + "[3]"), (boolean)this.containsPath(moveNodeListener, this.getRoot().getPath() + "/" + node1 + "[3]"));
        Assert.assertTrue((String)("Added reordered node has wrong path: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + n1.getPath() + "[3]"), (boolean)this.containsPath(addNodeListener, n1.getPath() + "[3]"));
        Assert.assertTrue((String)("Removed reordered node path not found: " + n1.getPath() + "[2]"), (boolean)this.containsPath(removeNodeListener, n1.getPath() + "[2]"));
        Assert.assertTrue((String)("Removed node path not found: " + removedPath), (boolean)this.containsPath(removeNodeListener, removedPath));
    }

    @Test
    public void shouldTestPropertyAddedTest_testMultiPropertyAdded() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(2, 4, null, false, null, null, false);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        Property prop2 = node.setProperty("prop2", "prop2 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for first added property not found: " + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
        Assert.assertTrue((String)("Path for second added property not found: " + prop2.getPath()), (boolean)this.containsPath(listener, prop2.getPath()));
    }

    @Test
    public void shouldTestPropertyAddedTest_testSinglePropertyAdded() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 4, null, false, null, null, false);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldTestPropertyAddedTest_testSystemGenerated() throws Exception {
        TestListener listener = this.addListener(3, 4, null, false, null, null, false);
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)"Path for jrc:primaryType property was not found.", (boolean)this.containsPath(listener, node.getProperty("jcr:primaryType").getPath()));
    }

    @Test
    public void shouldTestPropertyChangedTests_testMultiPropertyChanged() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        Property prop2 = node.setProperty("prop2", "prop2 content");
        this.save();
        TestListener listener = this.addListener(2, 16, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        prop2.setValue("prop2 modified content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for first changed property not found: " + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
        Assert.assertTrue((String)("Path for second changed property not found: " + prop2.getPath()), (boolean)this.containsPath(listener, prop2.getPath()));
    }

    @Test
    public void shouldTestPropertyChangedTests_testPropertyRemoveCreate() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        String propName = "prop1";
        Property prop = node.setProperty(propName, propName + " content");
        String propPath = prop.getPath();
        this.save();
        TestListener listener1 = this.addListener(1, 16, null, false, null, null, false);
        TestListener listener2 = this.addListener(2, 12, null, false, null, null, false);
        prop.remove();
        node.setProperty(propName, true);
        this.save();
        listener1.waitForEvents();
        this.removeListener(listener1);
        listener2.waitForEvents();
        this.removeListener(listener2);
        if (listener1.getEvents().size() == 1) {
            this.checkResults(listener1);
            Assert.assertTrue((String)("Path for removed then added property is wrong: actual=" + listener1.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener1, propPath));
        } else {
            this.checkResults(listener2);
            Assert.assertTrue((String)("Path for removed then added property is wrong: actual=" + listener2.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener2, propPath));
            Assert.assertTrue((String)("Path for removed then added property is wrong: actual=" + listener2.getEvents().get(1).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener2, propPath));
        }
    }

    @Test
    public void shouldTestPropertyChangedTests_testSinglePropertyChanged() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        TestListener listener = this.addListener(1, 16, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for changed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldTestPropertyChangedTests_testSinglePropertyChangedWithAdded() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        this.save();
        TestListener listener = this.addListener(1, 16, null, false, null, null, false);
        prop1.setValue("prop1 modified content");
        node.setProperty("prop2", "prop2 content");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for changed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + prop1.getPath()), (boolean)this.containsPath(listener, prop1.getPath()));
    }

    @Test
    public void shouldTestPropertyRemovedTest_testMultiPropertyRemoved() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop1 = node.setProperty("prop1", "prop1 content");
        Property prop2 = node.setProperty("prop2", "prop2 content");
        this.save();
        TestListener listener = this.addListener(2, 8, null, false, null, null, false);
        String prop1Path = prop1.getPath();
        prop1.remove();
        String prop2Path = prop2.getPath();
        prop2.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for first removed property not found: " + prop1Path), (boolean)this.containsPath(listener, prop1Path));
        Assert.assertTrue((String)("Path for second removed property not found: " + prop2Path), (boolean)this.containsPath(listener, prop2Path));
    }

    @Test
    public void shouldTestPropertyRemovedTest_testSinglePropertyRemoved() throws Exception {
        Node node = this.getRoot().addNode("node1", UNSTRUCTURED);
        Property prop = node.setProperty("prop1", "prop1 content");
        String propPath = prop.getPath();
        this.save();
        TestListener listener = this.addListener(1, 8, null, false, null, null, false);
        prop.remove();
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for removed property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + propPath), (boolean)this.containsPath(listener, propPath));
    }

    @Test
    public void shouldTestAddEventListenerTest_testIsDeepFalseNodeAdded() throws Exception {
        String node1 = "node1";
        String path = this.getRoot().getPath() + '/' + node1;
        TestListener listener = this.addListener(1, 1, path, false, null, null, false);
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        Node childNode = n1.addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Child node path is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + childNode.getPath()), (boolean)this.containsPath(listener, childNode.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testIsDeepFalsePropertyAdded() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 4, n1.getPath(), false, null, null, false);
        String prop = "prop";
        Property n1Prop = n1.setProperty(prop, "foo");
        n2.setProperty(prop, "foo");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added property is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + n1Prop.getPath()), (boolean)this.containsPath(listener, n1Prop.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testNodeType() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addMixin(LOCK_MIXIN);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(1, 1, this.getRoot().getPath(), true, null, new String[]{LOCK_MIXIN}, false);
        String node3 = "node3";
        Node n3 = n1.addNode(node3, UNSTRUCTURED);
        n2.addNode(node3, UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Wrong path: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + n3.getPath()), (boolean)this.containsPath(listener, n3.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testNoLocalTrue() throws Exception {
        TestListener listener = this.addListener(0, 1, this.getRoot().getPath(), true, null, null, true);
        this.getRoot().addNode("node1", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    public void shouldTestAddEventListenerTest_testPath() throws Exception {
        String node1 = "node1";
        String path = this.getRoot().getPath() + '/' + node1;
        TestListener listener = this.addListener(1, 1, path, true, null, null, false);
        Node n1 = this.getRoot().addNode(node1, UNSTRUCTURED);
        Node childNode = n1.addNode("node2", UNSTRUCTURED);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Child node path is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + childNode.getPath()), (boolean)this.containsPath(listener, childNode.getPath()));
    }

    @Test
    public void shouldTestAddEventListenerTest_testUUID() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addMixin(REF_MIXIN);
        Node n2 = this.getRoot().addNode("node2", UNSTRUCTURED);
        n2.addMixin(REF_MIXIN);
        this.save();
        TestListener listener = this.addListener(1, 4, this.getRoot().getPath(), true, new String[]{n1.getIdentifier()}, null, false);
        String prop1 = "prop1";
        Property n1Prop = n1.setProperty(prop1, "foo");
        n2.setProperty(prop1, "foo");
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Wrong path: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + n1Prop.getPath()), (boolean)this.containsPath(listener, n1Prop.getPath()));
    }

    @Test
    @Ignore
    public void shouldTestWorkspaceOperationTest_testCopy() throws Exception {
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        String node2 = "node2";
        addedNode.addNode(node2, UNSTRUCTURED);
        this.save();
        TestListener listener = this.addListener(2, 1, null, false, null, null, false);
        String targetPath = this.getRoot().getPath() + "/node3";
        this.getWorkspace().copy(addedNode.getPath(), targetPath);
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for copied node not found: " + targetPath), (boolean)this.containsPath(listener, targetPath));
        Assert.assertTrue((String)("Path for copied child node not found: " + targetPath + '/' + node2), (boolean)this.containsPath(listener, targetPath + '/' + node2));
    }

    @Test
    public void shouldTestWorkspaceOperationTest_testMove() throws Exception {
        String node2 = "node2";
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addNode(node2, UNSTRUCTURED);
        Node n3 = this.getRoot().addNode("node3", UNSTRUCTURED);
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String oldPath = n1.getPath();
        String targetPath = n3.getPath() + "/node4";
        this.getWorkspace().move(oldPath, targetPath);
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(moveNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Object)oldPath));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Object)targetPath));
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + targetPath), (boolean)this.containsPath(moveNodeListener, targetPath));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + targetPath), (boolean)this.containsPath(addNodeListener, targetPath));
        Assert.assertTrue((String)("Path for old location of moved node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldTestWorkspaceOperationTest_testRename() throws Exception {
        Node n1 = this.getRoot().addNode("node1", UNSTRUCTURED);
        n1.addNode("node2", UNSTRUCTURED);
        this.save();
        TestListener moveNodeListener = this.addListener(1, 32, null, false, null, null, false);
        TestListener addNodeListener = this.addListener(1, 1, null, false, null, null, false);
        TestListener removeNodeListener = this.addListener(1, 2, null, false, null, null, false);
        String oldPath = n1.getPath();
        String renamedPath = this.getRoot().getPath() + "/node3";
        this.getWorkspace().move(oldPath, renamedPath);
        this.save();
        moveNodeListener.waitForEvents();
        this.removeListener(moveNodeListener);
        addNodeListener.waitForEvents();
        this.removeListener(addNodeListener);
        removeNodeListener.waitForEvents();
        this.removeListener(removeNodeListener);
        this.checkResults(moveNodeListener);
        this.checkResults(addNodeListener);
        this.checkResults(removeNodeListener);
        Map info = moveNodeListener.getEvents().get(0).getInfo();
        Assert.assertThat(info.get("srcAbsPath"), (Matcher)Is.is((Object)oldPath));
        Assert.assertThat(info.get("destAbsPath"), (Matcher)Is.is((Object)renamedPath));
        Assert.assertThat(info.get("srcChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(info.get("destChildRelPath"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((String)("Path for new location of moved node is wrong: actual=" + moveNodeListener.getEvents().get(0).getPath() + ", expected=" + renamedPath), (boolean)this.containsPath(moveNodeListener, renamedPath));
        Assert.assertTrue((String)("Path for renamed node is wrong: actual=" + addNodeListener.getEvents().get(0).getPath() + ", expected=" + renamedPath), (boolean)this.containsPath(addNodeListener, renamedPath));
        Assert.assertTrue((String)("Path for old name of renamed node is wrong: actual=" + removeNodeListener.getEvents().get(0).getPath() + ", expected=" + oldPath), (boolean)this.containsPath(removeNodeListener, oldPath));
    }

    @Test
    public void shouldNotReceiveEventsFromOtherWorkspaces() throws Exception {
        Session session2 = this.login(REPOSITORY, WORKSPACE2, USER_ID, USER_ID.toCharArray());
        TestListener listener1 = this.addListener(this.session, 4, 31, "/", true, null, null, false);
        TestListener addListener1 = this.addListener(this.session, 1, 1, "/", true, null, null, false);
        TestListener listener2 = this.addListener(session2, 0, 31, "/", true, null, null, false);
        TestListener addListener2 = this.addListener(session2, 0, 1, "/", true, null, null, false);
        this.session.getRootNode().addNode("nodeA", UNSTRUCTURED);
        this.session.save();
        listener1.waitForEvents();
        addListener1.waitForEvents();
        this.removeListener(listener1);
        this.removeListener(addListener1);
        listener2.waitForEvents();
        this.removeListener(listener2);
        this.removeListener(addListener2);
        this.checkResults(listener1);
        this.checkResults(addListener1);
        this.checkResults(listener2);
        this.checkResults(addListener2);
    }

    @Test
    @FixFor(value={"MODE-786"})
    public void shouldReceiveEventsForChangesToSessionNamespacesInSystemContent() throws Exception {
        String uri = "http://acme.com/example/foobar/";
        String prefix = "foobar";
        this.assertNoSessionNamespace(uri, prefix);
        TestListener listener = this.addListener(this.session, 0, 31, "/jcr:system", true, null, null, false);
        this.session.setNamespacePrefix(prefix, uri);
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    @FixFor(value={"MODE-786"})
    public void shouldReceiveEventsForChangesToRepositoryNamespacesInSystemContent() throws Exception {
        String uri = "http://acme.com/example/foobar/";
        String prefix = "foobar";
        this.assertNoRepositoryNamespace(uri, prefix);
        Session session2 = this.login(REPOSITORY, WORKSPACE2, USER_ID, USER_ID.toCharArray());
        TestListener listener = this.addListener(this.session, 3, 31, "/jcr:system", true, null, null, false);
        TestListener listener2 = this.addListener(session2, 3, 31, "/jcr:system", true, null, null, false);
        this.session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
        listener.waitForEvents();
        listener2.waitForEvents();
        this.removeListener(listener);
        this.removeListener(listener2);
        Assert.assertThat((Object)this.session.getWorkspace().getNamespaceRegistry().getPrefix(uri), (Matcher)Is.is((Object)prefix));
        Assert.assertThat((Object)this.session.getWorkspace().getNamespaceRegistry().getURI(prefix), (Matcher)Is.is((Object)uri));
        this.checkResults(listener);
        this.checkResults(listener2);
    }

    @Test
    @FixFor(value={"MODE-786"})
    public void shouldReceiveEventsForChangesToLocksInSystemContent() throws Exception {
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("lockedPropParent");
        parentNode.addMixin(LOCK_MIXIN);
        Node targetNode = parentNode.addNode("lockedTarget");
        targetNode.setProperty("foo", "bar");
        this.session.save();
        TestListener listener = this.addListener(this.session, 11, 2, 31, "/jcr:system", true, null, null, false);
        this.lock(parentNode, true, true);
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
    }

    @Test
    @FixFor(value={"MODE-786"})
    public void shouldReceiveEventsForChangesToVersionsInSystemContent() throws Exception {
        boolean hiearchical = ((String)this.engine.getRepository(REPOSITORY).getOptions().get(JcrRepository.Option.VERSION_HISTORY_STRUCTURE)).equalsIgnoreCase("hierarchical");
        int numEvents = hiearchical ? 23 : 15;
        TestListener listener = this.addListener(this.session, numEvents, 31, "/jcr:system", true, null, null, false);
        Node node = this.session.getRootNode().addNode("/test", UNSTRUCTURED);
        node.addMixin("mix:versionable");
        this.session.save();
        listener.waitForEvents();
        this.removeListener(listener);
        Node history = node.getProperty("jcr:versionHistory").getNode();
        Assert.assertThat((Object)history, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.hasProperty("jcr:baseVersion"), (Matcher)Is.is((Object)true));
        Node version = node.getProperty("jcr:baseVersion").getNode();
        Assert.assertThat((Object)version, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)version.getParent(), (Matcher)Is.is((Object)history));
        Assert.assertThat((Object)node.hasProperty("jcr:uuid"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.getProperty("jcr:uuid").getString(), (Matcher)Is.is((Object)history.getProperty("jcr:versionableUuid").getString()));
        Assert.assertThat((Object)this.versionHistory(node).getIdentifier(), (Matcher)Is.is((Object)history.getIdentifier()));
        Assert.assertThat((Object)this.versionHistory(node).getPath(), (Matcher)Is.is((Object)history.getPath()));
        Assert.assertThat((Object)this.baseVersion(node).getIdentifier(), (Matcher)Is.is((Object)version.getIdentifier()));
        Assert.assertThat((Object)this.baseVersion(node).getPath(), (Matcher)Is.is((Object)version.getPath()));
        this.checkResults(listener);
    }

    @Test
    @FixFor(value={" MODE-1315 "})
    public void shouldReceiveEventWhenPropertyDeletedOnCustomNode() throws Exception {
        CndNodeTypeReader cndFactory = new CndNodeTypeReader(this.session);
        cndFactory.read(((Object)((Object)this)).getClass().getClassLoader().getResource("cars.cnd"));
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(cndFactory.getNodeTypeDefinitions(), true);
        Node car = this.testRootNode.addNode("car", "car:Car");
        car.setProperty("car:maker", "Audi");
        this.session.save();
        TestListener listener = this.addListener(1, 8, null, true, null, new String[]{"car:Car"}, false);
        Property carMakerProperty = car.getProperty("car:maker");
        String propertyPath = carMakerProperty.getPath();
        carMakerProperty.remove();
        this.session.save();
        listener.waitForEvents();
        this.checkResults(listener);
        Event receivedEvent = listener.getEvents().get(0);
        Assert.assertEquals((long)8L, (long)receivedEvent.getType());
        Assert.assertEquals((Object)propertyPath, (Object)receivedEvent.getPath());
    }

    @Test
    @FixFor(value={"MODE-1370"})
    public void shouldReceiveUserDataWithEventWhenObservationSessionIsSameThatMadeChange() throws Exception {
        TestListener listener = this.addListener(1, 1, null, false, null, null, false);
        Node addedNode = this.getRoot().addNode("node1", UNSTRUCTURED);
        String userData = "my user data";
        this.getRoot().getSession().getWorkspace().getObservationManager().setUserData(userData);
        this.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
        for (Event event : listener.events) {
            String eventUserData = event.getUserData();
            Assert.assertThat((Object)eventUserData, (Matcher)Is.is((Object)userData));
        }
        Assert.assertThat((Object)listener.userData.size(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        for (String receivedUserData : listener.userData) {
            Assert.assertThat((Object)receivedUserData, (Matcher)Is.is((Object)userData));
        }
    }

    @Test
    @FixFor(value={"MODE-1370"})
    public void shouldReceiveUserDataWithEventWhenUserDataSetOnSessionThatMadeChange() throws Exception {
        TestListener listener = new TestListener(1, 1, 1);
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, 1, null, true, null, null, false);
        Session session2 = this.login(REPOSITORY, WORKSPACE, USER_ID, USER_ID.toCharArray());
        String userData = "my user data";
        session2.getWorkspace().getObservationManager().setUserData(userData);
        Node addedNode = session2.getRootNode().addNode("node1", UNSTRUCTURED);
        session2.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
        for (Event event : listener.events) {
            String eventUserData = event.getUserData();
            Assert.assertThat((Object)eventUserData, (Matcher)Is.is((Object)userData));
        }
        Assert.assertThat((Object)listener.userData.size(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        for (String receivedUserData : listener.userData) {
            Assert.assertThat((Object)receivedUserData, (Matcher)Is.is((Object)userData));
        }
    }

    @Test
    @FixFor(value={"MODE-1370"})
    public void shouldNotReceiveUserDataWithEventIfUserDataSetOnObservationSession() throws Exception {
        String userData = "my user data";
        ObservationManager om = this.session.getWorkspace().getObservationManager();
        om.setUserData(userData);
        TestListener listener = new TestListener(1, 1, 1);
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, 1, null, true, null, null, false);
        Session session2 = this.login(REPOSITORY, WORKSPACE, USER_ID, USER_ID.toCharArray());
        Assert.assertThat((Object)session2, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)this.session))));
        Node addedNode = session2.getRootNode().addNode("node1", UNSTRUCTURED);
        session2.save();
        listener.waitForEvents();
        this.removeListener(listener);
        this.checkResults(listener);
        Assert.assertTrue((String)("Path for added node is wrong: actual=" + listener.getEvents().get(0).getPath() + ", expected=" + addedNode.getPath()), (boolean)this.containsPath(listener, addedNode.getPath()));
        for (Event event : listener.events) {
            String eventUserData = event.getUserData();
            Assert.assertThat((Object)eventUserData, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
        Assert.assertThat((Object)listener.userData.size(), (Matcher)Is.is((Object)1));
        for (String receivedUserData : listener.userData) {
            Assert.assertThat((Object)receivedUserData, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    protected void assertNoRepositoryNamespace(String uri, String prefix) throws RepositoryException {
        NamespaceRegistry registry = this.session.getWorkspace().getNamespaceRegistry();
        for (String existingPrefix : registry.getPrefixes()) {
            Assert.assertThat((Object)existingPrefix.equals(prefix), (Matcher)Is.is((Object)false));
        }
        for (String existingUri : registry.getURIs()) {
            Assert.assertThat((Object)existingUri.equals(uri), (Matcher)Is.is((Object)false));
        }
    }

    protected void assertNoSessionNamespace(String uri, String prefix) throws RepositoryException {
        for (String existingPrefix : this.session.getNamespacePrefixes()) {
            Assert.assertThat((Object)existingPrefix.equals(prefix), (Matcher)Is.is((Object)false));
            String existingUri = this.session.getNamespaceURI(existingPrefix);
            Assert.assertThat((Object)existingUri.equals(uri), (Matcher)Is.is((Object)false));
        }
    }

    protected VersionHistory versionHistory(Node node) throws RepositoryException {
        return this.session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
    }

    protected Version baseVersion(Node node) throws RepositoryException {
        return this.session.getWorkspace().getVersionManager().getBaseVersion(node.getPath());
    }

    protected void lock(Node node, boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        this.session.getWorkspace().getLockManager().lock(node.getPath(), isDeep, isSessionScoped, 1L, "owner");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestListener
    implements EventListener {
        private String errorMessage;
        private final List<Event> events;
        private final List<String> userData;
        private int eventsProcessed = 0;
        private final int eventTypes;
        private final int expectedEventsCount;
        private final CountDownLatch latch;

        public TestListener(int expectedEventsCount, int numIterators, int eventTypes) {
            this.eventTypes = eventTypes;
            this.expectedEventsCount = expectedEventsCount;
            this.events = new ArrayList<Event>();
            this.userData = new ArrayList<String>();
            this.latch = new CountDownLatch(numIterators);
        }

        public int getActualEventCount() {
            return this.eventsProcessed;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public int getExpectedEventCount() {
            return this.expectedEventsCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(EventIterator itr) {
            try {
                long position = itr.getPosition();
                if (position == 0L) {
                    while (itr.hasNext()) {
                        Event event = itr.nextEvent();
                        if (++position != itr.getPosition()) {
                            this.errorMessage = "EventIterator position was " + itr.getPosition() + " and should be " + position;
                            break;
                        }
                        try {
                            String userData = event.getUserData();
                            this.userData.add(userData);
                        }
                        catch (RepositoryException e) {
                            this.errorMessage = e.getMessage();
                        }
                        this.events.add(event);
                        ++this.eventsProcessed;
                        if (this.eventsProcessed <= this.expectedEventsCount) {
                            int eventType = event.getType();
                            if ((this.eventTypes & eventType) != 0) continue;
                            this.errorMessage = "Received a wrong event type of " + eventType;
                        }
                        break;
                    }
                } else {
                    this.errorMessage = "EventIterator position was not initially set to zero";
                }
                Object var7_7 = null;
                this.latch.countDown();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.latch.countDown();
                throw throwable;
            }
        }

        public void waitForEvents() throws Exception {
            long millis = this.expectedEventsCount == 0 ? 50L : 250L;
            this.latch.await(millis, TimeUnit.MILLISECONDS);
        }
    }
}

