/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrQueryManagerTest;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrShareableNodesTest {
    private JcrConfiguration configuration;
    private JcrEngine engine;
    private JcrRepository repository;
    private Session session;
    private boolean print;

    @Before
    public void beforeEach() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("source").usingClass(InMemoryRepositorySource.class)).setDescription("The content store");
        this.configuration.repository("repo").setSource("source").registerNamespace("stest", "http://www.modeshape.org/test/shareablenodes/1.0").addNodeTypes(JcrShareableNodesTest.resourceUrl("shareableNodes.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readonly,readwrite,admin").setOption(JcrRepository.Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("repo");
        this.session = this.repository.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
                this.repository = null;
                this.configuration = null;
            }
        }
    }

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas("security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Test
    public void shouldStartUp() {
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldImportCarsSystemViewWithCreateNewBehaviorWhenImportedContentDoesNotContainJcrRoot() throws Exception {
        Node root = this.session.getRootNode();
        Node a1 = root.addNode("a", "stest:A");
        Node b1 = a1.addNode("b", "stest:B");
        Node c1 = b1.addNode("c", "stest:C");
        this.session.save();
        this.assertNode("/a");
        this.assertNode("/a/b");
        this.assertNode("/a/b/c");
        this.assertNoNode("/a/c");
        Workspace workspace = this.session.getWorkspace();
        VersionManager versionManager = workspace.getVersionManager();
        versionManager.checkout(a1.getPath());
        workspace.clone(workspace.getName(), c1.getPath(), "/a/c", false);
        versionManager.checkin(a1.getPath());
    }

    protected Path path(String path) {
        return (Path)this.engine.getExecutionContext().getValueFactories().getPathFactory().create(path);
    }

    protected String relativePath(String path) {
        return !path.startsWith("/") ? path : path.substring(1);
    }

    protected String asString(Object value) {
        return (String)this.engine.getExecutionContext().getValueFactories().getStringFactory().create(value);
    }

    protected Node assertNode(String path) throws RepositoryException {
        String relativePath = this.relativePath(path);
        Node root = this.session.getRootNode();
        if (relativePath.trim().length() == 0) {
            Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            return this.session.getNode(path);
        }
        if (this.print && !root.hasNode(relativePath)) {
            Node parent = root;
            int depth = 0;
            for (Path.Segment segment : this.path(path)) {
                if (!parent.hasNode(this.asString(segment))) {
                    System.out.println("Unable to find '" + path + "'; lowest node is '" + parent.getPath() + "'");
                    break;
                }
                parent = parent.getNode(this.asString(segment));
                ++depth;
            }
        }
        Assert.assertThat((Object)root.hasNode(relativePath), (Matcher)Is.is((Object)true));
        return this.session.getNode(path);
    }

    protected void assertNoNode(String path) throws RepositoryException {
        Assert.assertThat((Object)this.session.getRootNode().hasNode(this.relativePath(path)), (Matcher)Is.is((Object)false));
    }

    protected boolean hasMixin(Node node, String mixinNodeType) throws RepositoryException {
        for (NodeType mixin : node.getMixinNodeTypes()) {
            if (!mixin.getName().equals(mixinNodeType)) continue;
            return true;
        }
        return false;
    }

    protected void print() throws RepositoryException {
        this.print(this.session.getRootNode(), true);
    }

    protected void print(String path) throws RepositoryException {
        Node node = this.session.getRootNode().getNode(this.relativePath(path));
        this.print(node, true);
    }

    protected void print(Node node, boolean includeSystem) throws RepositoryException {
        if (this.print) {
            if (!includeSystem && node.getPath().equals("/jcr:system")) {
                return;
            }
            if (node.getDepth() != 0) {
                int snsIndex = node.getIndex();
                String segment = node.getName() + (snsIndex > 1 ? "[" + snsIndex + "]" : "");
                System.out.println(StringUtil.createString((char)' ', (int)(2 * node.getDepth())) + '/' + segment);
            }
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                this.print(children.nextNode(), includeSystem);
            }
        }
    }

    protected static URL resourceUrl(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResource(name);
    }
}

