/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.net.URL;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrVersioningTest {
    private Session session;
    private VersionManager versionManager;

    @Before
    public void beforeEach() throws RepositoryException {
        String repositorySource = "store";
        String repositoryName = "r1";
        JcrConfiguration config = this.createInMemoryConfig(repositorySource, repositoryName);
        JcrEngine engine = this.startEngine(config);
        this.createTestSession(repositoryName, engine);
        this.versionManager = this.session.getWorkspace().getVersionManager();
    }

    private void createTestSession(String repositoryName, JcrEngine engine) throws RepositoryException {
        JcrRepository repository = engine.getRepository(repositoryName);
        this.session = repository.login();
        Assert.assertNotNull((Object)this.session);
    }

    private JcrEngine startEngine(JcrConfiguration config) {
        JcrEngine engine = config.build();
        engine.start();
        Assert.assertThat((Object)engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        return engine;
    }

    private JcrConfiguration createInMemoryConfig(String repositorySource, String repositoryName) {
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource("store").usingClass(InMemoryRepositorySource.class)).setRetryLimit(100).setProperty("defaultWorkspaceName", "ws1");
        config.repository(repositoryName).setSource(repositorySource).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        config.save();
        return config;
    }

    @Test
    @FixFor(value={"MODE-1302"})
    public void shouldHaveVersionHistoryWhenRefreshIsCalled() throws Exception {
        Node outerNode = this.session.getRootNode().addNode("outerFolder");
        Node innerNode = outerNode.addNode("innerFolder");
        Node fileNode = innerNode.addNode("testFile.dat");
        fileNode.setProperty("jcr:mimeType", "text/plain");
        fileNode.setProperty("jcr:data", "Original content");
        this.session.save();
        Assert.assertFalse((boolean)this.hasVersionHistory(fileNode));
        fileNode.addMixin("mix:versionable");
        this.session.refresh(true);
        Assert.assertTrue((boolean)this.hasVersionHistory(fileNode));
    }

    @Test
    @FixFor(value={"MODE-1401"})
    public void shouldAllowAddingUnderCheckedInNodeNewChildNodeWithOpvOfIgnore() throws Exception {
        this.registerNodeTypes(this.session, "versioning.cnd");
        Node parent = this.session.getRootNode().addNode("versionableNode", "ver:versionable");
        parent.setProperty("versionProp", "v");
        parent.setProperty("copyProp", "c");
        parent.setProperty("ignoreProp", "i");
        this.session.save();
        this.versionManager.checkin(parent.getPath());
        Node child = parent.addNode("nonVersionedIgnoredChild", "ver:nonVersionableChild");
        child.setProperty("copyProp", "c");
        child.setProperty("ignoreProp", "i");
        this.session.save();
        child.setProperty("copyProp", "c2");
        child.setProperty("ignoreProp", "i2");
        this.session.save();
        Node child2 = parent.addNode("versionedIgnoredChild", "ver:versionableChild");
        child2.setProperty("copyProp", "c");
        child2.setProperty("ignoreProp", "i");
        this.session.save();
        child2.setProperty("copyProp", "c2");
        child2.setProperty("ignoreProp", "i2");
        this.session.save();
    }

    @Test
    @FixFor(value={"MODE-1401"})
    public void shouldNotAllowAddingUnderCheckedInNodeNewChildNodeWithOpvOfSomethingOtherThanIgnore() throws Exception {
        this.registerNodeTypes(this.session, "versioning.cnd");
        Node parent = this.session.getRootNode().addNode("versionableNode", "ver:versionable");
        parent.setProperty("versionProp", "v");
        parent.setProperty("copyProp", "c");
        parent.setProperty("ignoreProp", "i");
        this.session.save();
        this.versionManager.checkin(parent.getPath());
        try {
            parent.addNode("versionedChild", "ver:versionableChild");
            Assert.fail((String)"should have failed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        try {
            parent.addNode("nonVersionedChild", "ver:nonVersionableChild");
            Assert.fail((String)"should have failed");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    @Test
    @FixFor(value={"MODE-1401"})
    public void shouldAllowRemovingFromCheckedInNodeExistingChildNodeWithOpvOfIgnore() throws Exception {
        this.registerNodeTypes(this.session, "versioning.cnd");
        Node parent = this.session.getRootNode().addNode("versionableNode", "ver:versionable");
        parent.setProperty("versionProp", "v");
        parent.setProperty("copyProp", "c");
        parent.setProperty("ignoreProp", "i");
        Node child1 = parent.addNode("nonVersionedIgnoredChild", "ver:nonVersionableChild");
        child1.setProperty("copyProp", "c");
        child1.setProperty("ignoreProp", "i");
        Node child2 = parent.addNode("versionedIgnoredChild", "ver:versionableChild");
        child2.setProperty("copyProp", "c");
        child2.setProperty("ignoreProp", "i");
        this.session.save();
        this.versionManager.checkin(parent.getPath());
        child1.setProperty("copyProp", "c2");
        child1.setProperty("ignoreProp", "i2");
        child2.setProperty("copyProp", "c2");
        child2.setProperty("ignoreProp", "i2");
        this.session.save();
        child1.remove();
        child2.remove();
        this.session.save();
        parent.setProperty("ignoreProp", "i");
        try {
            parent.setProperty("copyProp", "c2");
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        try {
            parent.setProperty("versionProp", "v2");
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
    }

    @Test
    @FixFor(value={"MODE-1401"})
    public void shouldNotAllowRemovingFromCheckedInNodeExistingChildNodeWithOpvOfSomethingOtherThanIgnore() throws Exception {
        this.registerNodeTypes(this.session, "versioning.cnd");
        Node parent = this.session.getRootNode().addNode("versionableNode", "ver:versionable");
        parent.setProperty("versionProp", "v");
        parent.setProperty("copyProp", "c");
        parent.setProperty("ignoreProp", "i");
        Node child1 = parent.addNode("nonVersionedChild", "ver:nonVersionableChild");
        child1.setProperty("copyProp", "c");
        child1.setProperty("ignoreProp", "i");
        Node child2 = parent.addNode("versionedChild", "ver:versionableChild");
        child2.setProperty("copyProp", "c");
        child2.setProperty("ignoreProp", "i");
        this.session.save();
        this.versionManager.checkin(parent.getPath());
        this.versionManager.checkin(child2.getPath());
        try {
            parent.setProperty("copyProp", "c2");
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        try {
            parent.setProperty("versionProp", "v2");
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        try {
            child2.setProperty("copyProp", "c2");
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        try {
            child1.setProperty("copyProp", "c2");
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        this.versionManager.checkout(child2.getPath());
        child2.setProperty("copyProp", "c3");
        this.session.save();
        this.versionManager.checkin(child2.getPath());
        try {
            child1.setProperty("copyProp", "c2");
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        this.versionManager.checkout(parent.getPath());
        child1.setProperty("copyProp", "c2");
        this.session.save();
        child1.remove();
        this.session.save();
        this.versionManager.checkin(parent.getPath());
        try {
            child2.remove();
            Assert.fail((String)"not allowed");
        }
        catch (VersionException e) {
            // empty catch block
        }
        this.versionManager.checkout(parent.getPath());
        Assert.assertThat((Object)this.versionManager.isCheckedOut(child2.getPath()), (Matcher)Is.is((Object)false));
        child2.remove();
        this.session.save();
    }

    private void registerNodeTypes(Session session, String resourcePathToCnd) throws Exception {
        NodeTypeManager nodeTypes = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
        URL url = this.getClass().getClassLoader().getResource(resourcePathToCnd);
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        nodeTypes.registerNodeTypes(url, true);
    }

    private boolean hasVersionHistory(Node node) throws RepositoryException {
        try {
            VersionHistory history = this.versionManager.getVersionHistory(node.getPath());
            Assert.assertNotNull((Object)history);
            return true;
        }
        catch (UnsupportedRepositoryOperationException e) {
            return false;
        }
    }
}

