/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.JcrBinary;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrTools;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;
import org.modeshape.jcr.nodetype.PropertyDefinitionTemplate;

public class ModeShapeTckTest
extends AbstractJCRTest {
    Session session;

    public ModeShapeTckTest(String testName) {
        this.setName(testName);
        this.isReadOnly = true;
    }

    public static Test readOnlySuite() {
        TestSuite suite = new TestSuite("ModeShape JCR API tests");
        suite.addTest((Test)new ModeShapeTckTest("testShouldAllowAdminSessionToRead"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldAllowReadOnlySessionToRead"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldAllowReadWriteSessionToRead"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldNotSeeWorkspacesWithoutReadPermission"));
        suite.addTest((Test)new ModeShapeTckTest("testShouldMapReadRolesToWorkspacesWhenSpecified"));
        return suite;
    }

    protected void tearDown() throws Exception {
        try {
            this.superuser.getRootNode().getNode(this.nodeName1).remove();
            this.superuser.save();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    private void testRead(Session session) throws Exception {
        Node rootNode = session.getRootNode();
        NodeIterator iter = rootNode.getNodes();
        while (iter.hasNext()) {
            iter.nextNode();
        }
    }

    private void testAddNode(Session session) throws Exception {
        session.refresh(false);
        Node root = session.getRootNode();
        root.addNode(this.nodeName1, this.testNodeType);
        session.save();
    }

    private void testRemoveNode(Session session) throws Exception {
        session.refresh(false);
        Node root = session.getRootNode();
        Node node = root.getNode(this.nodeName1);
        node.remove();
        session.save();
    }

    private void testSetProperty(Session session) throws Exception {
        session.refresh(false);
        Node root = session.getRootNode();
        root.setProperty(this.propertyName1, "test value");
        session.save();
    }

    private void testRemoveProperty(Session session) throws Exception {
        Node superNode;
        Session localAdmin = this.getHelper().getRepository().login(this.getHelper().getSuperuserCredentials(), session.getWorkspace().getName());
        ModeShapeTckTest.assertEquals((String)session.getWorkspace().getName(), (String)this.superuser.getWorkspace().getName());
        Node superRoot = localAdmin.getRootNode();
        try {
            superNode = superRoot.getNode(this.nodeName1);
        }
        catch (PathNotFoundException pnfe) {
            superNode = superRoot.addNode(this.nodeName1, this.testNodeType);
        }
        superNode.setProperty(this.propertyName1, "test value");
        localAdmin.save();
        localAdmin.logout();
        session.refresh(false);
        Node root = session.getRootNode();
        Node node = root.getNode(this.nodeName1);
        Property property = node.getProperty(this.propertyName1);
        property.remove();
        session.save();
    }

    private void testRegisterNamespace(Session session) throws Exception {
        String unusedPrefix = session.getUserID();
        session.getWorkspace().getNamespaceRegistry().registerNamespace(unusedPrefix, unusedPrefix);
        session.getWorkspace().getNamespaceRegistry().unregisterNamespace(unusedPrefix);
    }

    private void testRegisterType(Session session) throws Exception {
        JcrNodeTypeManager nodeTypes = (JcrNodeTypeManager)session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate newType = nodeTypes.createNodeTypeTemplate();
        String nodeTypeName = session.getUserID() + "Type";
        newType.setName(nodeTypeName);
        nodeTypes.registerNodeType((NodeTypeDefinition)newType, false);
        nodeTypes.unregisterNodeTypes(Collections.singleton(nodeTypeName));
    }

    private void testWrite(Session session) throws Exception {
        this.testAddNode(session);
        this.testSetProperty(session);
        this.testRemoveProperty(session);
        this.testRemoveNode(session);
    }

    private void testAdmin(Session session) throws Exception {
        this.testRegisterNamespace(session);
        this.testRegisterType(session);
    }

    protected boolean useDeprecatedApi() {
        return false;
    }

    protected VersionHistory versionHistory(Node node) throws RepositoryException {
        if (this.useDeprecatedApi()) {
            return node.getVersionHistory();
        }
        return this.session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
    }

    protected Version baseVersion(Node node) throws RepositoryException {
        if (this.useDeprecatedApi()) {
            return node.getBaseVersion();
        }
        return this.session.getWorkspace().getVersionManager().getBaseVersion(node.getPath());
    }

    protected Version checkin(Node node) throws RepositoryException {
        if (this.useDeprecatedApi()) {
            return node.checkin();
        }
        return this.session.getWorkspace().getVersionManager().checkin(node.getPath());
    }

    protected void checkout(Node node) throws RepositoryException {
        if (this.useDeprecatedApi()) {
            node.checkout();
        } else {
            this.session.getWorkspace().getVersionManager().checkout(node.getPath());
        }
    }

    protected void restore(Node node, Version version, boolean removeExisting) throws RepositoryException {
        if (this.useDeprecatedApi()) {
            node.restore(version, removeExisting);
        } else {
            this.session.getWorkspace().getVersionManager().restore(version, removeExisting);
        }
    }

    protected void lock(Node node, boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        if (this.useDeprecatedApi()) {
            node.lock(isDeep, isSessionScoped);
        } else {
            this.session.getWorkspace().getLockManager().lock(node.getPath(), isDeep, isSessionScoped, 1L, "owner");
        }
    }

    protected void printSubgraph(Node node) throws RepositoryException {
        JcrTools tools = new JcrTools();
        tools.printSubgraph(node);
    }

    protected void printVersionHistory(Node node) throws RepositoryException {
        VersionHistory history = this.session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
        this.printSubgraph((Node)history);
    }

    public void testShouldAllowReadOnlySessionToRead() throws Exception {
        this.session = this.getHelper().getReadOnlySession();
        this.testRead(this.session);
    }

    public void testShouldNotAllowReadOnlySessionToWrite() throws Exception {
        this.session = this.getHelper().getReadOnlySession();
        try {
            this.testAddNode(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to add nodes");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testSetProperty(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to set properties");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRemoveProperty(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to remove properties");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRemoveNode(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to remove nodes");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testShouldNotAllowReadOnlySessionToAdmin() throws Exception {
        this.session = this.getHelper().getReadOnlySession();
        try {
            this.testRegisterNamespace(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to register namespaces");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRegisterType(this.session);
            ModeShapeTckTest.fail((String)"Read-only sessions should not be able to register types");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testShouldAllowReadWriteSessionToRead() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        this.testRead(this.session);
    }

    public void testShouldAllowReadWriteSessionToWrite() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        this.testWrite(this.session);
    }

    public void testShouldNotAllowReadWriteSessionToAdmin() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        try {
            this.testRegisterNamespace(this.session);
            ModeShapeTckTest.fail((String)"Read-write sessions should not be able to register namespaces");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
        try {
            this.testRegisterType(this.session);
            ModeShapeTckTest.fail((String)"Read-write sessions should not be able to register types");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testShouldAllowAdminSessionToRead() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        this.testRead(this.session);
    }

    public void testShouldAllowAdminSessionToWrite() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        this.testWrite(this.session);
    }

    public void testShouldAllowAdminSessionToAdmin() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        this.testAdmin(this.session);
    }

    public void testShouldMapReadRolesToWorkspacesWhenSpecified() throws Exception {
        SimpleCredentials creds = new SimpleCredentials("defaultonly", "defaultonly".toCharArray());
        this.session = this.getHelper().getRepository().login((Credentials)creds);
        this.testRead(this.session);
        this.session.logout();
        if ("default".equals(this.workspaceName)) {
            return;
        }
        this.session = this.getHelper().getRepository().login((Credentials)creds, this.workspaceName);
        this.testRead(this.session);
        try {
            this.testWrite(this.session);
            ModeShapeTckTest.fail((String)("User 'defaultuser' should not have write access to '" + this.workspaceName + "'"));
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        this.session.logout();
    }

    public void testShouldMapWriteRolesToWorkspacesWhenSpecified() throws Exception {
        SimpleCredentials creds = new SimpleCredentials("defaultonly", "defaultonly".toCharArray());
        this.session = this.getHelper().getRepository().login((Credentials)creds);
        this.testRead(this.session);
        this.testWrite(this.session);
        this.session.logout();
        this.session = this.getHelper().getRepository().login((Credentials)creds, "otherWorkspace");
        this.testRead(this.session);
        try {
            this.testWrite(this.session);
            ModeShapeTckTest.fail((String)"User 'defaultuser' should not have write access to 'otherWorkspace'");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        this.session.logout();
    }

    public void testShouldNotSeeWorkspacesWithoutReadPermission() throws Exception {
        SimpleCredentials creds = new SimpleCredentials("noaccess", "noaccess".toCharArray());
        try {
            this.session = this.getHelper().getRepository().login((Credentials)creds);
            ModeShapeTckTest.fail((String)"User 'noaccess' with no access to the default workspace should not be able to log into that workspace");
        }
        catch (LoginException le) {
            // empty catch block
        }
        if ("default".equals(this.workspaceName)) {
            return;
        }
        this.session = this.getHelper().getRepository().login((Credentials)creds, this.workspaceName);
        String[] workspaceNames = this.session.getWorkspace().getAccessibleWorkspaceNames();
        Assert.assertThat((Object)workspaceNames.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)workspaceNames[0], (Matcher)Is.is((Object)this.workspaceName));
        this.session.logout();
    }

    public void testShouldCopyFromAnotherWorkspace() throws Exception {
        this.session = this.getHelper().getSuperuserSession("otherWorkspace");
        String nodetype1 = this.getProperty("nodetype");
        Node node1 = this.session.getRootNode().addNode(this.nodeName1, nodetype1);
        node1.addNode(this.nodeName2, nodetype1);
        this.session.save();
        this.session.logout();
        this.superuser.getRootNode().addNode(this.nodeName4, nodetype1);
        this.superuser.save();
        this.superuser.getWorkspace().copy("otherWorkspace", "/" + this.nodeName1, "/" + this.nodeName4 + "/" + this.nodeName1);
        Node node4 = this.superuser.getRootNode().getNode(this.nodeName4);
        Node node4node1 = node4.getNode(this.nodeName1);
        Node node4node1node2 = node4node1.getNode(this.nodeName2);
        ModeShapeTckTest.assertNotNull((Object)node4node1node2);
    }

    public void testShouldNotCloneIfItWouldViolateTypeSemantics() throws Exception {
        this.session = this.getHelper().getSuperuserSession("otherWorkspace");
        Assert.assertThat((Object)this.session.getWorkspace().getName(), (Matcher)Is.is((Object)"otherWorkspace"));
        String nodetype1 = this.getProperty("nodetype");
        Node node1 = this.session.getRootNode().addNode("cloneSource", nodetype1);
        node1.addNode("modetest:mandatoryChild", nodetype1);
        this.session.save();
        this.session.logout();
        this.superuser.getRootNode().addNode("cloneTarget", nodetype1);
        this.superuser.getRootNode().addNode(this.nodeName3, nodetype1);
        this.superuser.save();
        this.superuser.getWorkspace().clone("otherWorkspace", "/cloneSource", "/cloneTarget/cloneSource", false);
        this.superuser.refresh(false);
        Node node3 = (Node)this.superuser.getItem("/node3");
        Assert.assertThat((Object)node3.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        Node node4node1 = (Node)this.superuser.getItem("/cloneTarget/cloneSource");
        Assert.assertThat((Object)node4node1.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        this.superuser.getWorkspace().clone("otherWorkspace", "/cloneSource", "/" + this.nodeName3 + "/cloneSource", true);
        this.superuser.refresh(false);
        Node node3node1 = (Node)this.superuser.getItem("/node3/cloneSource");
        Assert.assertThat((Object)node3node1.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node node4 = (Node)this.superuser.getItem("/cloneTarget");
        Assert.assertThat((Object)node4.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        this.superuser.getRootNode().addNode("nodeWithMandatoryChild", "modetest:nodeWithMandatoryChild");
        try {
            this.superuser.save();
            ModeShapeTckTest.fail((String)"A node with type modetest:nodeWithMandatoryChild should not be savable until the child is added");
        }
        catch (ConstraintViolationException cve) {
            // empty catch block
        }
        this.superuser.move("/node3/cloneSource/modetest:mandatoryChild", "/nodeWithMandatoryChild/modetest:mandatoryChild");
        this.superuser.save();
        this.superuser.refresh(false);
        try {
            this.superuser.getWorkspace().clone("otherWorkspace", "/cloneSource", "/" + this.nodeName3 + "/cloneSource", true);
            ModeShapeTckTest.fail((String)"Should not be able to use clone to remove the mandatory child node at /nodeWithMandatoryChild/modetest:mandatoryChild");
        }
        catch (ConstraintViolationException cve) {
            // empty catch block
        }
    }

    public void testAdminUserCanBreakOthersLocksUsingDeprecatedNodeLockAndUnlockMethods() throws Exception {
        String lockNodeName = "lockTestNode";
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node lockNode = root.addNode(lockNodeName);
        lockNode.addMixin("mix:lockable");
        this.session.save();
        lockNode.lock(false, false);
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)true));
        Session superuser = this.getHelper().getSuperuserSession();
        root = superuser.getRootNode();
        lockNode = root.getNode(lockNodeName);
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)true));
        lockNode.unlock();
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)false));
        superuser.logout();
    }

    public void testAdminUserCanBreakOthersLocks() throws Exception {
        String lockNodeName = "lockTestNode2";
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node lockNode = root.addNode(lockNodeName);
        lockNode.addMixin("mix:lockable");
        this.session.save();
        this.session.getWorkspace().getLockManager().lock(lockNode.getPath(), false, false, 1L, "me");
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)true));
        Session superuser = this.getHelper().getSuperuserSession();
        root = superuser.getRootNode();
        lockNode = root.getNode(lockNodeName);
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)true));
        this.session.getWorkspace().getLockManager().unlock(lockNode.getPath());
        Assert.assertThat((Object)lockNode.isLocked(), (Matcher)Is.is((Object)false));
        superuser.logout();
    }

    public void testShouldCreateProperVersionHistoryWhenSavingVersionedNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/test", "nt:unstructured");
        node.addMixin("mix:versionable");
        this.session.save();
        Assert.assertThat((Object)node.hasProperty("jcr:isCheckedOut"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.getProperty("jcr:isCheckedOut").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.hasProperty("jcr:versionHistory"), (Matcher)Is.is((Object)true));
        Node history = node.getProperty("jcr:versionHistory").getNode();
        Assert.assertThat((Object)history, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.hasProperty("jcr:baseVersion"), (Matcher)Is.is((Object)true));
        Node version = node.getProperty("jcr:baseVersion").getNode();
        Assert.assertThat((Object)version, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)version.getParent(), (Matcher)Is.is((Object)history));
        Assert.assertThat((Object)node.hasProperty("jcr:uuid"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node.getProperty("jcr:uuid").getString(), (Matcher)Is.is((Object)history.getProperty("jcr:versionableUuid").getString()));
        Assert.assertThat((Object)this.versionHistory(node).getUUID(), (Matcher)Is.is((Object)history.getUUID()));
        Assert.assertThat((Object)this.versionHistory(node).getIdentifier(), (Matcher)Is.is((Object)history.getIdentifier()));
        Assert.assertThat((Object)this.versionHistory(node).getPath(), (Matcher)Is.is((Object)history.getPath()));
        Assert.assertThat((Object)this.baseVersion(node).getUUID(), (Matcher)Is.is((Object)version.getUUID()));
        Assert.assertThat((Object)this.baseVersion(node).getIdentifier(), (Matcher)Is.is((Object)version.getIdentifier()));
        Assert.assertThat((Object)this.baseVersion(node).getPath(), (Matcher)Is.is((Object)version.getPath()));
    }

    public void testShouldCreateProperStructureForPropertiesOnTheFirstCheckInOfANode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        node.addMixin("mix:versionable");
        this.session.save();
        node.setProperty("abortProp", "abortPropValue");
        node.setProperty("copyProp", "copyPropValue");
        node.setProperty("ignoreProp", "ignorePropValue");
        node.setProperty("versionProp", "versionPropValue");
        this.session.save();
        try {
            this.checkin(node);
            ModeShapeTckTest.fail((String)"Should not be able to checkin a node with a property that has an OnParentVersionAction of ABORT");
        }
        catch (VersionException ve) {
            Assert.assertThat((Object)node.getProperty("jcr:isCheckedOut").getBoolean(), (Matcher)Is.is((Object)true));
        }
        node.setProperty("abortProp", (String)null);
        this.session.save();
        this.checkin(node);
        Assert.assertThat((Object)node.getProperty("jcr:isCheckedOut").getBoolean(), (Matcher)Is.is((Object)false));
        Version version = this.baseVersion(node);
        Assert.assertThat((Object)version, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        try {
            version.getProperty("jcr:frozenNode/ignoreProp");
            ModeShapeTckTest.fail((String)"Frozen version should not record a property that has an OnParentVersionAction of IGNORE");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        this.checkout(node);
        node.setProperty("abortProp", "abortPropValueNew");
        node.setProperty("copyProp", "copyPropValueNew");
        node.setProperty("ignoreProp", "ignorePropValueNew");
        node.setProperty("versionProp", "versionPropValueNew");
        version = this.baseVersion(node);
        Assert.assertThat((Object)version, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        try {
            version.getProperty("ignoreProp");
            ModeShapeTckTest.fail((String)"Frozen version should not record a property that has an OnParentVersionAction of IGNORE");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        this.session.save();
    }

    public void testShouldCreateProperHistoryForNodeWithCopySemantics() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node copyNode = node.addNode("copyNode", "modetest:versionTest");
        copyNode.addMixin("mix:versionable");
        Node midLevel = copyNode.addNode("copyNode", "modetest:versionTest");
        midLevel.setProperty("ignoreProp", "ignorePropValue");
        midLevel.setProperty("copyProp", "copyPropValue");
        Node abortNode = midLevel.addNode("abortNode", "modetest:versionTest");
        abortNode.setProperty("ignoreProp", "ignorePropValue");
        abortNode.setProperty("copyProp", "copyPropValue");
        Node versionNode = copyNode.addNode("versionNode", "modetest:versionTest");
        versionNode.addMixin("mix:versionable");
        this.session.save();
        Version version = this.checkin(copyNode);
        Version version2 = this.checkin(versionNode);
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/versionNode/jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:versionedChild"));
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/copyNode/abortNode/copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        try {
            version.getProperty("jcr:frozenNode/abortNode/ignoreProp");
            ModeShapeTckTest.fail((String)"Property with OnParentVersionAction of IGNORE should not have been copied");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Assert.assertThat((Object)version2.getProperty("jcr:frozenNode/jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:frozenNode"));
        Assert.assertThat((Object)version2.getProperty("jcr:frozenNode/jcr:frozenPrimaryType").getString(), (Matcher)Is.is((Object)"modetest:versionTest"));
        Assert.assertThat((Object)version2.getProperty("jcr:frozenNode/jcr:frozenUuid").getString(), (Matcher)Is.is((Object)versionNode.getIdentifier()));
    }

    public void testShouldThrowExceptionWhenVersioningChildNodeWithOnParentVersionSemanticsOfAbort() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node versionNode = node.addNode("versionNode", "modetest:versionTest");
        versionNode.addMixin("mix:versionable");
        Node abortNode = versionNode.addNode("abortNode", "modetest:versionTest");
        abortNode.setProperty("ignoreProp", "ignorePropValue");
        abortNode.setProperty("copyProp", "copyPropValue");
        this.session.save();
        try {
            this.checkin(versionNode);
            ModeShapeTckTest.fail((String)"Child node with OnParentVersionAction of ABORT should have resulted in exception.");
        }
        catch (VersionException ve) {
            // empty catch block
        }
    }

    public void testShouldCreateProperHistoryForVersionableChildOfNodeWithVersionSemantics() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node versionNode = node.addNode("versionNode", "modetest:versionTest");
        versionNode.addMixin("mix:versionable");
        Node copyNode = versionNode.addNode("copyNode", "modetest:versionTest");
        copyNode.addMixin("mix:versionable");
        copyNode.setProperty("ignoreProp", "ignorePropValue");
        copyNode.setProperty("copyProp", "copyPropValue");
        this.session.save();
        Version version = this.checkin(versionNode);
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/copyNode/jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:frozenNode"));
        Assert.assertThat((Object)version.getProperty("jcr:frozenNode/copyNode/jcr:frozenPrimaryType").getString(), (Matcher)Is.is((Object)"modetest:versionTest"));
        try {
            version.getProperty("jcr:frozenNode/copyNode/copyProp");
        }
        catch (PathNotFoundException pnfe) {
            ModeShapeTckTest.fail((String)"Property should be copied to versionable child of versioned node, because copyNode was copied (see Section 3.13.9 Item 5 of JSR-283)");
        }
        try {
            version.getProperty("jcr:frozenNode/copyNode/ignoreProp");
        }
        catch (PathNotFoundException pnfe) {
            ModeShapeTckTest.fail((String)"Ignored property should be copied to versionable child of versioned node when in a COPY subgraph");
        }
    }

    public void testShouldRestorePropertiesOnVersionableNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node copyNode = node.addNode("copyNode", "modetest:versionTest");
        copyNode.addMixin("mix:versionable");
        copyNode.setProperty("copyProp", "copyPropValue");
        copyNode.setProperty("ignoreProp", "ignorePropValue");
        copyNode.setProperty("computeProp", "computePropValue");
        this.session.save();
        Version version = this.checkin(copyNode);
        this.checkout(copyNode);
        copyNode.addMixin("mix:lockable");
        copyNode.setProperty("copyProp", "copyPropValueNew");
        copyNode.setProperty("ignoreProp", "ignorePropValueNew");
        copyNode.setProperty("versionProp", "versionPropValueNew");
        copyNode.setProperty("computeProp", "computePropValueNew");
        this.session.save();
        this.checkin(copyNode);
        this.restore(copyNode, version, false);
        Assert.assertThat((Object)copyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)copyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValueNew"));
        Assert.assertThat((Object)copyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValueNew"));
        try {
            copyNode.getProperty("versionProp");
            ModeShapeTckTest.fail((String)"Property with OnParentVersionAction of VERSION added after version should be removed during restore");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
    }

    @FixFor(value={"MODE-1228"})
    public void testShouldRestoreWithNoReplaceTheNonReferenceableCopiedChildNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node copyNode = node.addNode("copyNode", "modetest:versionTest");
        copyNode.addMixin("mix:versionable");
        copyNode.setProperty("copyProp", "copyPropValue");
        copyNode.setProperty("ignoreProp", "ignorePropValue");
        copyNode.setProperty("computeProp", "computePropValue");
        Node belowCopyNode = copyNode.addNode("copyNode", "nt:unstructured");
        belowCopyNode.addMixin("mix:title");
        belowCopyNode.setProperty("copyProp", "copyPropValue");
        belowCopyNode.setProperty("ignoreProp", "ignorePropValue");
        belowCopyNode.setProperty("computeProp", "computePropValue");
        belowCopyNode.setProperty("versionProp", "versionPropValue");
        this.session.save();
        Assert.assertThat((Object)belowCopyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:title"));
        Version version = this.checkin(copyNode);
        this.checkout(copyNode);
        copyNode.addMixin("mix:lockable");
        copyNode.setProperty("copyProp", "copyPropValueNew");
        copyNode.setProperty("ignoreProp", "ignorePropValueNew");
        copyNode.setProperty("versionProp", "versionPropValueNew");
        copyNode.setProperty("computeProp", "computePropValueNew");
        belowCopyNode.setProperty("versionProp", "versionPropValueNew");
        belowCopyNode.setProperty("computeProp", "computePropValueNew");
        this.session.save();
        this.checkin(copyNode);
        this.restore(copyNode, version, false);
        Assert.assertThat((Object)copyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)copyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValueNew"));
        Assert.assertThat((Object)copyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValueNew"));
        try {
            copyNode.getProperty("versionProp");
            ModeShapeTckTest.fail((String)"Property with OnParentVersionAction of VERSION added after version should be removed during restore");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Node belowCopyNode2 = copyNode.getNode("copyNode");
        Assert.assertThat((Object)belowCopyNode2.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:title"));
    }

    @FixFor(value={"MODE-1228"})
    public void testShouldRestoreWithReplaceTheNonReferenceableCopiedChildNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node copyNode = node.addNode("copyNode", "modetest:versionTest");
        copyNode.addMixin("mix:versionable");
        copyNode.setProperty("copyProp", "copyPropValue");
        copyNode.setProperty("ignoreProp", "ignorePropValue");
        copyNode.setProperty("computeProp", "computePropValue");
        Node belowCopyNode = copyNode.addNode("copyNode", "nt:unstructured");
        belowCopyNode.addMixin("mix:title");
        belowCopyNode.setProperty("copyProp", "copyPropValue");
        belowCopyNode.setProperty("ignoreProp", "ignorePropValue");
        belowCopyNode.setProperty("computeProp", "computePropValue");
        belowCopyNode.setProperty("versionProp", "versionPropValue");
        this.session.save();
        Assert.assertThat((Object)belowCopyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:title"));
        Version version = this.checkin(copyNode);
        this.checkout(copyNode);
        copyNode.addMixin("mix:lockable");
        copyNode.setProperty("copyProp", "copyPropValueNew");
        copyNode.setProperty("ignoreProp", "ignorePropValueNew");
        copyNode.setProperty("versionProp", "versionPropValueNew");
        copyNode.setProperty("computeProp", "computePropValueNew");
        belowCopyNode.setProperty("versionProp", "versionPropValueNew");
        belowCopyNode.setProperty("computeProp", "computePropValueNew");
        this.session.save();
        this.checkin(copyNode);
        this.restore(copyNode, version, true);
        Assert.assertThat((Object)copyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)copyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValueNew"));
        Assert.assertThat((Object)copyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValueNew"));
        try {
            copyNode.getProperty("versionProp");
            ModeShapeTckTest.fail((String)"Property with OnParentVersionAction of VERSION added after version should be removed during restore");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Node belowCopyNode2 = copyNode.getNode("copyNode");
        Assert.assertThat((Object)belowCopyNode2.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:title"));
    }

    @FixFor(value={"MODE-1228"})
    public void testShouldRestoreWithNoReplaceTheReferenceableCopiedChildNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node copyNode = node.addNode("copyNode", "modetest:versionTest");
        copyNode.addMixin("mix:versionable");
        copyNode.setProperty("copyProp", "copyPropValue");
        copyNode.setProperty("ignoreProp", "ignorePropValue");
        copyNode.setProperty("computeProp", "computePropValue");
        Node belowCopyNode = copyNode.addNode("copyNode", "nt:unstructured");
        belowCopyNode.addMixin("mix:referenceable");
        belowCopyNode.setProperty("copyProp", "copyPropValue");
        belowCopyNode.setProperty("ignoreProp", "ignorePropValue");
        belowCopyNode.setProperty("computeProp", "computePropValue");
        belowCopyNode.setProperty("versionProp", "versionPropValue");
        this.session.save();
        Assert.assertThat((Object)belowCopyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
        String belowCopyNodeId = belowCopyNode.getIdentifier();
        Version version = this.checkin(copyNode);
        this.checkout(copyNode);
        copyNode.addMixin("mix:lockable");
        copyNode.setProperty("copyProp", "copyPropValueNew");
        copyNode.setProperty("ignoreProp", "ignorePropValueNew");
        copyNode.setProperty("versionProp", "versionPropValueNew");
        copyNode.setProperty("computeProp", "computePropValueNew");
        belowCopyNode.setProperty("versionProp", "versionPropValueNew");
        belowCopyNode.setProperty("computeProp", "computePropValueNew");
        this.session.save();
        this.checkin(copyNode);
        this.restore(copyNode, version, false);
        Assert.assertThat((Object)copyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)copyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValueNew"));
        Assert.assertThat((Object)copyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValueNew"));
        try {
            copyNode.getProperty("versionProp");
            ModeShapeTckTest.fail((String)"Property with OnParentVersionAction of VERSION added after version should be removed during restore");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Node belowCopyNode2 = copyNode.getNode("copyNode");
        String belowCopyNode2Id = belowCopyNode.getIdentifier();
        Assert.assertThat((Object)belowCopyNodeId, (Matcher)Is.is((Object)belowCopyNode2Id));
        Assert.assertThat((Object)belowCopyNode2.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
    }

    @FixFor(value={"MODE-1228"})
    public void testShouldRestoreWithReplaceTheReferenceableCopiedChildNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node node = this.session.getRootNode().addNode("/checkInTest", "modetest:versionTest");
        this.session.save();
        Node copyNode = node.addNode("copyNode", "modetest:versionTest");
        copyNode.addMixin("mix:versionable");
        copyNode.setProperty("copyProp", "copyPropValue");
        copyNode.setProperty("ignoreProp", "ignorePropValue");
        copyNode.setProperty("computeProp", "computePropValue");
        Node belowCopyNode = copyNode.addNode("copyNode", "nt:unstructured");
        belowCopyNode.addMixin("mix:referenceable");
        belowCopyNode.setProperty("copyProp", "copyPropValue");
        belowCopyNode.setProperty("ignoreProp", "ignorePropValue");
        belowCopyNode.setProperty("computeProp", "computePropValue");
        belowCopyNode.setProperty("versionProp", "versionPropValue");
        this.session.save();
        Assert.assertThat((Object)belowCopyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
        String belowCopyNodeId = belowCopyNode.getIdentifier();
        Version version = this.checkin(copyNode);
        this.checkout(copyNode);
        copyNode.addMixin("mix:lockable");
        copyNode.setProperty("copyProp", "copyPropValueNew");
        copyNode.setProperty("ignoreProp", "ignorePropValueNew");
        copyNode.setProperty("versionProp", "versionPropValueNew");
        copyNode.setProperty("computeProp", "computePropValueNew");
        belowCopyNode.setProperty("versionProp", "versionPropValueNew");
        belowCopyNode.setProperty("computeProp", "computePropValueNew");
        this.session.save();
        this.checkin(copyNode);
        this.restore(copyNode, version, true);
        Assert.assertThat((Object)copyNode.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)copyNode.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValueNew"));
        Assert.assertThat((Object)copyNode.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValueNew"));
        try {
            copyNode.getProperty("versionProp");
            ModeShapeTckTest.fail((String)"Property with OnParentVersionAction of VERSION added after version should be removed during restore");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Node belowCopyNode2 = copyNode.getNode("copyNode");
        String belowCopyNode2Id = belowCopyNode.getIdentifier();
        Assert.assertThat((Object)belowCopyNodeId, (Matcher)Is.is((Object)belowCopyNode2Id));
        Assert.assertThat((Object)belowCopyNode2.getProperty("copyProp").getString(), (Matcher)Is.is((Object)"copyPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("ignoreProp").getString(), (Matcher)Is.is((Object)"ignorePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("computeProp").getString(), (Matcher)Is.is((Object)"computePropValue"));
        Assert.assertThat((Object)belowCopyNode2.getProperty("versionProp").getString(), (Matcher)Is.is((Object)"versionPropValue"));
        Assert.assertThat((Object)belowCopyNode2.getMixinNodeTypes()[0].getName(), (Matcher)Is.is((Object)"mix:referenceable"));
    }

    @FixFor(value={"MODE-1359"})
    public void testShouldQueryUsingJoinWithLeftHandSideOfJoinConditionBeingNullable() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        NamespaceRegistry registry = this.session.getWorkspace().getNamespaceRegistry();
        String NAMESPACE_PREFIX = "tt";
        String NAMESPACE_URI = "http://test.com/tt";
        String FRIENDLY = "tt:friendly";
        String FRIEND = "tt:friend";
        registry.registerNamespace("tt", "http://test.com/tt");
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        javax.jcr.nodetype.NodeTypeTemplate nodeType = manager.createNodeTypeTemplate();
        nodeType.setMixin(true);
        nodeType.setName("tt:friendly");
        nodeType.setQueryable(true);
        nodeType.setDeclaredSuperTypeNames(new String[]{"mix:referenceable"});
        javax.jcr.nodetype.PropertyDefinitionTemplate propertyDef = manager.createPropertyDefinitionTemplate();
        propertyDef.setName("tt:friend");
        propertyDef.setMultiple(true);
        propertyDef.setRequiredType(9);
        propertyDef.setOnParentVersion(1);
        propertyDef.setProtected(false);
        nodeType.getPropertyDefinitionTemplates().add(propertyDef);
        manager.registerNodeType((NodeTypeDefinition)nodeType, true);
        String USER_NAME = "Paul";
        Node userNode = this.session.getRootNode().addNode("Paul", "nt:folder");
        userNode.addMixin("tt:friendly");
        this.session.save();
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        String expression = "SELECT grantee.* FROM [tt:friendly] as grantee INNER JOIN [tt:friendly] as grantor ON grantee.[jcr:uuid] = grantor.[tt:friend]";
        QueryResult queryResult = queryManager.createQuery(expression, "JCR-SQL2").execute();
        Assert.assertThat((Object)queryResult, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        expression = "SELECT grantee.* FROM [tt:friendly] as grantor INNER JOIN [tt:friendly] as grantee ON grantor.[tt:friend] = grantee.[jcr:uuid]";
        queryResult = queryManager.createQuery(expression, "JCR-SQL2").execute();
        Assert.assertThat((Object)queryResult, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-13xx"})
    public void testShouldQueryUsingJoinWithMultiValueReferenceInJoinCondition() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        String friendlyNodeType = "tt:friendly";
        String friendPropertyName = "tt:friend";
        NamespaceRegistry registry = this.session.getWorkspace().getNamespaceRegistry();
        registry.registerNamespace("tt", "http://test.com/tt");
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        javax.jcr.nodetype.NodeTypeTemplate nodeType = manager.createNodeTypeTemplate();
        nodeType.setMixin(true);
        nodeType.setName("tt:friendly");
        nodeType.setQueryable(true);
        nodeType.setDeclaredSuperTypeNames(new String[]{"mix:referenceable"});
        javax.jcr.nodetype.PropertyDefinitionTemplate propertyDef = manager.createPropertyDefinitionTemplate();
        propertyDef.setName("tt:friend");
        propertyDef.setMultiple(true);
        propertyDef.setRequiredType(9);
        propertyDef.setOnParentVersion(1);
        propertyDef.setProtected(false);
        nodeType.getPropertyDefinitionTemplates().add(propertyDef);
        manager.registerNodeType((NodeTypeDefinition)nodeType, true);
        Node granteeNode = this.session.getRootNode().addNode("Paul", "nt:folder");
        granteeNode.addMixin("tt:friendly");
        Node grantorNode = this.session.getRootNode().addNode("Pedro", "nt:folder");
        grantorNode.addMixin("tt:friendly");
        ValueFactory valueFactory = this.session.getValueFactory();
        Value granteeValue = valueFactory.createValue(granteeNode);
        grantorNode.setProperty("tt:friend", new Value[]{granteeValue});
        try {
            this.session.save();
            QueryManager queryManager = this.session.getWorkspace().getQueryManager();
            String expression = "SELECT grantee.* FROM [tt:friendly] as grantee INNER JOIN [tt:friendly] as grantor ON grantee.[jcr:uuid] = grantor.[tt:friend]";
            Query query = queryManager.createQuery("SELECT grantee.* FROM [tt:friendly] as grantee INNER JOIN [tt:friendly] as grantor ON grantee.[jcr:uuid] = grantor.[tt:friend]", "JCR-SQL2");
            QueryResult queryResult = query.execute();
            Assert.assertThat((Object)queryResult.getRows().getSize(), (Matcher)Is.is((Object)1L));
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            granteeNode.remove();
            grantorNode.remove();
            this.session.save();
            throw throwable;
        }
        granteeNode.remove();
        grantorNode.remove();
        this.session.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-13xx"})
    public void testShouldQueryUsingJoinWithSingleValueReferenceInJoinCondition() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        String friendlyNodeType = "tt:friendly";
        String friendPropertyName = "tt:friend";
        NamespaceRegistry registry = this.session.getWorkspace().getNamespaceRegistry();
        registry.registerNamespace("tt", "http://test.com/tt");
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        javax.jcr.nodetype.NodeTypeTemplate nodeType = manager.createNodeTypeTemplate();
        nodeType.setMixin(true);
        nodeType.setName("tt:friendly");
        nodeType.setQueryable(true);
        nodeType.setDeclaredSuperTypeNames(new String[]{"mix:referenceable"});
        javax.jcr.nodetype.PropertyDefinitionTemplate propertyDef = manager.createPropertyDefinitionTemplate();
        propertyDef.setName("tt:friend");
        propertyDef.setMultiple(false);
        propertyDef.setRequiredType(9);
        propertyDef.setOnParentVersion(1);
        propertyDef.setProtected(false);
        nodeType.getPropertyDefinitionTemplates().add(propertyDef);
        manager.registerNodeType((NodeTypeDefinition)nodeType, true);
        Node granteeNode = this.session.getRootNode().addNode("Paul", "nt:folder");
        granteeNode.addMixin("tt:friendly");
        Node grantorNode = this.session.getRootNode().addNode("Pedro", "nt:folder");
        grantorNode.addMixin("tt:friendly");
        ValueFactory valueFactory = this.session.getValueFactory();
        Value granteeValue = valueFactory.createValue(granteeNode);
        grantorNode.setProperty("tt:friend", granteeValue);
        try {
            this.session.save();
            QueryManager queryManager = this.session.getWorkspace().getQueryManager();
            String expression = "SELECT grantee.* FROM [tt:friendly] as grantee INNER JOIN [tt:friendly] as grantor ON grantee.[jcr:uuid] = grantor.[tt:friend]";
            Query query = queryManager.createQuery("SELECT grantee.* FROM [tt:friendly] as grantee INNER JOIN [tt:friendly] as grantor ON grantee.[jcr:uuid] = grantor.[tt:friend]", "JCR-SQL2");
            QueryResult queryResult = query.execute();
            Assert.assertThat((Object)queryResult.getRows().getSize(), (Matcher)Is.is((Object)1L));
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            granteeNode.remove();
            grantorNode.remove();
            this.session.save();
            throw throwable;
        }
        granteeNode.remove();
        grantorNode.remove();
        this.session.save();
    }

    @FixFor(value={"MODE-693"})
    public void testShouldAllowDeletingNodesWhenLargePropertyIsPresent() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        int SIZE = 2048;
        byte[] largeArray = new byte[2048];
        for (int i = 0; i < 2048; ++i) {
            largeArray[i] = 120;
        }
        Node projectNode = root.addNode("mode693", "nt:unstructured");
        Node fileNode = projectNode.addNode("fileNode", "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        Binary binaryValue = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(largeArray));
        contentNode.setProperty("jcr:data", binaryValue);
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        contentNode.setProperty("jcr:mimeType", "application/octet-stream");
        Node otherNode = projectNode.addNode("otherNode", "nt:unstructured");
        this.session.save();
        String pathToNode = projectNode.getName() + "/" + otherNode.getName();
        if (!root.hasNode(pathToNode)) {
            throw new RepositoryException("Cannot delete node at path=" + pathToNode + " since no node exists at this path");
        }
        Node nodeToDelete = root.getNode(pathToNode);
        nodeToDelete.remove();
        this.session.save();
        Assert.assertThat((Object)root.hasNode(projectNode.getName()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)projectNode.hasNode(fileNode.getName()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)fileNode.hasNode(contentNode.getName()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)root.hasNode(pathToNode), (Matcher)Is.is((Object)false));
    }

    @FixFor(value={"MODE-704"})
    public void testShouldReturnSilentlyWhenCheckingOutACheckedOutNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node testNode = root.addNode("checkedOutNodeTest", "nt:unstructured");
        this.session.save();
        testNode.addMixin("mix:versionable");
        this.checkout(testNode);
        this.session.save();
        this.checkout(testNode);
    }

    @FixFor(value={"MODE-709"})
    public void testShouldCreateVersionStorageForWhenVersionableNodesCopied() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("versionableNodeForCopy", "nt:unstructured");
        parentNode.addMixin("mix:versionable");
        Node childNode = parentNode.addNode("versionableChild", "nt:unstructured");
        childNode.addMixin("mix:versionable");
        Node targetNode = root.addNode("destForCopy", "nt:unstructured");
        this.session.save();
        String newParentPath = targetNode.getPath() + "/" + parentNode.getName();
        this.session.getWorkspace().copy(parentNode.getPath(), newParentPath);
        parentNode = (Node)this.session.getItem(newParentPath);
        childNode = parentNode.getNode("versionableChild");
        this.checkout(parentNode);
        this.checkin(parentNode);
        this.checkout(childNode);
        this.checkin(childNode);
    }

    @FixFor(value={"MODE-720"})
    public void testShouldBeAbleToReferToUnsavedReferenceNode() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        JcrNodeTypeManager nodeTypes = (JcrNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = nodeTypes.createNodeTypeTemplate();
        ntt.setName("modetest:constrainedPropType");
        PropertyDefinitionTemplate pdt = nodeTypes.createPropertyDefinitionTemplate();
        pdt.setName("modetest:constrainedProp");
        pdt.setRequiredType(9);
        pdt.setValueConstraints(new String[]{"nt:unstructured"});
        ntt.getPropertyDefinitionTemplates().add(pdt);
        nodeTypes.registerNodeType((NodeTypeDefinition)ntt, false);
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("constrainedNodeTest", "nt:unstructured");
        Node targetNode = parentNode.addNode("target", "nt:unstructured");
        targetNode.addMixin("mix:referenceable");
        Node referringNode = parentNode.addNode("referer", "modetest:constrainedPropType");
        referringNode.setProperty("modetest:constrainedProp", targetNode);
        this.session.save();
    }

    @FixFor(value={"MODE-1092"})
    public void testShouldBeAbleToSetWeakReferences() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        JcrNodeTypeManager nodeTypes = (JcrNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = nodeTypes.createNodeTypeTemplate();
        ntt.setName("modetest:typeWithWeakReference");
        PropertyDefinitionTemplate pdt = nodeTypes.createPropertyDefinitionTemplate();
        pdt.setName("modetest:weakRefProp");
        pdt.setRequiredType(10);
        pdt.setValueConstraints(new String[]{"nt:unstructured"});
        ntt.getPropertyDefinitionTemplates().add(pdt);
        nodeTypes.registerNodeType((NodeTypeDefinition)ntt, false);
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("weakReferenceTest", "nt:unstructured");
        Node targetNode = parentNode.addNode("target", "nt:unstructured");
        targetNode.addMixin("mix:referenceable");
        Node referringNode = parentNode.addNode("referer", "modetest:typeWithWeakReference");
        referringNode.setProperty("modetest:weakRefProp", targetNode);
        this.session.save();
        Node referringNode2 = this.session.getNode("/weakReferenceTest/referer");
        Property property = referringNode2.getProperty("modetest:weakRefProp");
        Assert.assertThat((Object)property.getType(), (Matcher)Is.is((Object)10));
        Node referredNode = property.getNode();
        Assert.assertThat((Object)referredNode, (Matcher)Is.is((Object)targetNode));
    }

    @FixFor(value={"MODE-701"})
    public void testShouldBeAbleToImportAutocreatedChildNodeWithoutDuplication() throws Exception {
        this.session = this.getHelper().getSuperuserSession();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("autocreatedChildRoot", "nt:unstructured");
        this.session.save();
        Node targetNode = parentNode.addNode("nodeWithAutocreatedChild", "modetest:nodeWithAutocreatedChild");
        Assert.assertThat((Object)targetNode.getNode("modetest:autocreatedChild"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.session.refresh(false);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/io/autocreated-node-test.xml");
        this.session.importXML("/autocreatedChildRoot", in, 3);
    }

    public void testShouldAllowCheckoutAfterMove() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node sourceNode = root.addNode("versionableSource", "nt:unstructured");
        sourceNode.addMixin("mix:versionable");
        Node targetNode = root.addNode("versionableTarget", "nt:unstructured");
        this.session.save();
        String sourceName = sourceNode.getName();
        this.session.move(sourceNode.getPath(), targetNode.getPath() + "/" + sourceName);
        sourceNode = targetNode.getNode(sourceName);
        this.checkout(sourceNode);
    }

    public void testShouldNotAllowLockedNodeToBeRemoved() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("lockedParent");
        parentNode.addMixin("mix:lockable");
        Node targetNode = parentNode.addNode("lockedTarget");
        this.session.save();
        this.lock(parentNode, true, true);
        Session session2 = this.getHelper().getReadWriteSession();
        Node targetNode2 = (Node)session2.getItem("/lockedParent/lockedTarget");
        try {
            targetNode2.remove();
            ModeShapeTckTest.fail((String)"Locked nodes should not be able to be removed");
        }
        catch (LockException le) {
            // empty catch block
        }
        targetNode.remove();
        this.session.save();
    }

    public void testShouldNotAllowPropertyOfLockedNodeToBeRemoved() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("lockedPropParent");
        parentNode.addMixin("mix:lockable");
        Node targetNode = parentNode.addNode("lockedTarget");
        targetNode.setProperty("foo", "bar");
        this.session.save();
        this.lock(parentNode, true, true);
        Session session2 = this.getHelper().getReadWriteSession();
        Property targetProp2 = (Property)session2.getItem("/lockedPropParent/lockedTarget/foo");
        try {
            targetProp2.remove();
            ModeShapeTckTest.fail((String)"Properties of locked nodes should not be able to be removed");
        }
        catch (LockException le) {
            // empty catch block
        }
        targetNode.getProperty("foo").remove();
        this.session.save();
    }

    public void testShouldNotAllowCheckedInNodeToBeRemoved() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("checkedInParent");
        parentNode.addMixin("mix:versionable");
        Node targetNode = parentNode.addNode("checkedInTarget");
        this.session.save();
        this.checkin(parentNode);
        try {
            targetNode.remove();
            ModeShapeTckTest.fail((String)"Checked in nodes should not be able to be removed");
        }
        catch (VersionException ve) {
            // empty catch block
        }
        this.checkout(parentNode);
        targetNode.remove();
        this.session.save();
    }

    public void testShouldNotAllowPropertyOfCheckedInNodeToBeRemoved() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("checkedInPropParent");
        parentNode.addMixin("mix:versionable");
        Node targetNode = parentNode.addNode("checkedInTarget");
        Property targetProp = targetNode.setProperty("foo", "bar");
        this.session.save();
        this.checkin(parentNode);
        try {
            targetProp.remove();
            ModeShapeTckTest.fail((String)"Properties of checked in nodes should not be able to be removed");
        }
        catch (VersionException ve) {
            // empty catch block
        }
        this.checkout(parentNode);
        targetProp.remove();
        this.session.save();
    }

    public void testGetPathOnRemovedNodeShouldThrowException() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("invalidItemStateTest");
        this.session.save();
        parentNode.remove();
        try {
            parentNode.getPath();
            ModeShapeTckTest.fail((String)"getPath on removed node should throw InvalidItemStateException per section 7.1.3.3 of 1.0.1 spec");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    @FixFor(value={"MODE-792"})
    public void testCheckingOutAnAlreadyCheckedOutNodeShouldHaveNoEffect() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        VersionManager versionManager = this.session.getWorkspace().getVersionManager();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("checkedOutNodeNopTest");
        parentNode.addMixin("mix:versionable");
        this.session.save();
        versionManager.checkin(parentNode.getPath());
        versionManager.checkout(parentNode.getPath());
        parentNode.setProperty("foo", "bar");
        versionManager.checkout(parentNode.getPath());
        ModeShapeTckTest.assertEquals((String)parentNode.getProperty("foo").getString(), (String)"bar");
    }

    @FixFor(value={"MODE-793"})
    public void testPropertyCardinalityShouldPropagateToFrozenNode() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        VersionManager versionManager = this.session.getWorkspace().getVersionManager();
        Node root = this.session.getRootNode();
        Node parentNode = root.addNode("checkedOutNodeNopTest");
        parentNode.addMixin("mix:versionable");
        parentNode.setProperty("foo", new String[]{"bar", "baz"});
        this.session.save();
        ModeShapeTckTest.assertEquals((boolean)true, (boolean)parentNode.getProperty("foo").getDefinition().isMultiple());
        Version version = versionManager.checkin(parentNode.getPath());
        Node frozenNode = version.getFrozenNode();
        ModeShapeTckTest.assertEquals((boolean)true, (boolean)frozenNode.getProperty("foo").getDefinition().isMultiple());
    }

    @FixFor(value={"MODE-799"})
    public void testNodeWithoutETagMixinShouldNotHaveETagProperty() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        root.addNode("someNewNode");
        this.session.save();
        Assert.assertThat((Object)root.getNode("someNewNode").hasProperty("jcr:etag"), (Matcher)Is.is((Object)false));
    }

    @FixFor(value={"MODE-799"})
    public void testAutomaticCreationUponSaveOfETagPropertyWhenETagMixinIsAddedToNodeWithoutBinaryProperties() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node newNode = root.addNode("someNewNode4");
        newNode.addMixin("mix:etag");
        this.session.save();
        String etagValue = root.getNode("someNewNode4").getProperty("jcr:etag").getString();
        Assert.assertThat((Object)etagValue, (Matcher)Is.is((Object)""));
    }

    @FixFor(value={"MODE-799"})
    public void testAutomaticCreationUponSaveOfETagPropertyWhenETagMixinIsAddedToNodeWithExistingBinaryProperties() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node newNode = root.addNode("someNewNode2");
        Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream("This is the value".getBytes()));
        newNode.setProperty("binaryProperty", binary);
        this.session.save();
        root.getNode("someNewNode2").addMixin("mix:etag");
        this.session.save();
        String etagExpected = new String(((JcrBinary)binary).binary().getHash());
        String etagValue = root.getNode("someNewNode2").getProperty("jcr:etag").getString();
        Assert.assertThat((Object)etagValue, (Matcher)Is.is((Object)etagExpected));
    }

    @FixFor(value={"MODE-799"})
    public void testAutomaticCreationUponSaveOfETagPropertyWhenNodeWithETagMixinHasNewBinaryProperty() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node newNode = root.addNode("someNewNode3");
        newNode.addMixin("mix:etag");
        this.session.save();
        Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream("This is the value".getBytes()));
        root.getNode("someNewNode3").setProperty("binaryProperty", binary);
        this.session.save();
        String etagExpected = new String(((JcrBinary)binary).binary().getHash());
        String etagValue = root.getNode("someNewNode3").getProperty("jcr:etag").getString();
        Assert.assertThat((Object)etagValue, (Matcher)Is.is((Object)etagExpected));
    }

    @FixFor(value={"MODE-796"})
    public void testNodeReferenceRemainsValidAfterSave() throws Exception {
        this.session = this.getHelper().getReadWriteSession();
        Node root = this.session.getRootNode();
        Node nodeA = root.addNode("nodeA", "nt:unstructured");
        nodeA.setProperty("foo", "bar A");
        Node nodeB = root.addNode("nodeB", "nt:unstructured");
        nodeB.setProperty("foo", "bar B");
        this.session.save();
        Assert.assertThat((Object)nodeA.getPath(), (Matcher)Is.is((Object)"/nodeA"));
        Assert.assertThat((Object)nodeB.getPath(), (Matcher)Is.is((Object)"/nodeB"));
        this.session.move(nodeA.getPath(), "/nodeB/nodeA");
        Assert.assertThat((Object)nodeA.getPath(), (Matcher)Is.is((Object)"/nodeB/nodeA"));
        Assert.assertThat((Object)nodeB.getPath(), (Matcher)Is.is((Object)"/nodeB"));
        this.session.save();
        Assert.assertThat((Object)nodeA.getPath(), (Matcher)Is.is((Object)"/nodeB/nodeA"));
        Assert.assertThat((Object)nodeB.getPath(), (Matcher)Is.is((Object)"/nodeB"));
    }

    @FixFor(value={"MODE-956"})
    public void testShouldBeAbleToSetNonexistingPropertyToNull() throws Exception {
        Node rootNode = this.superuser.getRootNode();
        Node child = rootNode.addNode("child", "nt:unstructured");
        rootNode.getSession().save();
        child.setProperty("foo", (Calendar)null);
    }

    @FixFor(value={"MODE-1005"})
    public void testShouldThrowRepositoryExceptionForRelativePathsInSessionGetNode() throws Exception {
        try {
            Node root = this.superuser.getRootNode();
            root.addNode("nodeForRelativePathTest", "nt:unstructured");
            this.superuser.getNode("nodeForRelativePathTest");
            ModeShapeTckTest.fail((String)"Should throw RepositoryException when attempting to call Session.getNode(String) with a relative path");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @FixFor(value={"MODE-1005"})
    public void testShouldThrowRepositoryExceptionForRelativePathsInSessionGetProperty() throws Exception {
        try {
            Node root = this.superuser.getRootNode();
            root.addNode("propertyNodeForRelativePathTest", "nt:unstructured");
            this.superuser.getProperty("propertyNodeForRelativePathTest/jcr:primaryType");
            ModeShapeTckTest.fail((String)"Should throw RepositoryException when attempting to call Session.getProperty(String) with a relative path");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    private void ensureExactlyOneVersionRoot(VersionManager vm, String absPath) throws Exception {
        boolean foundRoot = false;
        VersionHistory vh = vm.getVersionHistory(absPath);
        VersionIterator vi = vh.getAllVersions();
        while (vi.hasNext()) {
            Version v = vi.nextVersion();
            if (!"jcr:rootVersion".equals(v.getName())) continue;
            if (foundRoot) {
                ModeShapeTckTest.fail((String)("Found multiple root versions of versionable node at " + absPath));
            }
            foundRoot = true;
        }
        if (!foundRoot) {
            ModeShapeTckTest.fail((String)("No root version found for versionable node at " + absPath));
        }
    }

    @FixFor(value={"MODE-1017"})
    public void testShouldNotHaveTwoRootVersions() throws Exception {
        Session session = this.superuser;
        ValueFactory vf = session.getValueFactory();
        Node root = session.getRootNode();
        Node file = root.addNode("createfile.mode", "nt:file");
        Node content = file.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:data", vf.createBinary((InputStream)new ByteArrayInputStream("Write 1".getBytes())));
        session.save();
        file.addMixin("mix:versionable");
        this.ensureExactlyOneVersionRoot(session.getWorkspace().getVersionManager(), "/createfile.mode");
        session.save();
        this.ensureExactlyOneVersionRoot(session.getWorkspace().getVersionManager(), "/createfile.mode");
        session.refresh(false);
        this.ensureExactlyOneVersionRoot(session.getWorkspace().getVersionManager(), "/createfile.mode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyShallowLockPreventsOtherSessionsFromChangingPropertiesOnLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", false, false, 100000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toChange = session2.getNode("/tmp/node1/node2");
        try {
            try {
                toChange.addMixin("mix:versionable");
                ModeShapeTckTest.fail((String)"Expected to see LockException");
            }
            catch (LockException e) {
                Object var12_11 = null;
                tmp.remove();
                session1.save();
                session1.logout();
                session2.logout();
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyShallowLockAllowsOtherSessionsToDeleteLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", false, false, 100000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toDelete = session2.getNode("/tmp/node1/node2");
        try {
            toDelete.remove();
            session2.save();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyShallowLockAllowsSameSessionToDeleteLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", false, false, 10000L, "Locked");
        session1.save();
        try {
            node3.remove();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyShallowLockPreventsOtherSessionsFromDeletingChildOfLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", false, false, 10000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toDelete = session2.getNode("/tmp/node1/node2/node3");
        try {
            try {
                toDelete.remove();
                ModeShapeTckTest.fail((String)"Expected to see LockException");
            }
            catch (LockException e) {
                Object var12_11 = null;
                tmp.remove();
                session1.save();
                session1.logout();
                session2.logout();
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyShallowLockAllowsSameSessionToDeleteChildOfLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", false, false, 10000L, "Locked");
        session1.save();
        try {
            node3.remove();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyShallowLockAllowOtherSessionsToChangePropertiesOfChildOfLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", false, false, 100000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toChange = session2.getNode("/tmp/node1/node2/node3");
        try {
            toChange.addMixin("mix:referenceable");
            session2.save();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyShallowLockAllowsSameSessionToChangeChildProperties() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:unstructured");
        Node node1 = tmp.addNode("node1", "nt:unstructured");
        Node node2 = tmp.addNode("node1/node2", "nt:unstructured");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:unstructured");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", false, false, 100000L, "Locked");
        session1.save();
        Node toChange = node2;
        try {
            toChange.setProperty("newProp", "newValue");
            session1.save();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyAddingMixinAndSavingRequiredBeforeLockingNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        try {
            try {
                node2.addMixin("mix:lockable");
                lm1.lock("/tmp/node1/node2", false, false, 10000L, "Locked");
                session1.save();
            }
            catch (InvalidItemStateException e) {
                Object var10_9 = null;
                tmp.remove();
                session1.save();
                session1.logout();
                return;
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyDeepLockPreventsOtherSessionsFromChangingPropertiesOnLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", true, false, 100000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toChange = session2.getNode("/tmp/node1/node2");
        try {
            try {
                toChange.addMixin("mix:versionable");
                ModeShapeTckTest.fail((String)"Expected to see LockException");
            }
            catch (LockException e) {
                Object var12_11 = null;
                tmp.remove();
                session1.save();
                session1.logout();
                session2.logout();
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyDeepLockAllowsOtherSessionsToDeleteLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", true, false, 100000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toDelete = session2.getNode("/tmp/node1/node2");
        try {
            toDelete.remove();
            session2.save();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyDeepLockAllowsSameSessionToDeleteLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", true, false, 10000L, "Locked");
        session1.save();
        try {
            node3.remove();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyDeepLockPreventsOtherSessionsFromDeletingChildOfLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", true, false, 10000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toDelete = session2.getNode("/tmp/node1/node2/node3");
        try {
            try {
                toDelete.remove();
                ModeShapeTckTest.fail((String)"Expected to see LockException");
            }
            catch (LockException e) {
                Object var12_11 = null;
                tmp.remove();
                session1.save();
                session1.logout();
                session2.logout();
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyDeepLockAllowsSameSessionToDeleteChildOfLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", true, false, 10000L, "Locked");
        session1.save();
        try {
            node3.remove();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyDeepLockPreventsOtherSessionsFromChangePropertiesOfChildOfLockedNode() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        Session session2 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:folder");
        Node node1 = tmp.addNode("node1", "nt:folder");
        Node node2 = tmp.addNode("node1/node2", "nt:folder");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:folder");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", true, false, 100000L, "Locked");
        session1.save();
        session2.refresh(true);
        Node toChange = session2.getNode("/tmp/node1/node2/node3");
        try {
            try {
                toChange.addMixin("mix:referenceable");
                session2.save();
                ModeShapeTckTest.fail((String)"Expected to see LockException");
            }
            catch (LockException e) {
                Object var12_11 = null;
                tmp.remove();
                session1.save();
                session1.logout();
                session2.logout();
                return;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            session2.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
        session2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FixFor(value={"MODE-1040"})
    public void testShouldVerifyDeepLockAllowsSameSessionToChangeChildProperties() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        LockManager lm1 = session1.getWorkspace().getLockManager();
        Node root1 = session1.getRootNode();
        Node tmp = root1.addNode("tmp", "nt:unstructured");
        Node node1 = tmp.addNode("node1", "nt:unstructured");
        Node node2 = tmp.addNode("node1/node2", "nt:unstructured");
        Node node3 = tmp.addNode("node1/node2/node3", "nt:unstructured");
        session1.save();
        node2.addMixin("mix:lockable");
        session1.save();
        lm1.lock("/tmp/node1/node2", true, false, 100000L, "Locked");
        session1.save();
        Node toChange = node2;
        try {
            toChange.setProperty("newProp", "newValue");
            session1.save();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            tmp.remove();
            session1.save();
            session1.logout();
            throw throwable;
        }
        tmp.remove();
        session1.save();
        session1.logout();
    }

    @FixFor(value={"MODE-1089"})
    public void testShouldNotFailGettingVersionHistoryForNodeMadeVersionableSinceLastSave() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        VersionManager vm = session1.getWorkspace().getVersionManager();
        Node root = session1.getRootNode();
        Node area = root.addNode("tmp2", "nt:unstructured");
        Node outer = area.addNode("outerFolder");
        Node inner = outer.addNode("innerFolder");
        Node file = inner.addNode("testFile.dat");
        file.setProperty("jcr:mimeType", "text/plain");
        file.setProperty("jcr:data", "Original content");
        session1.save();
        file.addMixin("mix:versionable");
        this.isVersionable(vm, file);
        session1.save();
        Version v1 = vm.checkin(file.getPath());
        Assert.assertThat((Object)v1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    boolean isVersionable(VersionManager vm, Node node) throws RepositoryException {
        try {
            vm.getVersionHistory(node.getPath());
            return true;
        }
        catch (UnsupportedRepositoryOperationException e) {
            return false;
        }
    }

    protected void checkinRecursively(Node node, VersionManager vm) throws RepositoryException {
        String path = node.getPath();
        if (node.isNodeType("mix:versionable") && vm.isCheckedOut(path)) {
            try {
                vm.checkin(path);
            }
            catch (VersionException e) {
                node.remove();
                return;
            }
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.checkinRecursively(iter.nextNode(), vm);
        }
    }

    @FixFor(value={"MODE-1234"})
    public void testShouldFindCheckedOutNodesByQuerying() throws Exception {
        Session session1 = this.getHelper().getSuperuserSession();
        VersionManager vm = session1.getWorkspace().getVersionManager();
        Node root = session1.getRootNode();
        this.checkinRecursively(root, vm);
        Node area = root.addNode("tmp2", "nt:unstructured");
        Node outer = area.addNode("outerFolder");
        Node inner = outer.addNode("innerFolder");
        Node file = inner.addNode("testFile.dat");
        file.setProperty("jcr:mimeType", "text/plain");
        file.setProperty("jcr:data", "Original content");
        session1.save();
        file.addMixin("mix:versionable");
        this.isVersionable(vm, file);
        session1.save();
        Version v1 = vm.checkin(file.getPath());
        Assert.assertThat((Object)v1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        CountDownListener listener = this.registerCountDownListener(session1, file.getPath(), 1);
        this.queryForCheckedOutVersionables(session1, 0, false);
        vm.checkout(file.getPath());
        listener.await(2, TimeUnit.SECONDS);
        listener.unregister();
        this.queryForCheckedOutVersionables(session1, 1, false);
        listener = this.registerCountDownListener(session1, file.getPath(), 1);
        vm.checkin(file.getPath());
        listener.await(2, TimeUnit.SECONDS);
        listener.unregister();
        this.queryForCheckedOutVersionables(session1, 0, false);
    }

    protected int queryForCheckedOutVersionables(Session session, int expected, boolean print) throws RepositoryException {
        String queryStr = "SELECT * FROM [nt:unstructured] AS node JOIN [mix:versionable] AS versionable ON ISSAMENODE(node,versionable) WHERE versionable.[jcr:isCheckedOut] = true";
        QueryResult result = this.query(session, queryStr);
        int actual = (int)result.getRows().getSize();
        if (print) {
            System.out.println("Result = \n" + result);
        }
        if (actual != expected) {
            queryStr = "SELECT * FROM [nt:unstructured] AS node JOIN [mix:versionable] AS versionable ON ISSAMENODE(node,versionable)";
            result = this.query(session, queryStr);
            System.out.println(result);
        }
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        return actual;
    }

    protected QueryResult query(Session session, String queryStr) throws RepositoryException {
        Query query = session.getWorkspace().getQueryManager().createQuery(queryStr, "JCR-SQL2");
        QueryResult result = query.execute();
        return result;
    }

    protected CountDownListener registerCountDownListener(Session session, String path, int counts) throws RepositoryException {
        CountDownListener listener = new CountDownListener(session, counts);
        session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, 20, path, true, null, null, false);
        return listener;
    }

    @FixFor(value={"MODE-1050"})
    public void testShouldSuccessfullyRegisterChildAndParentSameTypes() throws RepositoryException {
        Session session = this.getHelper().getSuperuserSession();
        session.getWorkspace().getNamespaceRegistry().registerNamespace("mx", "urn:test");
        NodeTypeManager nodeTypeMgr = session.getWorkspace().getNodeTypeManager();
        javax.jcr.nodetype.NodeTypeTemplate nodeType = nodeTypeMgr.createNodeTypeTemplate();
        nodeType.setName("mx:type");
        nodeType.setDeclaredSuperTypeNames(new String[]{"nt:folder"});
        NodeDefinitionTemplate subTypes = nodeTypeMgr.createNodeDefinitionTemplate();
        subTypes.setRequiredPrimaryTypeNames(new String[]{"mx:type"});
        nodeType.getNodeDefinitionTemplates().add(subTypes);
        nodeTypeMgr.registerNodeType((NodeTypeDefinition)nodeType, false);
    }

    protected static class CountDownListener
    implements EventListener {
        final CountDownLatch latch;
        final Session session;

        public CountDownListener(Session session, int counts) {
            this.session = session;
            this.latch = new CountDownLatch(counts);
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                try {
                    this.latch.countDown();
                    events.nextEvent();
                }
                catch (Throwable e) {
                    this.latch.countDown();
                    junit.framework.Assert.fail((String)e.getMessage());
                }
            }
        }

        public void await(int time, TimeUnit unit) {
            try {
                this.latch.await(time, unit);
            }
            catch (InterruptedException e) {
                junit.framework.Assert.fail((String)e.getMessage());
            }
        }

        public void unregister() throws RepositoryException {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
    }
}

