/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.process.QueryResultColumns;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.XPathQueryResult;

public class XPathQueryResultTest {
    private XPathQueryResult result;
    private JcrQueryContext context;
    private String query;
    private QueryResults graphResult;
    private Schemata schemata;
    private QueryResults.Columns resultColumns;
    private List<String> columnTypes;
    private List<String> columnNames;
    private List<Column> columns;

    @Before
    public void beforeEach() {
        this.schemata = (Schemata)Mockito.mock(Schemata.class);
        this.context = (JcrQueryContext)Mockito.mock(JcrQueryContext.class);
        this.query = "SELECT jcr:primaryType, foo:bar FROM nt:unstructured";
        this.graphResult = (QueryResults)Mockito.mock(QueryResults.class);
        this.columnTypes = Arrays.asList("STRING", "LONG");
        this.columnNames = Arrays.asList("jcr:primaryType", "foo:bar");
        SelectorName tableName = new SelectorName("nt:unstructured");
        this.columns = Arrays.asList(new Column(tableName, this.columnNames.get(0), this.columnNames.get(0)), new Column(tableName, this.columnNames.get(1), this.columnNames.get(1)));
        this.resultColumns = new QueryResultColumns(this.columns, this.columnTypes, true);
        Mockito.when((Object)this.graphResult.getColumns()).thenReturn((Object)this.resultColumns);
        this.result = new XPathQueryResult(this.context, this.query, this.graphResult, this.schemata);
    }

    @Test
    public void shouldHaveSameNumberOfColumnNamesAsTypes() {
        Assert.assertThat((Object)this.result.getColumnNames(), (Matcher)Is.is((Object)new String[]{"jcr:path", "jcr:score", "jcr:primaryType", "foo:bar"}));
        Assert.assertThat((Object)this.result.getColumnTypes(), (Matcher)Is.is((Object)new String[]{"STRING", "DOUBLE", "STRING", "LONG"}));
    }
}

