/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.InputStream;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.wsdl.WsdlSequencer;

public class WsdlSequencerTest {
    private ExecutionContext execContext;
    private MockSequencerOutput output;
    private StreamSequencerContext context;
    private static WsdlSequencer sequencer;
    private boolean print;

    @Before
    public void beforeEach() {
        this.print = false;
        this.execContext = new ExecutionContext();
        this.execContext.getNamespaceRegistry().register("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.execContext.getNamespaceRegistry().register("sramp", "http://s-ramp.org/xmlns/2010/s-ramp");
        if (sequencer == null) {
            sequencer = new WsdlSequencer();
        }
    }

    @After
    public void afterEach() {
        System.out.flush();
        System.err.flush();
        this.context = null;
        this.output = null;
    }

    protected void sequence(String pathToFile) {
        InputStream stream = this.load(pathToFile);
        this.context = new MockSequencerContext(this.execContext, pathToFile);
        this.output = new MockSequencerOutput(this.context, true);
        sequencer.sequence(stream, (SequencerOutput)this.output, this.context);
        if (this.context.getProblems().hasProblems()) {
            System.out.println(this.context.getProblems());
            Assert.fail((String)("At least one problem sequencing \"" + pathToFile + "\""));
        }
    }

    @Test
    public void shouldBeAbleToSequence_loanServicePT() {
        this.sequence("loanServicePT.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_api_v3_portType() {
        this.sequence("uddi_api_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_custody_v3_binding() {
        this.sequence("uddi_custody_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_repl_v3_binding() {
        this.sequence("uddi_repl_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_repl_v3_portType() {
        this.sequence("uddi_repl_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_sub_v3_binding() {
        this.sequence("uddi_sub_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_sub_v3_portType() {
        this.sequence("uddi_sub_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_sbr_v3_binding() {
        this.sequence("uddi_subr_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_v3_service() {
        this.sequence("uddi_v3_service.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vs_v3_binding() {
        this.sequence("uddi_vs_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vs_v3_portType() {
        this.sequence("uddi_vs_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vscache_v3_binding() {
        this.sequence("uddi_vscache_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToSequence_uddi_vscache_v3_portType() {
        this.sequence("uddi_vscache_v3_portType.wsdl");
        this.printOutput();
    }

    protected void printOutput() {
        if (this.print) {
            for (Path path : this.output.getOrderOfCreation()) {
                Map props = this.output.getProperties(path);
                for (Map.Entry entry : props.entrySet()) {
                    System.out.println(this.string(path) + " " + ((Property)entry.getValue()).getString(this.context.getNamespaceRegistry()));
                }
            }
        }
    }

    protected InputStream load(String resourcePath) {
        InputStream stream = this.getClass().getResourceAsStream("/" + resourcePath);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        return stream;
    }

    protected final Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected final Path relativePath(Name ... segments) {
        return this.context.getValueFactories().getPathFactory().createRelativePath(segments);
    }

    protected final String string(String path) {
        return (String)this.context.getValueFactories().getStringFactory().create(path);
    }

    protected final String string(Object value) {
        return (String)this.context.getValueFactories().getStringFactory().create(value);
    }

    protected final Name name(String path) {
        return (Name)this.context.getValueFactories().getNameFactory().create(path);
    }
}

