/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.example.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.example.repository.ConsoleInput;
import org.modeshape.example.repository.UserInterface;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JaasSecurityContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.picketbox.config.PicketBoxConfiguration;
import org.picketbox.factories.SecurityFactory;
import org.xml.sax.SAXException;

public class RepositoryClient {
    public static final String INMEMORY_REPOSITORY_SOURCE_CLASSNAME = "org.modeshape.connector.inmemory.InMemoryRepositorySource";
    public static final String JAAS_LOGIN_CONTEXT_NAME = "modeshape-jcr";
    private Api api = Api.JCR;
    private String jaasContextName = "modeshape-jcr";
    private UserInterface userInterface;
    private LoginContext loginContext;
    private JcrEngine engine;

    public static void main(String[] args) {
        SecurityFactory.prepare();
        try {
            PicketBoxConfiguration idtrustConfig = new PicketBoxConfiguration();
            idtrustConfig.load("security/jaas.conf.xml");
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        RepositoryClient client = new RepositoryClient();
        for (String arg : args) {
            if ((arg = arg.trim()).equals("--api=jcr")) {
                client.setApi(Api.JCR);
            }
            if (arg.equals("--api=dna")) {
                client.setApi(Api.ModeShape);
            }
            if (arg.equals("--jaas")) {
                client.setJaasContextName(JAAS_LOGIN_CONTEXT_NAME);
            }
            if (!arg.startsWith("--jaas=") || arg.length() <= 7) continue;
            client.setJaasContextName(arg.substring(7).trim());
        }
        client.setUserInterface(new ConsoleInput(client, args));
    }

    public void setUserInterface(UserInterface userInterface) {
        this.userInterface = userInterface;
    }

    public void setApi(Api api) {
        this.api = api != null ? api : Api.ModeShape;
    }

    public void setJaasContextName(String jaasContextName) {
        this.jaasContextName = jaasContextName;
    }

    public void startRepositories() throws IOException, SAXException {
        if (this.engine != null) {
            return;
        }
        JcrConfiguration configuration = new JcrConfiguration();
        configuration.loadFrom(this.userInterface.getRepositoryConfiguration());
        this.engine = configuration.build();
        this.engine.start();
        if (this.engine.getProblems().hasProblems()) {
            for (Problem problem : this.engine.getProblems()) {
                System.err.println(problem.getMessageString());
            }
            throw new RuntimeException("Could not start due to problems");
        }
        String location = this.userInterface.getLocationOfRepositoryFiles();
        this.engine.getGraph("Cars").importXmlFrom(location + "/cars.xml").into("/");
        this.engine.getGraph("Aircraft").importXmlFrom(location + "/aircraft.xml").into("/");
    }

    public List<String> getNamesOfRepositories() {
        ArrayList names = new ArrayList(this.engine.getRepositoryNames());
        Collections.sort(names);
        return Collections.unmodifiableList(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException, LoginException {
        this.logout();
        if (this.engine == null) {
            return;
        }
        try {
            this.engine.shutdown();
            this.engine.awaitTermination(5L, TimeUnit.SECONDS);
        }
        finally {
            this.engine = null;
        }
    }

    protected LoginContext getLoginContext() throws LoginException {
        if (this.loginContext == null && this.jaasContextName != null) {
            this.loginContext = new LoginContext(this.jaasContextName, this.userInterface.getCallbackHandler());
            this.loginContext.login();
        }
        return this.loginContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws LoginException {
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            finally {
                this.loginContext = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNodeInfo(String sourceName, String pathToNode, Map<String, Object[]> properties, List<String> children) throws Throwable {
        LoginContext loginContext = this.getLoginContext();
        switch (this.api) {
            case JCR: {
                JcrRepository jcrRepository = this.engine.getRepository(sourceName);
                Session session = null;
                if (loginContext != null) {
                    JaasCredentials credentials = new JaasCredentials(loginContext);
                    session = jcrRepository.login((Credentials)credentials);
                } else {
                    session = jcrRepository.login();
                }
                try {
                    Node child;
                    Node root;
                    pathToNode = pathToNode.replaceAll("^/+", "");
                    Node node = root = session.getRootNode();
                    if (pathToNode.length() != 0) {
                        if (!pathToNode.endsWith("]")) {
                            pathToNode = pathToNode + "[1]";
                        }
                        Node node2 = node = pathToNode.equals("") ? root : root.getNode(pathToNode);
                    }
                    if (properties != null) {
                        PropertyIterator iter = node.getProperties();
                        while (iter.hasNext()) {
                            javax.jcr.Property property = iter.nextProperty();
                            Object[] values = null;
                            if (property.getDefinition().isMultiple()) {
                                Value[] jcrValues = property.getValues();
                                values = new String[jcrValues.length];
                                for (int i = 0; i < jcrValues.length; ++i) {
                                    values[i] = jcrValues[i].getString();
                                }
                            } else {
                                values = new Object[]{property.getValue().getString()};
                            }
                            properties.put(property.getName(), values);
                        }
                    }
                    if (children == null) break;
                    HashSet<String> sameNameSiblings = new HashSet<String>();
                    NodeIterator iter = node.getNodes();
                    while (iter.hasNext()) {
                        child = iter.nextNode();
                        if (child.getIndex() <= 1) continue;
                        sameNameSiblings.add(child.getName());
                    }
                    iter = node.getNodes();
                    while (iter.hasNext()) {
                        child = iter.nextNode();
                        String name = child.getName();
                        if (sameNameSiblings.contains(name)) {
                            name = name + "[" + child.getIndex() + "]";
                        }
                        children.add(name);
                    }
                    break;
                }
                catch (ItemNotFoundException e) {
                    boolean node = false;
                    return node;
                }
                catch (PathNotFoundException e) {
                    boolean node = false;
                    return node;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            case ModeShape: {
                try {
                    String name;
                    ExecutionContext context = this.engine.getExecutionContext();
                    if (loginContext != null) {
                        JaasSecurityContext security = new JaasSecurityContext(loginContext);
                        context = context.with((SecurityContext)security);
                    }
                    Graph graph = this.engine.getGraph(context, sourceName);
                    org.modeshape.graph.Node node = graph.getNodeAt(pathToNode);
                    if (properties != null) {
                        for (Property property : node.getProperties()) {
                            name = property.getName().getString(context.getNamespaceRegistry());
                            properties.put(name, property.getValuesAsArray());
                        }
                    }
                    if (children == null) break;
                    for (Location child : node.getChildren()) {
                        name = child.getPath().getLastSegment().getString(context.getNamespaceRegistry());
                        children.add(name);
                    }
                    break;
                }
                catch (org.modeshape.graph.property.PathNotFoundException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public String buildPath(String current, String input) {
        if (current == null) {
            current = "/";
        }
        if (input == null || input.length() == 0) {
            return current;
        }
        ExecutionContext context = this.engine.getExecutionContext();
        PathFactory factory = context.getValueFactories().getPathFactory();
        Path inputPath = (Path)factory.create(input);
        if (inputPath.isAbsolute()) {
            return inputPath.getNormalizedPath().getString(context.getNamespaceRegistry(), (TextEncoder)NoOpEncoder.getInstance());
        }
        Path currentPath = (Path)factory.create(current);
        currentPath = factory.create(currentPath, inputPath);
        currentPath = currentPath.getNormalizedPath();
        return currentPath.getString(context.getNamespaceRegistry(), (TextEncoder)NoOpEncoder.getInstance());
    }

    @Immutable
    protected static class JaasCredentials
    implements Credentials {
        private static final long serialVersionUID = 1L;
        private final LoginContext context;

        public JaasCredentials(LoginContext context) {
            CheckArg.isNotNull((Object)context, (String)"context");
            this.context = context;
        }

        public LoginContext getLoginContext() {
            return this.context;
        }
    }

    public static enum Api {
        JCR,
        ModeShape;

    }
}

