/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.junit.After;
import org.modeshape.connector.meta.jdbc.JdbcMetadataSource;
import org.modeshape.connector.meta.jdbc.TestEnvironment;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.ReadableConnectorTest;

public class JdbcMetadataConnectorTest
extends ReadableConnectorTest {
    private JdbcMetadataSource source;

    protected RepositorySource setUpSource() throws Exception {
        this.source = TestEnvironment.configureJdbcMetadataSource("Test Repository", (Object)this);
        return this.source;
    }

    protected void initializeContent(Graph graph) throws Exception {
        TestEnvironment.executeDdl(this.source.getDataSource(), "create.ddl", (Object)this);
        graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
    }

    @After
    public void afterEach() throws Exception {
        TestEnvironment.executeDdl(this.source.getDataSource(), "drop.ddl", (Object)this);
        this.source.close();
    }

    public void shouldReturnSameStructureForRepeatedReadBranchRequests() {
        Properties properties = TestEnvironment.propertiesFor((Object)this);
        List<String> hugeDbs = Arrays.asList("postgresql8", "oracle10g", "oracle11g", "db2v9", "mssql2008", "sybase15");
        if (hugeDbs.contains(properties.getProperty("database"))) {
            return;
        }
        super.shouldReturnSameStructureForRepeatedReadBranchRequests();
    }
}

