/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.MockRepositoryContext;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;

public class SvnIntegrationTest {
    private static boolean SVN_SERVER_IS_WRITABLE = false;
    private ExecutionContext context;
    private SvnRepositorySource source;
    private String repositoryUrl;
    private String[] predefinedWorkspaceNames;

    @Before
    public void beforeEach() {
        this.repositoryUrl = "http://anonsvn.jboss.org/repos/modeshape/";
        this.predefinedWorkspaceNames = new String[]{"trunk", "tags", "branches"};
        this.context = new ExecutionContext();
        this.source = new SvnRepositorySource();
        this.source.setName("svn repository source");
        this.source.setRepositoryRootUrl(this.repositoryUrl);
        this.source.setCreatingWorkspacesAllowed(true);
        this.source.setPredefinedWorkspaceNames(this.predefinedWorkspaceNames);
        this.source.setDefaultWorkspaceName(this.predefinedWorkspaceNames[0]);
        this.source.setCreatingWorkspacesAllowed(false);
        if (SVN_SERVER_IS_WRITABLE) {
            this.source.setUpdatesAllowed(true);
            this.source.setUsername("harry");
            this.source.setPassword("harryssecret");
        } else {
            this.source.setUsername("anonymous");
            this.source.setPassword("");
        }
        this.source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
    }

    @Test
    public void shouldConnectAndReadRootNode() {
        if (SVN_SERVER_IS_WRITABLE) {
            return;
        }
        Graph graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        Map properties = (Map)graph.getPropertiesByName().on("/");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node root = graph.getNodeAt("/");
        Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)root.getLocation(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)root.getChildren().isEmpty(), (Matcher)Is.is((Object)false));
        for (Location childLocation : root.getChildren()) {
            Assert.assertThat((Object)childLocation.getPath().getParent().isRoot(), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldConnectAndWriteTwoNodesDeep() {
        if (!SVN_SERVER_IS_WRITABLE) {
            return;
        }
        Graph graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        Map properties = (Map)graph.getPropertiesByName().on("/");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Graph.Batch batch = graph.batch();
        batch.create("/testFolder").and();
        batch.create("/testFolder/childFolder").and();
        batch.create("/testFolder/foo.text").with("jcr:primaryType", new Object[]{"nt:file"}).and();
        batch.create("/testFolder/foo.text/jcr:content").with("jcr:primaryType", new Object[]{"nt:resource"}).with("jcr:data", new Object[]{"foo"}).and();
        batch.execute();
        graph.getNodeAt("/testFolder/childFolder");
    }
}

