/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Property;
import org.modeshape.sequencer.teiid.XmiGraphReader;

public class XmiGraphReaderTest {
    private Graph graph;
    private ExecutionContext context;
    private XmiGraphReader reader;
    private Subgraph subgraph;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("Source");
        this.graph = Graph.create((RepositorySource)source, (ExecutionContext)this.context);
        this.subgraph = (Subgraph)this.graph.getSubgraphOfDepth(1).at("/");
        this.reader = new XmiGraphReader(this.subgraph, true);
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        registry.register("ecore", "http://www.eclipse.org/emf/2002/Ecore");
        registry.register("xsd", "http://www.eclipse.org/xsd/2002/XSD");
    }

    @Test
    public void shouldConvertNamesToProperForm() {
        this.assertNameConversion("ecore:DataType", "ecore:dataType");
        this.assertNameConversion("ecore:Data_Type", "ecore:dataType");
        this.assertNameConversion("ecore:Data-Type", "ecore:dataType");
        this.assertNameConversion("ecore:Data.Type", "ecore:dataType");
    }

    @Test
    public void shouldFindNameWithUrlReference() {
        this.assertNameConversion("ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString", "ecore:eString");
        this.assertNameConversion("http://www.eclipse.org/emf/2002/Ecore#//EString", "ecore:eString");
        this.assertNameConversion("#//XSDProcessContents", "xsdProcessContents");
        this.assertNameConversion("http://www.eclipse.org/xsd/2002/XSD#//XSDProcessContents", "xsd:processContents");
    }

    @Test
    public void shouldDetermineJcrPropertyTypeForTypeReference() {
        this.assertTypeConversion("ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString", "STRING");
        this.assertTypeConversion("http://www.eclipse.org/emf/2002/Ecore#//EString", "STRING");
        this.assertTypeConversion("ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EBoolean", "BOOLEAN");
    }

    @Test
    public void shouldDiscoverNoLocalReferencesInSingleValuedPropertyWithNonUuidValues() {
        Assert.assertThat((Object)this.reader.references(this.property("p1", "string value")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.reader.references(this.property("p1", "64a77783-684b-1edf-ad26-eaf131c5fef9")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.reader.references(this.property("p1", "mmuuid/64a77783")), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldDiscoverLocalReferencesInSingleValuedPropertyWithOneReference() {
        Property property = this.property("p1", "mmuuid/64a77783-684b-1edf-ad26-eaf131c5fef9");
        List uuids = this.reader.references(property);
        Assert.assertThat((Object)uuids.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(uuids.get(0), (Matcher)Is.is((Object)UUID.fromString("64a77783-684b-1edf-ad26-eaf131c5fef9")));
    }

    @Test
    public void shouldDiscoverLocalReferencesInSingleValuedPropertyWithTwoReferences() {
        Property property = this.property("p1", "mmuuid/64a77783-684b-1edf-ad26-eaf131c5fef9 mmuuid/87ffedc0-684b-1edf-ad26-eaf131c5fef9");
        List uuids = this.reader.references(property);
        Assert.assertThat((Object)uuids.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(uuids.get(0), (Matcher)Is.is((Object)UUID.fromString("64a77783-684b-1edf-ad26-eaf131c5fef9")));
        Assert.assertThat(uuids.get(1), (Matcher)Is.is((Object)UUID.fromString("87ffedc0-684b-1edf-ad26-eaf131c5fef9")));
    }

    @Test
    public void shouldDiscoverLocalReferencesInSingleValuedPropertyWithThreeReferences() {
        Property property = this.property("p1", "mmuuid/64a77783-684b-1edf-ad26-eaf131c5fef9 mmuuid/87ffedc0-684b-1edf-ad26-eaf131c5fef9 mmuuid/7b018340-684b-1edf-ad26-eaf131c5fef9");
        List uuids = this.reader.references(property);
        Assert.assertThat((Object)uuids.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat(uuids.get(0), (Matcher)Is.is((Object)UUID.fromString("64a77783-684b-1edf-ad26-eaf131c5fef9")));
        Assert.assertThat(uuids.get(1), (Matcher)Is.is((Object)UUID.fromString("87ffedc0-684b-1edf-ad26-eaf131c5fef9")));
        Assert.assertThat(uuids.get(2), (Matcher)Is.is((Object)UUID.fromString("7b018340-684b-1edf-ad26-eaf131c5fef9")));
    }

    @Test
    public void shouldDiscoverLocalReferencesInMultiValuedPropertyWithOneReferenceInEachValue() {
        Property property = this.property("p1", "mmuuid/64a77783-684b-1edf-ad26-eaf131c5fef9", "mmuuid/87ffedc0-684b-1edf-ad26-eaf131c5fef9");
        List uuids = this.reader.references(property);
        Assert.assertThat((Object)uuids.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(uuids.get(0), (Matcher)Is.is((Object)UUID.fromString("64a77783-684b-1edf-ad26-eaf131c5fef9")));
        Assert.assertThat(uuids.get(1), (Matcher)Is.is((Object)UUID.fromString("87ffedc0-684b-1edf-ad26-eaf131c5fef9")));
    }

    @Test
    public void shouldDiscoverLocalReferencesInMultiValuedPropertyWithVariousReferencesInEachValue() {
        Property property = this.property("p1", "mmuuid/64a77783-684b-1edf-ad26-eaf131c5fef9", "mmuuid/87ffedc0-684b-1edf-ad26-eaf131c5fef9 mmuuid/7b018340-684b-1edf-ad26-eaf131c5fef9");
        List uuids = this.reader.references(property);
        Assert.assertThat((Object)uuids.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat(uuids.get(0), (Matcher)Is.is((Object)UUID.fromString("64a77783-684b-1edf-ad26-eaf131c5fef9")));
        Assert.assertThat(uuids.get(1), (Matcher)Is.is((Object)UUID.fromString("87ffedc0-684b-1edf-ad26-eaf131c5fef9")));
        Assert.assertThat(uuids.get(2), (Matcher)Is.is((Object)UUID.fromString("7b018340-684b-1edf-ad26-eaf131c5fef9")));
    }

    protected Property property(String name, Object ... values) {
        Name propName = (Name)this.context.getValueFactories().getNameFactory().create(name);
        return this.context.getPropertyFactory().create(propName, values);
    }

    protected Subgraph importFrom(String fileOrResourceName) {
        this.graph.importXmlFrom(fileOrResourceName);
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(20).at("/ecore:EPackage");
        return subgraph;
    }

    protected void assertNameConversion(String input, String output) {
        Name actual = this.reader.nameFrom(input);
        Name expected = (Name)this.context.getValueFactories().getNameFactory().create(output);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    protected void assertTypeConversion(String input, String expectedPropertyTypeName) {
        Name actual = this.reader.nameFrom(input);
        String actualTypeName = this.reader.jcrTypeNameFor(actual);
        Assert.assertThat((Object)actualTypeName, (Matcher)Is.is((Object)expectedPropertyTypeName));
    }
}

