/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.Base64;
import org.modeshape.common.util.FileUtil;
import org.modeshape.connector.disk.DiskSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.MockRepositoryContext;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.basic.FileSystemBinary;

public class DiskConnectorLargeValueTest {
    private final int LARGE_VALUE_THRESHOLD = 20;
    private final String REPO_ROOT_PATH = "./target/repoRootPath";
    private File repoRootPath;
    private File largeValuePath;
    protected ExecutionContext context;
    private BinaryFactory binFactory;
    private DiskSource source;
    private Graph graph;

    @Before
    public void beforeEach() {
        this.repoRootPath = new File("./target/repoRootPath");
        if (this.repoRootPath.exists()) {
            FileUtil.delete((File)this.repoRootPath);
        }
        this.repoRootPath.mkdirs();
        this.context = new ExecutionContext();
        this.binFactory = this.context.getValueFactories().getBinaryFactory();
        this.source = new DiskSource();
        this.source.setName("Disk Source");
        this.source.setLargeValueSizeInBytes(20L);
        this.source.setRepositoryRootPath("./target/repoRootPath");
        this.source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
        this.largeValuePath = new File(this.repoRootPath, this.source.getLargeValuePath());
        this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
    }

    private byte[] createBinaryValueOfSize(int size) {
        byte[] value = new byte[size];
        String seed = "The quick brown fox jumped over the lazy dog";
        int seedSize = seed.length();
        for (int i = 0; i < size; ++i) {
            value[i] = (byte)seed.charAt(i % seedSize);
        }
        return value;
    }

    private String keyFor(byte[] value) {
        try {
            return Base64.encodeBytes((byte[])value, (int)16);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Test
    public void shouldNotStoreBinaryAsLargeValueWhenSizeDoesNotExceedThreshold() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(19));
        this.graph.create("/noLargeValue").with("binaryProp", new Object[]{binary}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)0));
        Node node = this.graph.getNodeAt("/noLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertFalse((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldNotStoreBinaryAsLargeValueWhenSizeEqualsThreshold() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(20));
        this.graph.create("/noLargeValue").with("binaryProp", new Object[]{binary}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)0));
        Node node = this.graph.getNodeAt("/noLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertFalse((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldStoreBinaryAsLargeValueWhenSizeExceedsThreshold() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)2));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldReuseExistingIfPossibleLargeValueWhenSizeExceedsThreshold() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)2));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        this.graph.create("/secondLargeValue").with("binaryProp", new Object[]{binary}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)2));
        node = this.graph.getNodeAt("/secondLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldStoreSingleCopyOfMultipleValuesForSamePropertyAsLargeValuesWhenSizeExceedsThreshold() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/twoLargeValues").with("binaryProp", new Object[]{binary, binary}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)2));
        Node node = this.graph.getNodeAt("/twoLargeValues");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getValuesAsArray()[1] instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getValuesAsArray()[1] instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getValuesAsArray()[1]), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldStoreMultipleValuesForSamePropertyAsLargeValuesWhenSizeExceedsThreshold() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        Binary binary2 = (Binary)this.binFactory.create(this.createBinaryValueOfSize(30));
        this.graph.create("/twoLargeValues").with("binaryProp", new Object[]{binary, binary2}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)4));
        Node node = this.graph.getNodeAt("/twoLargeValues");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getValuesAsArray()[1] instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getValuesAsArray()[1] instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getValuesAsArray()[1]), (Matcher)CoreMatchers.is((Object)binary2));
    }

    @Test
    public void shouldStoreOnlyValuesThatExceedThresholdAsLargeValues() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        Binary binary2 = (Binary)this.binFactory.create(this.createBinaryValueOfSize(19));
        this.graph.create("/twoLargeValues").with("binaryProp", new Object[]{binary, binary2}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)2));
        Node node = this.graph.getNodeAt("/twoLargeValues");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getValuesAsArray()[1] instanceof Binary));
        Assert.assertFalse((boolean)(node.getProperty("binaryProp").getValuesAsArray()[1] instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getValuesAsArray()[1]), (Matcher)CoreMatchers.is((Object)binary2));
    }

    @Test
    public void shouldOnlyStoreLargeBinariesInLargeValueDirectory() {
        String largeStringValue = "Now is the time for all good men to come to the aid of their party";
        Assert.assertTrue((largeStringValue.length() > 20 ? 1 : 0) != 0);
        this.graph.create("/largeStringValue").with("stringProp", new Object[]{largeStringValue}).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)0));
        Node node = this.graph.getNodeAt("/largeStringValue");
        Assert.assertThat((Object)node.getProperty("stringProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)((String)node.getProperty("stringProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)largeStringValue));
    }

    @Test
    public void shouldRemoveLargeValueWhenNoLongerInUse() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        HashSet<String> largeValuePaths = new HashSet<String>();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        String hash = this.keyFor(binary.getHash());
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        ((Graph.Conjunction)this.graph.remove(new String[]{"binaryProp"}).on("/oneLargeValue")).and();
        Assert.assertThat((Object)this.largeValuePath.list().length, (Matcher)CoreMatchers.is((Object)0));
        node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotRemoveLargeValueWhenStillInUseInSameNode() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/twoLargeValues").with("binaryProp", new Object[]{binary, binary}).and();
        String hash = this.keyFor(binary.getHash());
        HashSet<String> largeValuePaths = new HashSet<String>();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        Node node = this.graph.getNodeAt("/twoLargeValues");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        ((Graph.Conjunction)((Graph.SetValuesTo)this.graph.set("binaryProp").on("/twoLargeValues")).to(binary)).and();
        largeValuePaths.clear();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        node = this.graph.getNodeAt("/twoLargeValues");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldNotRemoveLargeValueWhenStillInUseInOtherNode() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        this.graph.create("/otherLargeValue").with("binaryProp", new Object[]{binary}).and();
        String hash = this.keyFor(binary.getHash());
        HashSet<String> largeValuePaths = new HashSet<String>();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        node = this.graph.getNodeAt("/otherLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        this.graph.delete("/otherLargeValue").and();
        largeValuePaths.clear();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldRemoveLargeValueWhenSizeOfPropertyShrinks() {
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        String hash = this.keyFor(binary.getHash());
        HashSet<String> largeValuePaths = new HashSet<String>();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        Binary newBinary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(19));
        ((Graph.Conjunction)((Graph.SetValuesTo)this.graph.set("binaryProp").on("/oneLargeValue")).to(newBinary)).and();
        largeValuePaths.clear();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)0));
        node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertFalse((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)newBinary));
    }

    @Test
    public void shouldAllowNestedLargeValuesPath() {
        this.source = new DiskSource();
        this.source.setName("Disk Source");
        this.source.setLargeValueSizeInBytes(20L);
        this.source.setRepositoryRootPath("./target/repoRootPath");
        this.source.setLargeValuePath("large/values");
        this.source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
        this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        this.largeValuePath = new File(this.repoRootPath, this.source.getLargeValuePath());
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        String hash = this.keyFor(binary.getHash());
        HashSet<String> largeValuePaths = new HashSet<String>();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
    }

    @Test
    public void shouldAllowUsingLargeValuesInMultipleWorkspacesCreatedByCloning() {
        this.source = new DiskSource();
        this.source.setName("Disk Source");
        this.source.setLargeValueSizeInBytes(20L);
        this.source.setRepositoryRootPath("./target/repoRootPath");
        this.source.setLargeValuePath("large/values");
        this.source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
        this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        this.largeValuePath = new File(this.repoRootPath, this.source.getLargeValuePath());
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        String hash = this.keyFor(binary.getHash());
        HashSet<String> largeValuePaths = new HashSet<String>();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        String workspace = this.graph.getCurrentWorkspaceName();
        this.graph.createWorkspace().named("copyOf" + workspace);
        Assert.assertThat((Object)this.graph.getCurrentWorkspaceName(), (Matcher)CoreMatchers.is((Object)("copyOf" + workspace)));
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/oneLargeValue").fromWorkspace(workspace)).as("copyOfLargeValue")).into("/")).replacingExistingNodesWithSameUuids();
        List children = (List)this.graph.getChildren().of("/");
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)1));
        Node node2 = this.graph.getNodeAt("/copyOfLargeValue");
        Assert.assertThat((Object)node2.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node2.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node2.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node2.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node2.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        FileSystemBinary binary2 = (FileSystemBinary)node2.getProperty("binaryProp").getFirstValue();
        Assert.assertThat((Object)binary2.getHash(), (Matcher)CoreMatchers.is((Object)binary.getHash()));
    }

    @Test
    public void shouldSupportChangingBinaryValueAndRestarting() {
        this.source = new DiskSource();
        this.source.setName("Disk Source");
        this.source.setLargeValueSizeInBytes(20L);
        this.source.setRepositoryRootPath("./target/repoRootPath");
        this.source.setLargeValuePath("large/values");
        this.source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
        this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        this.largeValuePath = new File(this.repoRootPath, this.source.getLargeValuePath());
        Binary binary = (Binary)this.binFactory.create(this.createBinaryValueOfSize(21));
        this.graph.create("/oneLargeValue").with("binaryProp", new Object[]{binary}).and();
        String hash = this.keyFor(binary.getHash());
        HashSet<String> largeValuePaths = new HashSet<String>();
        largeValuePaths.addAll(Arrays.asList(this.largeValuePath.list()));
        Assert.assertThat((Object)largeValuePaths.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".dat"));
        Assert.assertTrue((boolean)largeValuePaths.contains(hash + ".ref"));
        Node node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary));
        Binary binary2 = (Binary)this.binFactory.create(this.createBinaryValueOfSize(22));
        ((Graph.Conjunction)((Graph.SetValuesTo)this.graph.set("binaryProp").on("/oneLargeValue")).to(binary2)).and();
        Node node2 = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node2.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node2.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node2.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node2.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node2.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary2));
        this.source.close();
        this.source = new DiskSource();
        this.source.setName("Disk Source");
        this.source.setLargeValueSizeInBytes(20L);
        this.source.setRepositoryRootPath("./target/repoRootPath");
        this.source.setLargeValuePath("large/values");
        this.source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
        this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        node = this.graph.getNodeAt("/oneLargeValue");
        Assert.assertThat((Object)node.getProperty("binaryProp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)node.getProperty("binaryProp").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof Binary));
        Assert.assertTrue((boolean)(node.getProperty("binaryProp").getFirstValue() instanceof FileSystemBinary));
        Assert.assertThat((Object)((Binary)node.getProperty("binaryProp").getFirstValue()), (Matcher)CoreMatchers.is((Object)binary2));
    }
}

