/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.connector.disk.DiskWorkspace;

public class DiskWorkspaceValueReferencesTest {
    @Ignore
    @Test
    public void shouldReadValueReferencesFromFile() throws Exception {
        File file = new File("HngcdK4ZJBscYnKeQKRezG1cX7Y=.ref");
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        DiskWorkspace.ValueReferences valueRefs = (DiskWorkspace.ValueReferences)ois.readObject();
        ois.close();
        System.out.println(valueRefs);
    }

    @Test
    public void shouldWriteAndReadValueReferencesFromFile() throws Exception {
        UUID uuid = UUID.randomUUID();
        DiskWorkspace.ValueReference valueRef = new DiskWorkspace.ValueReference("workspaceName", uuid);
        DiskWorkspace.ValueReferences valueRefs = new DiskWorkspace.ValueReferences(valueRef);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(valueRefs);
        oos.close();
        byte[] bytes = baos.toByteArray();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        DiskWorkspace.ValueReferences valueRefs2 = (DiskWorkspace.ValueReferences)ois.readObject();
        ois.close();
        Assert.assertThat((Object)valueRefs.withoutReference(valueRef).hasRemainingReferences(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)valueRefs2.withoutReference(valueRef).hasRemainingReferences(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)valueRefs, (Matcher)Is.is((Object)valueRefs2));
    }
}

