/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cnd;

import org.modeshape.cnd.CndI18n;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;

public class CndTokenizer
implements TokenStream.Tokenizer {
    public static final int WORD = 1;
    public static final int SYMBOL = 2;
    public static final int DECIMAL = 3;
    public static final int SINGLE_QUOTED_STRING = 4;
    public static final int DOUBLE_QUOTED_STRING = 5;
    public static final int COMMENT = 6;
    public static final int VENDOR_EXTENSION = 7;
    private final boolean useComments;
    private final boolean useVendorExtensions;

    public CndTokenizer(boolean useComments, boolean useVendorExtensions) {
        this.useComments = useComments;
        this.useVendorExtensions = useVendorExtensions;
    }

    public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
        block8: while (input.hasNext()) {
            char c = input.next();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case ']': {
                    tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                    break;
                }
                case '{': {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingBrace = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if (c == '\\' && input.isNext('}')) {
                            c = input.next();
                            continue;
                        }
                        if (c != '}') continue;
                        foundClosingBrace = true;
                        break;
                    }
                    if (!foundClosingBrace) {
                        String msg = CndI18n.vendorBlockWasNotClosed.text(new Object[]{startingPosition.getLine(), startingPosition.getColumn()});
                        throw new ParsingException(startingPosition, msg);
                    }
                    int endIndex = input.index() + 1;
                    if (!this.useVendorExtensions) continue block8;
                    tokens.addToken(startingPosition, startIndex, endIndex, 7);
                    break;
                }
                case '\"': {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingQuote = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if (c == '\\' && input.isNext('\"')) {
                            c = input.next();
                            continue;
                        }
                        if (c != '\"') continue;
                        foundClosingQuote = true;
                        break;
                    }
                    if (!foundClosingQuote) {
                        String msg = CommonI18n.noMatchingDoubleQuoteFound.text(new Object[]{startingPosition.getLine(), startingPosition.getColumn()});
                        throw new ParsingException(startingPosition, msg);
                    }
                    int endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 5);
                    break;
                }
                case '\'': {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingQuote = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if (c == '\\' && input.isNext('\'')) {
                            c = input.next();
                            continue;
                        }
                        if (c != '\'') continue;
                        foundClosingQuote = true;
                        break;
                    }
                    if (!foundClosingQuote) {
                        String msg = CommonI18n.noMatchingSingleQuoteFound.text(new Object[]{startingPosition.getLine(), startingPosition.getColumn()});
                        throw new ParsingException(startingPosition, msg);
                    }
                    int endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 4);
                    break;
                }
                case '/': {
                    int endIndex;
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    if (input.isNext('/')) {
                        boolean foundLineTerminator = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c != '\n' && c != '\r') continue;
                            foundLineTerminator = true;
                            break;
                        }
                        endIndex = input.index();
                        if (!foundLineTerminator) {
                            ++endIndex;
                        }
                        if (c == '\r' && input.isNext('\n')) {
                            input.next();
                        }
                        if (!this.useComments) continue block8;
                        tokens.addToken(startingPosition, startIndex, endIndex, 6);
                        break;
                    }
                    if (!input.isNext('*')) continue block8;
                    while (input.hasNext() && !input.isNext('*', '/')) {
                        c = input.next();
                    }
                    if (input.hasNext()) {
                        input.next();
                    }
                    if (input.hasNext()) {
                        input.next();
                    }
                    if (!this.useComments) continue block8;
                    endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 6);
                    break;
                }
                default: {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    while (input.hasNext() && !input.isNextWhitespace() && !input.isNextAnyOf("[]<>=-+(),\"'/{*|")) {
                        c = input.next();
                    }
                    int endIndex = input.index() + 1;
                    tokens.addToken(startingPosition, startIndex, endIndex, 1);
                }
            }
        }
    }
}

