/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.repository.sequencer.MockSequencerA;
import org.modeshape.repository.sequencer.MockSequencerB;
import org.modeshape.repository.sequencer.SequencerConfig;

public class SequencerConfigTest {
    private SequencerConfig configA;
    private SequencerConfig configB;
    private SequencerConfig configA2;
    private String validName;
    private String validDescription;
    private String validClassname;
    private String[] validPathExpressions;
    private String[] validMavenIds;

    @Before
    public void beforeEach() {
        this.validName = "valid configuration name";
        this.validDescription = "a sequencer";
        this.validClassname = MockSequencerA.class.getName();
        this.validPathExpressions = new String[]{"/a/b/c/d[e/@attribute] => ."};
        this.validMavenIds = new String[]{"com.acme:configA:1.0,com.acme:configB:1.0"};
        this.configA = new SequencerConfig("configA", this.validDescription, Collections.emptyMap(), MockSequencerA.class.getName(), this.validMavenIds, this.validPathExpressions);
        this.configB = new SequencerConfig("configB", this.validDescription, Collections.emptyMap(), MockSequencerB.class.getName(), this.validMavenIds, this.validPathExpressions);
        this.configA2 = new SequencerConfig("conFigA", this.validDescription, Collections.emptyMap(), MockSequencerA.class.getName(), this.validMavenIds, this.validPathExpressions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNameInConstructor() {
        new SequencerConfig(null, this.validDescription, Collections.emptyMap(), this.validClassname, this.validMavenIds, this.validPathExpressions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyNameInConstructor() {
        new SequencerConfig("", this.validDescription, Collections.emptyMap(), this.validClassname, this.validMavenIds, this.validPathExpressions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankNameInConstructor() {
        new SequencerConfig("   \t", this.validDescription, Collections.emptyMap(), this.validClassname, this.validMavenIds, this.validPathExpressions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullClassNameInConstructor() {
        new SequencerConfig(this.validName, this.validDescription, Collections.emptyMap(), null, this.validMavenIds, this.validPathExpressions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyClassNameInConstructor() {
        new SequencerConfig(this.validName, this.validDescription, Collections.emptyMap(), "", this.validMavenIds, this.validPathExpressions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankClassNameInConstructor() {
        new SequencerConfig(this.validName, this.validDescription, Collections.emptyMap(), "   \t", this.validMavenIds, this.validPathExpressions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowInvalidClassNameInConstructor() {
        new SequencerConfig(this.validName, this.validDescription, Collections.emptyMap(), "12.this is not a valid classname", this.validMavenIds, this.validPathExpressions);
    }

    @Test
    public void shouldConsiderSameIfNamesAreEqualIgnoringCase() {
        Assert.assertThat((Object)this.configA.equals((Object)this.configA2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderNotSameIfNamesAreNotEqualIgnoringCase() {
        Assert.assertThat((Object)this.configA.equals((Object)this.configB), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotAddNullOrBlankPathExpressions() {
        Assert.assertThat((Object)SequencerConfig.buildPathExpressionSet((String[])new String[]{null, "", "   ", this.validPathExpressions[0]}).size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldNotAddSamePathExpressionMoreThanOnce() {
        Assert.assertThat((Object)SequencerConfig.buildPathExpressionSet((String[])new String[]{this.validPathExpressions[0], this.validPathExpressions[0], this.validPathExpressions[0]}).size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldHaveNonNullPathExpressionCollectionWhenThereAreNoPathExpressions() {
        this.configA = new SequencerConfig("configA", this.validDescription, Collections.emptyMap(), this.validClassname, this.validMavenIds, new String[0]);
        Assert.assertThat((Object)this.configA.getPathExpressions().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSetClasspathWithValidMavenIds() {
        Assert.assertThat((Object)this.configA.getComponentClasspath().size(), (Matcher)Is.is((Object)this.validMavenIds.length));
        Assert.assertThat((Object)this.configA.getComponentClasspathArray(), (Matcher)Is.is((Object)this.validMavenIds));
    }

    @Test
    public void shouldGetNonNullSequencerClasspathWhenEmpty() {
        this.configA = new SequencerConfig("configA", this.validDescription, Collections.emptyMap(), this.validClassname, null, this.validPathExpressions);
        Assert.assertThat((Object)this.configA.getComponentClasspath().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.configA.getComponentClasspathArray().length, (Matcher)Is.is((Object)0));
    }
}

