/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.PathExpression;
import org.modeshape.repository.sequencer.InvalidSequencerPathExpression;
import org.modeshape.repository.sequencer.SequencerPathExpression;

public class SequencerPathExpressionTest {
    private SequencerPathExpression expr;

    @Before
    public void beforeEach() throws Exception {
        this.expr = new SequencerPathExpression(new PathExpression(".*"), "/output");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCompileNullExpression() {
        SequencerPathExpression.compile(null);
    }

    @Test(expected=InvalidSequencerPathExpression.class)
    public void shouldNotCompileZeroLengthExpression() {
        SequencerPathExpression.compile((String)"");
    }

    @Test(expected=InvalidSequencerPathExpression.class)
    public void shouldNotCompileBlankExpression() {
        SequencerPathExpression.compile((String)"    ");
    }

    @Test
    public void shouldCompileExpressionWithOnlySelectionExpression() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c");
        Assert.assertThat((Object)this.expr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.getOutputExpression(), (Matcher)Is.is((Object)"."));
    }

    @Test(expected=InvalidSequencerPathExpression.class)
    public void shouldNotCompileExpressionWithSelectionExpressionAndDelimiterAndNoOutputExpression() {
        SequencerPathExpression.compile((String)"/a/b/c=>");
    }

    @Test
    public void shouldCompileExpressionWithSelectionExpressionAndDelimiterAndOutputExpression() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c=>.");
        Assert.assertThat((Object)this.expr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.getOutputExpression(), (Matcher)Is.is((Object)"."));
        this.expr = SequencerPathExpression.compile((String)"/a/b/c=>/x/y");
        Assert.assertThat((Object)this.expr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.getOutputExpression(), (Matcher)Is.is((Object)"/x/y"));
    }

    @Test
    public void shouldCompileExpressionWithExtraWhitespace() {
        this.expr = SequencerPathExpression.compile((String)" /a/b/c => . ");
        Assert.assertThat((Object)this.expr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.getOutputExpression(), (Matcher)Is.is((Object)"."));
        this.expr = SequencerPathExpression.compile((String)"  /a/b/c => /x/y ");
        Assert.assertThat((Object)this.expr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)this.expr.getOutputExpression(), (Matcher)Is.is((Object)"/x/y"));
    }

    @Test
    public void shouldCompileExpressionWithIndexes() {
        Assert.assertThat((Object)SequencerPathExpression.compile((String)"/a/b[0]/c[1]/d/e"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)SequencerPathExpression.compile((String)"/a/b[0]/c[1]/d/e[2]"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    protected void assertNotMatches(SequencerPathExpression.Matcher matcher) {
        Assert.assertThat((Object)matcher, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)matcher.getSelectedPath(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)matcher.getOutputPath(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)matcher.matches(), (Matcher)Is.is((Object)false));
    }

    protected void assertMatches(SequencerPathExpression.Matcher matcher, String selectedPath, String outputPath) {
        this.assertMatches(matcher, selectedPath, null, null, outputPath);
    }

    protected void assertMatches(SequencerPathExpression.Matcher matcher, String selectedPath, String outputRepository, String outputWorkspace, String outputPath) {
        Assert.assertThat((Object)matcher, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)matcher.getSelectedPath(), (Matcher)Is.is((Object)selectedPath));
        Assert.assertThat((Object)matcher.getOutputPath(), (Matcher)Is.is((Object)outputPath));
        Assert.assertThat((Object)matcher.getOutputRepositoryName(), (Matcher)Is.is((Object)outputRepository));
        Assert.assertThat((Object)matcher.getOutputWorkspaceName(), (Matcher)Is.is((Object)outputWorkspace));
        if (selectedPath == null) {
            Assert.assertThat((Object)matcher.matches(), (Matcher)Is.is((Object)false));
        } else {
            Assert.assertThat((Object)matcher.matches(), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldMatchExpressionsWithoutRegardToCase() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c/d/e[@something] => .");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c/d/e", "/a/b/c/d/e");
        this.assertMatches(this.expr.matcher("/a/b/c/d/E/@something"), "/a/b/c/d/E", "/a/b/c/d/E");
    }

    @Test
    public void shouldMatchExpressionsWithExactFullPath() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c/d/e[@something] => .");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c/d/e", "/a/b/c/d/e");
        this.assertNotMatches(this.expr.matcher("/a/b/c/d/E/@something2"));
        this.assertNotMatches(this.expr.matcher("/a/b/c/d/ex/@something"));
        this.assertNotMatches(this.expr.matcher("/a/b[1]/c/d/e/@something"));
    }

    @Test
    public void shouldMatchExpressionsWithExactFullPathAndExtraPathInsideMatch() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c[d/e/@something] => .");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/a/b/c");
        this.assertNotMatches(this.expr.matcher("/a/b/c/d/E/@something2"));
        this.assertNotMatches(this.expr.matcher("/a/b/c/d/ex/@something"));
        this.assertNotMatches(this.expr.matcher("/a/b[1]/c/d/e/@something"));
    }

    @Test
    public void shouldMatchExpressionsWithWildcardSelection() {
        this.expr = SequencerPathExpression.compile((String)"/a/*/c[d/e/@something] => .");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/a/b/c");
        this.assertMatches(this.expr.matcher("/a/b[2]/c/d/e/@something"), "/a/b[2]/c", "/a/b[2]/c");
        this.assertMatches(this.expr.matcher("/a/rt/c/d/e/@something"), "/a/rt/c", "/a/rt/c");
        this.assertNotMatches(this.expr.matcher("/ac/d/e/@something"));
    }

    @Test
    public void shouldMatchExpressionsWithFilenameLikeWildcardSelection() {
        this.expr = SequencerPathExpression.compile((String)"/a/*.txt[@something] => .");
        this.assertMatches(this.expr.matcher("/a/b.txt/@something"), "/a/b.txt", "/a/b.txt");
        this.assertNotMatches(this.expr.matcher("/a/b.tx/@something"));
        this.expr = SequencerPathExpression.compile((String)"/a/*.txt/c[@something] => .");
        this.assertMatches(this.expr.matcher("/a/b.txt/c/@something"), "/a/b.txt/c", "/a/b.txt/c");
        this.assertNotMatches(this.expr.matcher("/a/b.tx/c/@something"));
        this.expr = SequencerPathExpression.compile((String)"//*.txt[*]/c[@something] => .");
        this.assertMatches(this.expr.matcher("/a/b.txt/c/@something"), "/a/b.txt/c", "/a/b.txt/c");
        this.assertNotMatches(this.expr.matcher("/a/b.tx/c/@something"));
    }

    @Test
    public void shouldMatchExpressionsWithSegmentWildcardSelection() {
        this.expr = SequencerPathExpression.compile((String)"/a//c[d/e/@something] => .");
        this.assertMatches(this.expr.matcher("/a/c/d/e/@something"), "/a/c", "/a/c");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/a/b/c");
        this.assertMatches(this.expr.matcher("/a/b[2]/c/d/e/@something"), "/a/b[2]/c", "/a/b[2]/c");
        this.assertMatches(this.expr.matcher("/a/rt/c/d/e/@something"), "/a/rt/c", "/a/rt/c");
        this.assertMatches(this.expr.matcher("/a/r/s/t/c/d/e/@something"), "/a/r/s/t/c", "/a/r/s/t/c");
        this.assertMatches(this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something"), "/a/r[1]/s[2]/t[33]/c", "/a/r[1]/s[2]/t[33]/c");
        this.assertNotMatches(this.expr.matcher("/a[3]/c/d/e/@something"));
    }

    @Test
    public void shouldMatchExpressionsWithIndexesInSelectionPaths() {
        this.expr = SequencerPathExpression.compile((String)"/a/b[2,3,4,5]/c/d/e[@something] => /x/y");
        this.assertMatches(this.expr.matcher("/a/b[2]/c/d/e/@something"), "/a/b[2]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[3]/c/d/e/@something"), "/a/b[3]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[4]/c/d/e/@something"), "/a/b[4]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[5]/c/d/e/@something"), "/a/b[5]/c/d/e", "/x/y");
        this.assertNotMatches(this.expr.matcher("/a/b[1]/c/d/e/@something"));
        this.assertNotMatches(this.expr.matcher("/a/b/c/d/e/@something"));
        this.assertNotMatches(this.expr.matcher("/a[1]/b/c/d/e/@something"));
        this.expr = SequencerPathExpression.compile((String)"/a/b[0,2,3,4,5]/c/d/e[@something] => /x/y");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[2]/c/d/e/@something"), "/a/b[2]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[3]/c/d/e/@something"), "/a/b[3]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[4]/c/d/e/@something"), "/a/b[4]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[5]/c/d/e/@something"), "/a/b[5]/c/d/e", "/x/y");
        this.assertNotMatches(this.expr.matcher("/a/b[1]/c/d/e/@something"));
        this.assertNotMatches(this.expr.matcher("/a[1]/b/c/d/e/@something"));
    }

    @Test
    public void shouldMatchExpressionsWithAnyIndexesInSelectionPaths() {
        this.expr = SequencerPathExpression.compile((String)"/a/b[*]/c[]/d/e[@something] => /x/y");
        this.assertMatches(this.expr.matcher("/a/b[2]/c/d/e/@something"), "/a/b[2]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[3]/c/d/e/@something"), "/a/b[3]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[4]/c/d/e/@something"), "/a/b[4]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[5]/c/d/e/@something"), "/a/b[5]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[1]/c/d/e/@something"), "/a/b[1]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[6]/c/d/e/@something"), "/a/b[6]/c/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b[6]/c[1]/d/e/@something"), "/a/b[6]/c[1]/d/e", "/x/y");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c/d/e", "/x/y");
    }

    @Test
    public void shouldMatchExpressionsWithFullOutputPath() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c[d/e/@something] => /x/y");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/x/y");
    }

    @Test
    public void shouldMatchExpressionsWithRepositoryInSelectionPath() {
        this.expr = SequencerPathExpression.compile((String)"reposA::/a/b/c[d/e/@something] => /x/y");
        this.assertMatches(this.expr.matcher("reposA::/a/b/c/d/e/@something"), "/a/b/c", "reposA", null, "/x/y");
    }

    @Test
    public void shouldMatchExpressionsWithRepositoryAndWorkspaceInSelectionPath() {
        this.expr = SequencerPathExpression.compile((String)"reposA::/a/b/c[d/e/@something] => /x/y");
        this.assertMatches(this.expr.matcher("reposA:wsA:/a/b/c/d/e/@something"), "/a/b/c", "reposA", "wsA", "/x/y");
    }

    @Test
    public void shouldMatchExpressionsWithRepositoryInFullOutputPath() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c[d/e/@something] => reposA::/x/y");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "reposA", null, "/x/y");
    }

    @Test
    public void shouldMatchExpressionsWithNamedGroupsInOutputPath() {
        this.expr = SequencerPathExpression.compile((String)"/a(//c)[d/e/@something] => $1/y/z");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/b/c/y/z");
        this.expr = SequencerPathExpression.compile((String)"/a(/(b|c|d|)/e)[f/g/@something] => $1/y/z");
        this.assertMatches(this.expr.matcher("/a/b/e/f/g/@something"), "/a/b/e", "/b/e/y/z");
        this.assertMatches(this.expr.matcher("/a/c/e/f/g/@something"), "/a/c/e", "/c/e/y/z");
        this.assertMatches(this.expr.matcher("/a/d/e/f/g/@something"), "/a/d/e", "/d/e/y/z");
        this.assertMatches(this.expr.matcher("/a/e/f/g/@something"), "/a/e", "/e/y/z");
        this.assertNotMatches(this.expr.matcher("/a/t/e/f/g/@something"));
        this.expr = SequencerPathExpression.compile((String)"/a/(b/c)[(d|e)/(f|g)/@something] => /u/$1/y/z/$2/$3");
        this.assertMatches(this.expr.matcher("/a/b/c/d/f/@something"), "/a/b/c", "/u/b/c/y/z/d/f");
        this.assertMatches(this.expr.matcher("/a/b/c/e/f/@something"), "/a/b/c", "/u/b/c/y/z/e/f");
        this.assertMatches(this.expr.matcher("/a/b/c/d/g/@something"), "/a/b/c", "/u/b/c/y/z/d/g");
        this.assertMatches(this.expr.matcher("/a/b/c/e/g/@something"), "/a/b/c", "/u/b/c/y/z/e/g");
        this.expr = SequencerPathExpression.compile((String)"/a/(b/c)/(d|e)/(f|g)/@something => /u/$1/y/z/$2/$3");
        this.assertMatches(this.expr.matcher("/a/b/c/d/f/@something"), "/a/b/c/d/f", "/u/b/c/y/z/d/f");
        this.assertMatches(this.expr.matcher("/a/b/c/e/f/@something"), "/a/b/c/e/f", "/u/b/c/y/z/e/f");
        this.assertMatches(this.expr.matcher("/a/b/c/d/g/@something"), "/a/b/c/d/g", "/u/b/c/y/z/d/g");
        this.assertMatches(this.expr.matcher("/a/b/c/e/g/@something"), "/a/b/c/e/g", "/u/b/c/y/z/e/g");
    }

    @Test
    public void shouldMatchExpressionWithReoccurringNamedGroupsDollarsInOutputPath() {
        this.expr = SequencerPathExpression.compile((String)"/a/(b/c)[(d|e)/(f|g)/@something] => /u/$1/y/z/$2/$3/$1/$1");
        this.assertMatches(this.expr.matcher("/a/b/c/d/f/@something"), "/a/b/c", "/u/b/c/y/z/d/f/b/c/b/c");
    }

    @Test
    public void shouldMatchExpressionWithNamedGroupsAndEscapedDollarsInOutputPath() {
        this.expr = SequencerPathExpression.compile((String)"/a/(b/c)[(d|e)/(f|g)/@something] => /\\$2u/$1/y/z/$2/$3");
        this.assertMatches(this.expr.matcher("/a/b/c/d/f/@something"), "/a/b/c", "/\\$2u/b/c/y/z/d/f");
    }

    @Test
    public void shouldMatchExpressionWithParentReferencesInOutputPath() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c[d/e/@something] => /x/y/z/../..");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/x");
        this.expr = SequencerPathExpression.compile((String)"/a/(b/c)[d/e/@something] => /x/$1/z/../../v");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/x/b/v");
    }

    @Test
    public void shouldMatchExpressionWithSelfReferencesInOutputPath() {
        this.expr = SequencerPathExpression.compile((String)"/a/b/c[d/e/@something] => /x/y/./z/.");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/x/y/z");
        this.expr = SequencerPathExpression.compile((String)"/a/(b/c)[d/e/@something] => /x/$1/./z");
        this.assertMatches(this.expr.matcher("/a/b/c/d/e/@something"), "/a/b/c", "/x/b/c/z");
    }

    @Test
    public void shouldMatchExpressionWithFilenamePatternAndChildProperty() {
        this.expr = SequencerPathExpression.compile((String)"//(*.(jpeg|gif|bmp|pcx|png|iff|ras|pbm|pgm|ppm|psd))[*]/jcr:content[@jcr:data]=>/images/$1");
        this.assertMatches(this.expr.matcher("/a/b/caution.png/jcr:content/@jcr:data"), "/a/b/caution.png/jcr:content", "/images/caution.png");
    }
}

