/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.graph.ExecutionContext;

public class ExecutionContextTest {
    private ExecutionContext context;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
    }

    @After
    public void afterEach() {
        this.context = null;
    }

    @Test
    public void shouldHaveIdentifierThatIsNotNull() {
        Assert.assertThat((Object)this.context.getId(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveIdentifierThatIsNotBlank() {
        Assert.assertThat((Object)this.context.getId().length(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)this.context.getId().trim().length(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
    }

    @Test
    public void shouldHaveIdentifierThatIsUnique() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i != 50; ++i) {
            Assert.assertThat((Object)ids.add(new ExecutionContext().getId()), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldCreateSubcontextsWithDifferentIdentifiers() {
        ExecutionContext newContext = this.context.with((ClassLoaderFactory)Mockito.mock(ClassLoaderFactory.class));
        Assert.assertThat((Object)newContext.getId(), (Matcher)Is.is((Matcher)IsNot.not((Object)this.context.getId())));
    }
}

