/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Results;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.ChangeObserver;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.graph.query.process.QueryResultColumns;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphTest {
    private Graph graph;
    private Results results;
    private ExecutionContext context;
    private Path validPath;
    private String validPathString;
    private Name validName;
    private String validNameString;
    private UUID validUuid;
    private Property validIdProperty1;
    private Property validIdProperty2;
    private Location validLocation;
    private String sourceName;
    private MockRepositoryConnection connection;
    private LinkedList<Request> executedRequests;
    private QueryResults.Columns nextColumns;
    private List<Object[]> nextTuples;
    private QueryResults.Statistics nextStatistics;
    private int numberOfExecutions;
    private Map<Location, Collection<Property>> properties;
    private Map<Location, List<Location>> children;
    @Mock
    private RepositoryConnectionFactory connectionFactory;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.executedRequests = new LinkedList();
        this.sourceName = "Source";
        this.context = new ExecutionContext();
        this.connection = new MockRepositoryConnection();
        Mockito.when((Object)this.connectionFactory.createConnection(this.sourceName)).thenReturn((Object)this.connection);
        this.graph = new Graph(this.sourceName, this.connectionFactory, this.context);
        this.validPathString = "/a/b/c";
        this.validUuid = UUID.randomUUID();
        this.validPath = this.createPath(this.validPathString);
        this.validNameString = "theName";
        this.validName = this.createName(this.validNameString);
        Name idProperty1Name = this.createName("id1");
        Name idProperty2Name = this.createName("id2");
        this.validIdProperty1 = this.context.getPropertyFactory().create(idProperty1Name, new Object[]{"1"});
        this.validIdProperty2 = this.context.getPropertyFactory().create(idProperty2Name, new Object[]{"2"});
        this.validLocation = Location.create((Path)this.validPath);
        this.properties = new HashMap<Location, Collection<Property>>();
        this.children = new HashMap<Location, List<Location>>();
        this.nextColumns = null;
        this.nextTuples = null;
        this.nextStatistics = null;
    }

    protected static Request anyRequest() {
        return (Request)Matchers.argThat((Matcher)new IsAnyRequest());
    }

    protected Path createPath(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Path createPath(Path parent, String path) {
        return this.context.getValueFactories().getPathFactory().create(parent, path);
    }

    protected Name createName(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Property createProperty(String name, Object ... values) {
        return this.context.getPropertyFactory().create(this.createName(name), values);
    }

    protected void setPropertiesToReadOn(Location location, Property ... properties) {
        this.properties.put(location, Arrays.asList(properties));
    }

    protected void setChildrenToReadOn(Location location, Location ... children) {
        this.children.put(location, Arrays.asList(children));
    }

    protected void assertNextRequestIsMove(Location from, Location to) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(MoveBranchRequest.class)));
        MoveBranchRequest move = (MoveBranchRequest)request;
        Assert.assertThat((Object)move.from(), (Matcher)Is.is((Object)from));
        Assert.assertThat((Object)move.into(), (Matcher)Is.is((Object)to));
    }

    protected void assertNextRequestIsCopy(Location from, Location to) {
        this.assertNextRequestIsCopy(this.graph.getCurrentWorkspaceName(), from, to);
    }

    protected void assertNextRequestIsCopy(String fromWorkspace, Location from, Location to) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CopyBranchRequest.class)));
        CopyBranchRequest copy = (CopyBranchRequest)request;
        Assert.assertThat((Object)copy.fromWorkspace(), (Matcher)Is.is((Object)fromWorkspace));
        Assert.assertThat((Object)copy.from(), (Matcher)Is.is((Object)from));
        Assert.assertThat((Object)copy.into(), (Matcher)Is.is((Object)to));
    }

    protected void assertNextRequestIsDelete(Location at) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DeleteBranchRequest.class)));
        DeleteBranchRequest delete = (DeleteBranchRequest)request;
        Assert.assertThat((Object)delete.at(), (Matcher)Is.is((Object)at));
    }

    protected void assertNextRequestIsLock(Location at, LockBranchRequest.LockScope lockScope, long lockTimeout) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(LockBranchRequest.class)));
        LockBranchRequest lock = (LockBranchRequest)request;
        Assert.assertThat((Object)lock.at(), (Matcher)Is.is((Object)at));
        Assert.assertThat((Object)lock.lockScope(), (Matcher)Is.is((Object)lockScope));
        Assert.assertThat((Object)lock.lockTimeoutInMillis(), (Matcher)Is.is((Object)lockTimeout));
    }

    protected void assertNextRequestIsUnlock(Location at) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(UnlockBranchRequest.class)));
        UnlockBranchRequest unlock = (UnlockBranchRequest)request;
        Assert.assertThat((Object)unlock.at(), (Matcher)Is.is((Object)at));
    }

    protected void assertNextRequestIsCreate(Location parent, String child, Property ... properties) {
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(child);
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CreateNodeRequest.class)));
        CreateNodeRequest create = (CreateNodeRequest)request;
        Assert.assertThat((Object)create.under(), (Matcher)Is.is((Object)parent));
        Assert.assertThat((Object)create.named(), (Matcher)Is.is((Object)name));
        Assert.assertThat((Object)create.properties(), (Matcher)JUnitMatchers.hasItems((Object[])properties));
    }

    protected void assertNextRequestReadProperties(Location at, Property ... properties) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ReadAllPropertiesRequest.class)));
        ReadAllPropertiesRequest readAll = (ReadAllPropertiesRequest)request;
        Assert.assertThat((Object)readAll.at(), (Matcher)Is.is((Object)at));
        HashMap propsByName = new HashMap(readAll.getPropertiesByName());
        for (Property prop : properties) {
            Assert.assertThat(propsByName.remove(prop.getName()), (Matcher)Is.is((Object)prop));
        }
        Assert.assertThat((Object)propsByName.isEmpty(), (Matcher)Is.is((Object)true));
    }

    protected void assertNextRequestReadProperty(Location at, Property property) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ReadPropertyRequest.class)));
        ReadPropertyRequest read = (ReadPropertyRequest)request;
        Assert.assertThat((Object)read.on(), (Matcher)Is.is((Object)at));
        Assert.assertThat((Object)read.getProperty(), (Matcher)Is.is((Object)property));
    }

    protected void assertNextRequestReadChildren(Location at, Location ... children) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ReadAllChildrenRequest.class)));
        ReadAllChildrenRequest readAll = (ReadAllChildrenRequest)request;
        Assert.assertThat((Object)readAll.of(), (Matcher)Is.is((Object)at));
        Assert.assertThat((Object)readAll.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])children));
    }

    protected void assertNextRequestReadBlockOfChildren(Location at, int startIndex, int maxCount, Location ... children) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ReadBlockOfChildrenRequest.class)));
        ReadBlockOfChildrenRequest read = (ReadBlockOfChildrenRequest)request;
        Assert.assertThat((Object)read.of(), (Matcher)Is.is((Object)at));
        Assert.assertThat((Object)read.startingAtIndex(), (Matcher)Is.is((Object)startIndex));
        Assert.assertThat((Object)read.endingBefore(), (Matcher)Is.is((Object)(startIndex + maxCount)));
        Assert.assertThat((Object)read.count(), (Matcher)Is.is((Object)maxCount));
        Assert.assertThat((Object)read.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])children));
    }

    protected void assertNextRequestReadNextBlockOfChildren(Location previousSibling, int maxCount, Location ... children) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ReadNextBlockOfChildrenRequest.class)));
        ReadNextBlockOfChildrenRequest read = (ReadNextBlockOfChildrenRequest)request;
        Assert.assertThat((Object)read.startingAfter(), (Matcher)Is.is((Object)previousSibling));
        Assert.assertThat((Object)read.count(), (Matcher)Is.is((Object)maxCount));
        Assert.assertThat((Object)read.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])children));
    }

    protected void assertNextRequestReadNode(Location at) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ReadNodeRequest.class)));
        ReadNodeRequest read = (ReadNodeRequest)request;
        Assert.assertThat((Object)read.at(), (Matcher)Is.is((Object)at));
    }

    protected void assertNextRequestVerifyNodeExists(Location at) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(VerifyNodeExistsRequest.class)));
        VerifyNodeExistsRequest read = (VerifyNodeExistsRequest)request;
        Assert.assertThat((Object)read.at(), (Matcher)Is.is((Object)at));
    }

    protected void assertNextRequestIsGetWorkspaces() {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(GetWorkspacesRequest.class)));
    }

    protected void assertNextRequestIsCreateWorkspace(String workspaceName, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CreateWorkspaceRequest.class)));
        CreateWorkspaceRequest create = (CreateWorkspaceRequest)request;
        Assert.assertThat((Object)create.desiredNameOfNewWorkspace(), (Matcher)Is.is((Object)workspaceName));
        Assert.assertThat((Object)create.conflictBehavior(), (Matcher)Is.is((Object)createConflictBehavior));
    }

    protected void assertNextRequestIsCloneWorkspace(String originalWorkspaceName, String workspaceName, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior, CloneWorkspaceRequest.CloneConflictBehavior cloneBehavior) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CloneWorkspaceRequest.class)));
        CloneWorkspaceRequest create = (CloneWorkspaceRequest)request;
        Assert.assertThat((Object)create.nameOfWorkspaceToBeCloned(), (Matcher)Is.is((Object)originalWorkspaceName));
        Assert.assertThat((Object)create.desiredNameOfTargetWorkspace(), (Matcher)Is.is((Object)workspaceName));
        Assert.assertThat((Object)create.targetConflictBehavior(), (Matcher)Is.is((Object)createConflictBehavior));
        Assert.assertThat((Object)create.cloneConflictBehavior(), (Matcher)Is.is((Object)cloneBehavior));
    }

    protected void assertNoMoreRequests() {
        Assert.assertThat((Object)this.executedRequests.isEmpty(), (Matcher)Is.is((Object)true));
        this.numberOfExecutions = 0;
    }

    protected void extractRequestsFromComposite() {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CompositeRequest.class)));
        this.executedRequests.addAll(0, ((CompositeRequest)request).getRequests());
    }

    protected void assertNextRequestUpdateProperties(Location on, Property ... properties) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(UpdatePropertiesRequest.class)));
        UpdatePropertiesRequest read = (UpdatePropertiesRequest)request;
        Assert.assertThat((Object)read.on(), (Matcher)Is.is((Object)on));
        Assert.assertThat(read.properties().values(), (Matcher)JUnitMatchers.hasItems((Object[])properties));
    }

    protected void assertNextRequestSetProperty(Location on, Property property) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SetPropertyRequest.class)));
        SetPropertyRequest read = (SetPropertyRequest)request;
        Assert.assertThat((Object)read.on(), (Matcher)Is.is((Object)on));
        Assert.assertThat((Object)read.property(), (Matcher)Is.is((Object)property));
    }

    protected void assertNextRequestAccessQuery(String workspaceName, String tableName, QueryResults.Columns columns, Limit limit, Constraint ... andedConstraints) {
        Request request = this.executedRequests.poll();
        Assert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(AccessQueryRequest.class)));
        AccessQueryRequest access = (AccessQueryRequest)request;
        Assert.assertThat((Object)access.workspace(), (Matcher)Is.is((Object)workspaceName));
        Assert.assertThat((Object)access.selectorName().name(), (Matcher)Is.is((Object)tableName));
        Assert.assertThat((Object)access.resultColumns(), (Matcher)Is.is((Object)columns));
        Assert.assertThat((Object)access.limit(), (Matcher)Is.is((Object)limit));
        Assert.assertThat((Object)access.andedConstraints(), (Matcher)Is.is(Arrays.asList(andedConstraints)));
    }

    @Test
    public void shouldMoveNode() {
        this.graph.move(this.validPath).into(this.validIdProperty1, new Property[]{this.validIdProperty2});
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        this.graph.move(this.validPathString).into(this.validIdProperty1, new Property[]{this.validIdProperty2});
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        this.graph.move(this.validUuid).into(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsMove(Location.create((UUID)this.validUuid), Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCopyNode() {
        this.graph.copy(this.validPath).into(this.validIdProperty1, new Property[]{this.validIdProperty2});
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        this.graph.copy(this.validPathString).into(this.validIdProperty1, new Property[]{this.validIdProperty2});
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        this.graph.copy(this.validUuid).into(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((UUID)this.validUuid), Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCopyNodeFromOtherWorkspace() {
        ((Graph.CopyTarget)this.graph.copy(this.validPath).fromWorkspace("other")).into(this.validIdProperty1, new Property[]{this.validIdProperty2});
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy("other", Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        this.graph.copy(this.validPathString).into(this.validIdProperty1, new Property[]{this.validIdProperty2});
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        this.graph.copy(this.validUuid).into(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((UUID)this.validUuid), Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldDeleteNode() {
        this.graph.delete(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsDelete(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
        this.graph.delete(this.validPathString);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsDelete(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
        this.graph.delete(this.validUuid);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsDelete(Location.create((UUID)this.validUuid));
        this.assertNoMoreRequests();
        this.graph.delete(this.validIdProperty1);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsDelete(Location.create((Property)this.validIdProperty1));
        this.assertNoMoreRequests();
        this.graph.delete(this.validIdProperty1, new Property[]{this.validIdProperty2});
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsDelete(Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCreateNode() {
        this.graph.create(this.validPath).and();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", new Property[0]);
        this.assertNoMoreRequests();
        this.graph.create(this.validPath, this.validIdProperty1).and();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1);
        this.assertNoMoreRequests();
        this.graph.create(this.validPath, this.validIdProperty1, new Property[]{this.validIdProperty2}).and();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1, this.validIdProperty2);
        this.assertNoMoreRequests();
        this.graph.create(this.validPathString).and();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", new Property[0]);
        this.assertNoMoreRequests();
        this.graph.create(this.validPathString, this.validIdProperty1).and();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1);
        this.assertNoMoreRequests();
        this.graph.create(this.validPathString, this.validIdProperty1, new Property[]{this.validIdProperty2}).and();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1, this.validIdProperty2);
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCreateNodeAndReturnGraph() {
        ((Graph)this.graph.create(this.validPath).and()).getNodeAt(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)2));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", new Property[0]);
        this.assertNextRequestReadNode(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCreateNodeAtPathWithPropertiesAndReturnLocation() {
        Location actual = this.graph.createAt(this.validPath).with(this.validIdProperty1).getLocation();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1);
        this.assertNoMoreRequests();
        actual = this.graph.createAt(this.validPath).with(this.validIdProperty1).and(this.validIdProperty2).getLocation();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1, this.validIdProperty2);
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCreateNodeAtPathWithPropertiesAndReturnNode() {
        Node node = this.graph.createAt(this.validPath).with(this.validIdProperty1).getNode();
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)2));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1);
        this.assertNextRequestReadNode(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
        node = this.graph.createAt(this.validPath).with(this.validIdProperty1).and(this.validIdProperty2).getNode();
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)2));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1, this.validIdProperty2);
        this.assertNextRequestReadNode(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCreateNodeAtPathWithPropertiesAndReturnGraph() {
        ((Graph)this.graph.createAt(this.validPath).with(this.validIdProperty1).and()).getNodeAt(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)2));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1);
        this.assertNextRequestReadNode(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
        ((Graph)this.graph.createAt(this.validPath).with(this.validIdProperty1).and(this.validIdProperty2).and()).getNodeAt(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)2));
        this.assertNextRequestIsCreate(Location.create((Path)this.validPath.getParent()), "c", this.validIdProperty1, this.validIdProperty2);
        this.assertNextRequestReadNode(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCreateNodesWithBatch() {
        ((Graph.BatchConjunction)((Graph.Batch)this.graph.batch().create(this.validPath, this.validIdProperty1).and()).remove(new String[]{"prop"}).on(this.validPathString)).execute();
        ((Graph.Batch)((Graph.Batch)((Graph.BatchConjunction)((Graph.Move)this.graph.batch().move(this.validPath).and(this.validPath)).into(this.validPathString)).and()).create(this.validPath).and()).execute();
        ((Graph.Batch)this.graph.batch().createUnder(this.validLocation).nodeNamed("someName").and()).delete(this.validLocation).execute();
    }

    @Test
    public void shouldGetPropertiesOnNode() {
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        Collection props = (Collection)this.graph.getProperties().on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperties(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)props, (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1, this.validIdProperty2}));
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), new Property[0]);
        props = (Collection)this.graph.getProperties().on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperties(Location.create((Path)this.validPath), new Property[0]);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldGetPropertiesByNameOnNode() {
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        Map propsByName = (Map)this.graph.getPropertiesByName().on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperties(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        this.assertNoMoreRequests();
        Assert.assertThat(propsByName.get(this.validIdProperty1.getName()), (Matcher)Is.is((Object)this.validIdProperty1));
        Assert.assertThat(propsByName.get(this.validIdProperty2.getName()), (Matcher)Is.is((Object)this.validIdProperty2));
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), new Property[0]);
        propsByName = (Map)this.graph.getPropertiesByName().on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperties(Location.create((Path)this.validPath), new Property[0]);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)propsByName.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetPropertyOnNode() {
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        this.graph.getProperty(this.validIdProperty2.getName()).on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperty(Location.create((Path)this.validPath), this.validIdProperty2);
        this.assertNoMoreRequests();
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        this.graph.getProperty(this.validIdProperty2.getName().getString(this.context.getNamespaceRegistry())).on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperty(Location.create((Path)this.validPath), this.validIdProperty2);
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldGetChildrenOnNode() {
        Location child1 = Location.create((Path)this.createPath(this.validPath, "x"));
        Location child2 = Location.create((Path)this.createPath(this.validPath, "y"));
        Location child3 = Location.create((Path)this.createPath(this.validPath, "z"));
        this.setChildrenToReadOn(Location.create((Path)this.validPath), child1, child2, child3);
        List children = (List)this.graph.getChildren().of(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadChildren(Location.create((Path)this.validPath), child1, child2, child3);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2, child3}));
        this.setChildrenToReadOn(Location.create((Path)this.validPath), new Location[0]);
        children = (List)this.graph.getChildren().of(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadChildren(Location.create((Path)this.validPath), new Location[0]);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldGetChildrenInBlockAtStartingIndex() {
        Location child1 = Location.create((Path)this.createPath(this.validPath, "x"));
        Location child2 = Location.create((Path)this.createPath(this.validPath, "y"));
        Location child3 = Location.create((Path)this.createPath(this.validPath, "z"));
        this.setChildrenToReadOn(Location.create((Path)this.validPath), child1, child2, child3);
        List children = (List)this.graph.getChildren().inBlockOf(2).startingAt(0).under(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadBlockOfChildren(Location.create((Path)this.validPath), 0, 2, child1, child2);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2}));
        children = (List)this.graph.getChildren().inBlockOf(2).startingAt(1).under(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadBlockOfChildren(Location.create((Path)this.validPath), 1, 2, child2, child3);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child2, child3}));
        children = (List)this.graph.getChildren().inBlockOf(2).startingAt(2).under(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadBlockOfChildren(Location.create((Path)this.validPath), 2, 2, child3);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child3}));
        children = (List)this.graph.getChildren().inBlockOf(2).startingAt(20).under(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadBlockOfChildren(Location.create((Path)this.validPath), 20, 2, new Location[0]);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children.isEmpty(), (Matcher)Is.is((Object)true));
        children = (List)this.graph.getChildren().inBlockOf(20).startingAt(0).under(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadBlockOfChildren(Location.create((Path)this.validPath), 0, 20, child1, child2, child3);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2, child3}));
    }

    @Test
    public void shouldGetChildrenInBlockAfterPreviousSibling() {
        Path pathX = this.createPath(this.validPath, "x");
        Path pathY = this.createPath(this.validPath, "y");
        Path pathZ = this.createPath(this.validPath, "z");
        Location child1 = Location.create((Path)pathX);
        Location child2 = Location.create((Path)pathY);
        Location child3 = Location.create((Path)pathZ);
        this.setChildrenToReadOn(Location.create((Path)this.validPath), child1, child2, child3);
        List children = (List)this.graph.getChildren().inBlockOf(2).startingAfter(pathX);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadNextBlockOfChildren(Location.create((Path)pathX), 2, child2, child3);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child2, child3}));
        children = (List)this.graph.getChildren().inBlockOf(3).startingAfter(pathX);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadNextBlockOfChildren(Location.create((Path)pathX), 3, child2, child3);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child2, child3}));
        children = (List)this.graph.getChildren().inBlockOf(2).startingAfter(pathY);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadNextBlockOfChildren(Location.create((Path)pathY), 2, child3);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)children, (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child3}));
    }

    @Test
    public void shouldSetPropertyWithEitherOnOrToMethodsCalledFirst() {
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(3.0f);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", Float.valueOf(3.0f)));
        ((Graph.On)this.graph.set("propName").to(3.0f)).on(this.validPath);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", Float.valueOf(3.0f)));
    }

    @Test
    public void shouldSetPropertyValueToPrimitiveTypes() {
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(3.0f);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", new Float(3.0f)));
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(1.0);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", new Double(1.0)));
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(false);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", Boolean.FALSE));
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(3);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", new Integer(3)));
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(5L);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", new Long(5L)));
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(this.validPath);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", this.validPath));
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(this.validPath.getLastSegment().getName());
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", this.validPath.getLastSegment().getName()));
        Date now = new Date();
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(now);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", now));
        DateTime dtNow = (DateTime)this.context.getValueFactories().getDateFactory().create(now);
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(dtNow);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", dtNow));
        Calendar calNow = Calendar.getInstance();
        calNow.setTime(now);
        ((Graph.SetValuesTo)this.graph.set("propName").on(this.validPath)).to(calNow);
        this.assertNextRequestSetProperty(Location.create((Path)this.validPath), this.createProperty("propName", dtNow));
    }

    @Test
    public void shouldSetMultiplePropertiesAtOnce() {
        Property p1 = this.createProperty("propName1", new Float(3.0f));
        Property p2 = this.createProperty("propName2", new Double(1.0));
        Property p3 = this.createProperty("propName3", "String value");
        ((Graph.BatchConjunction)this.graph.batch().set(new Property[]{p1, p2, p3}).on(this.validPath)).execute();
        this.assertNextRequestUpdateProperties(Location.create((Path)this.validPath), p1, p2, p3);
    }

    @Test
    public void shouldCombineAdjacentSetPropertyCalls() {
        Property p1 = this.createProperty("propName1", new Float(3.0f));
        Property p2 = this.createProperty("propName2", new Double(1.0));
        Property p3 = this.createProperty("propName3", "String value");
        ((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)this.graph.batch().set(new Property[]{p1}).on(this.validPath)).and()).set(new Property[]{p2}).on(this.validPath)).and()).set(new Property[]{p3}).on(this.validPath)).execute();
        this.assertNextRequestUpdateProperties(Location.create((Path)this.validPath), p1, p2, p3);
    }

    @Test
    public void shouldNotCombineNonAdjacentSetPropertyCalls() {
        Property p1 = this.createProperty("propName1", new Float(3.0f));
        Property p2 = this.createProperty("propName2", new Double(1.0));
        Property p3 = this.createProperty("propName3", "String value");
        ((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)this.graph.batch().set(new Property[]{p1}).on(this.validPath)).and()).set(new Property[]{p2}).on(this.validPath)).and()).set(new Property[]{p3}).on(this.validUuid)).execute();
        this.extractRequestsFromComposite();
        this.assertNextRequestUpdateProperties(Location.create((Path)this.validPath), p1, p2);
        this.assertNextRequestSetProperty(Location.create((UUID)this.validUuid), p3);
    }

    @Test
    public void shouldReadNode() {
        Location child1 = Location.create((Path)this.createPath(this.validPath, "x"));
        Location child2 = Location.create((Path)this.createPath(this.validPath, "y"));
        Location child3 = Location.create((Path)this.createPath(this.validPath, "z"));
        this.setChildrenToReadOn(Location.create((Path)this.validPath), child1, child2, child3);
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        Node node = this.graph.getNodeAt(this.validPath);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2}));
        Assert.assertThat((Object)node.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1, this.validIdProperty2}));
        Assert.assertThat((Object)node.getLocation(), (Matcher)Is.is((Object)Location.create((Path)this.validPath)));
        Assert.assertThat((Object)node.getGraph(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.graph)));
        Assert.assertThat(node.getPropertiesByName().get(this.validIdProperty1.getName()), (Matcher)Is.is((Object)this.validIdProperty1));
        Assert.assertThat(node.getPropertiesByName().get(this.validIdProperty2.getName()), (Matcher)Is.is((Object)this.validIdProperty2));
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadNode(Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldReadSubgraph() {
        Location child1 = Location.create((Path)this.createPath(this.validPath, "x"));
        Location child2 = Location.create((Path)this.createPath(this.validPath, "y"));
        Location child3 = Location.create((Path)this.createPath(this.validPath, "z"));
        this.setChildrenToReadOn(Location.create((Path)this.validPath), child1, child2, child3);
        Location child11 = Location.create((Path)this.createPath(child1.getPath(), "h"));
        Location child12 = Location.create((Path)this.createPath(child1.getPath(), "i"));
        Location child13 = Location.create((Path)this.createPath(child1.getPath(), "j"));
        this.setChildrenToReadOn(child1, child11, child12, child13);
        Location child121 = Location.create((Path)this.createPath(child12.getPath(), "m"));
        Location child122 = Location.create((Path)this.createPath(child12.getPath(), "n"));
        Location child123 = Location.create((Path)this.createPath(child12.getPath(), "o"));
        this.setChildrenToReadOn(child12, child121, child122, child123);
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        this.setPropertiesToReadOn(child1, this.validIdProperty1);
        this.setPropertiesToReadOn(child2, this.validIdProperty2);
        this.setPropertiesToReadOn(child11, this.validIdProperty1);
        this.setPropertiesToReadOn(child12, this.validIdProperty2);
        this.setPropertiesToReadOn(child121, this.validIdProperty1);
        this.setPropertiesToReadOn(child122, this.validIdProperty2);
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at(this.validPath);
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getMaximumDepth(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)subgraph.getLocation(), (Matcher)Is.is((Object)Location.create((Path)this.validPath)));
        Node root = subgraph.getNode(Location.create((Path)this.validPath));
        Assert.assertThat((Object)root.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2, child3}));
        Assert.assertThat((Object)root.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1, this.validIdProperty2}));
        Node node1 = subgraph.getNode(child1);
        Assert.assertThat((Object)node1.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child11, child12, child13}));
        Assert.assertThat((Object)node1.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1}));
        Node node2 = subgraph.getNode(child2);
        Assert.assertThat((Object)node2.getChildren().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node2.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty2}));
        Node node3 = subgraph.getNode(child3);
        Assert.assertThat((Object)node3.getChildren().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node3.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)subgraph.getNode(child123), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        root = subgraph.getNode("./");
        Assert.assertThat((Object)root.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2, child3}));
        Assert.assertThat((Object)root.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1, this.validIdProperty2}));
        node1 = subgraph.getNode("x");
        Assert.assertThat((Object)node1.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child11, child12, child13}));
        Assert.assertThat((Object)node1.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1}));
        node2 = subgraph.getNode("y");
        Assert.assertThat((Object)node2.getChildren().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node2.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty2}));
        node3 = subgraph.getNode("z");
        Assert.assertThat((Object)node3.getChildren().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)node3.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
    }

    public void shouldConstructValidSubgraphToString() {
        Location child1 = Location.create((Path)this.createPath(this.validPath, "x"));
        Location child2 = Location.create((Path)this.createPath(this.validPath, "y"));
        Location child3 = Location.create((Path)this.createPath(this.validPath, "z"));
        this.setChildrenToReadOn(Location.create((Path)this.validPath), child1, child2, child3);
        Location child11 = Location.create((Path)this.createPath(child1.getPath(), "h"));
        Location child12 = Location.create((Path)this.createPath(child1.getPath(), "i"));
        Location child13 = Location.create((Path)this.createPath(child1.getPath(), "j"));
        this.setChildrenToReadOn(child1, child11, child12, child13);
        Location child121 = Location.create((Path)this.createPath(child12.getPath(), "m"));
        Location child122 = Location.create((Path)this.createPath(child12.getPath(), "n"));
        Location child123 = Location.create((Path)this.createPath(child12.getPath(), "o"));
        this.setChildrenToReadOn(child12, child121, child122, child123);
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        this.setPropertiesToReadOn(child1, this.validIdProperty1);
        this.setPropertiesToReadOn(child2, this.validIdProperty2);
        this.setPropertiesToReadOn(child11, this.validIdProperty1);
        this.setPropertiesToReadOn(child12, this.validIdProperty2);
        this.setPropertiesToReadOn(child121, this.validIdProperty1);
        this.setPropertiesToReadOn(child122, this.validIdProperty2);
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at(this.validPath);
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getMaximumDepth(), (Matcher)Is.is((Object)2));
        String expectedToStringValue = "Subgraph\n<name = \"c\" id2 = \"2\" id1 = \"1\">\n  <name = \"x\" id1 = \"1\">\n  <name = \"y\" id2 = \"2\">\n  <name = \"z\" >\n";
        Node root = subgraph.getNode("./");
        Assert.assertThat((Object)root.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2, child3}));
        Assert.assertThat((Object)subgraph.toString(), (Matcher)Is.is((Object)expectedToStringValue));
    }

    @Test
    public void shouldMoveNodeInBatches() {
        ((Graph.BatchConjunction)this.graph.batch().move(this.validPath).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        ((Graph.BatchConjunction)this.graph.batch().move(this.validPathString).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        ((Graph.BatchConjunction)this.graph.batch().move(this.validUuid).into(this.validPath)).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsMove(Location.create((UUID)this.validUuid), Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
        ((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)this.graph.batch().move(this.validPath).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).and()).move(this.validPathString).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).and()).move(this.validUuid).into(this.validPath)).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.extractRequestsFromComposite();
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNextRequestIsMove(Location.create((UUID)this.validUuid), Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCopyNodeInBatches() {
        ((Graph.BatchConjunction)this.graph.batch().copy(this.validPath).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        ((Graph.BatchConjunction)this.graph.batch().copy(this.validPathString).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNoMoreRequests();
        ((Graph.BatchConjunction)this.graph.batch().copy(this.validUuid).into(this.validPath)).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsCopy(Location.create((UUID)this.validUuid), Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
        ((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)((Graph.Batch)((Graph.BatchConjunction)this.graph.batch().copy(this.validPath).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).and()).copy(this.validPathString).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).and()).copy(this.validUuid).into(this.validPath)).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.extractRequestsFromComposite();
        this.assertNextRequestIsCopy(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNextRequestIsCopy(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNextRequestIsCopy(Location.create((UUID)this.validUuid), Location.create((Path)this.validPath));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldReadNodesInBatches() {
        Location child1 = Location.create((Path)this.createPath(this.validPath, "x"));
        Location child2 = Location.create((Path)this.createPath(this.validPath, "y"));
        Location child3 = Location.create((Path)this.createPath(this.validPath, "z"));
        this.setChildrenToReadOn(Location.create((Path)this.validPath), child1, child2, child3);
        Location child11 = Location.create((Path)this.createPath(child1.getPath(), "h"));
        Location child12 = Location.create((Path)this.createPath(child1.getPath(), "i"));
        Location child13 = Location.create((Path)this.createPath(child1.getPath(), "j"));
        this.setChildrenToReadOn(child1, child11, child12, child13);
        Location child121 = Location.create((Path)this.createPath(child12.getPath(), "m"));
        Location child122 = Location.create((Path)this.createPath(child12.getPath(), "n"));
        Location child123 = Location.create((Path)this.createPath(child12.getPath(), "o"));
        this.setChildrenToReadOn(child12, child121, child122, child123);
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
        this.setPropertiesToReadOn(child1, this.validIdProperty1);
        this.setPropertiesToReadOn(child2, this.validIdProperty2);
        this.setPropertiesToReadOn(child11, this.validIdProperty1);
        this.setPropertiesToReadOn(child12, this.validIdProperty2);
        this.setPropertiesToReadOn(child121, this.validIdProperty1);
        this.setPropertiesToReadOn(child122, this.validIdProperty2);
        this.results = ((Graph.Batch)((Graph.Batch)this.graph.batch().read(this.validPath).and()).read(child11).and()).read(child12).execute();
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.extractRequestsFromComposite();
        this.assertNextRequestReadNode(Location.create((Path)this.validPath));
        this.assertNextRequestReadNode(child11);
        this.assertNextRequestReadNode(child12);
        this.assertNoMoreRequests();
        Assert.assertThat((Object)this.results, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node node = this.results.getNode(this.validPath);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child1, child2, child3}));
        Assert.assertThat((Object)node.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1, this.validIdProperty2}));
        Assert.assertThat((Object)node.getLocation(), (Matcher)Is.is((Object)Location.create((Path)this.validPath)));
        Assert.assertThat((Object)node.getGraph(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.graph)));
        Assert.assertThat(node.getPropertiesByName().get(this.validIdProperty1.getName()), (Matcher)Is.is((Object)this.validIdProperty1));
        Assert.assertThat(node.getPropertiesByName().get(this.validIdProperty2.getName()), (Matcher)Is.is((Object)this.validIdProperty2));
        node = this.results.getNode(child11);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getChildren().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)node.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty1}));
        Assert.assertThat((Object)node.getLocation(), (Matcher)Is.is((Object)child11));
        Assert.assertThat((Object)node.getGraph(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.graph)));
        Assert.assertThat(node.getPropertiesByName().get(this.validIdProperty1.getName()), (Matcher)Is.is((Object)this.validIdProperty1));
        node = this.results.getNode(child12);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{child121, child122, child123}));
        Assert.assertThat((Object)node.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validIdProperty2}));
        Assert.assertThat((Object)node.getLocation(), (Matcher)Is.is((Object)child12));
        Assert.assertThat((Object)node.getGraph(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.graph)));
        Assert.assertThat(node.getPropertiesByName().get(this.validIdProperty2.getName()), (Matcher)Is.is((Object)this.validIdProperty2));
    }

    @Test(expected=AssertionError.class)
    public void shouldPropertyCheckReadPropertiesUsingTestHarness1() {
        this.setPropertiesToReadOn(Location.create((Path)this.validPath), this.validIdProperty1);
        this.graph.getProperties().on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperties(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
    }

    @Test(expected=AssertionError.class)
    public void shouldPropertyCheckReadPropertiesUsingTestHarness2() {
        this.graph.getProperties().on(this.validPath);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestReadProperties(Location.create((Path)this.validPath), this.validIdProperty1, this.validIdProperty2);
    }

    @Test(expected=InvalidPathException.class)
    public void shouldPropogateExceptionFromConnectorWhenMovingLocationIsNotFound() {
        this.connection.error = new InvalidPathException();
        this.graph.move(this.validUuid).into(this.validPath);
    }

    @Test(expected=InvalidPathException.class)
    public void shouldPropogateExceptionFromConnectorWhenCopyLocationIsNotFound() {
        this.connection.error = new InvalidPathException();
        this.graph.copy(this.validUuid).into(this.validPath);
    }

    @Test(expected=InvalidPathException.class)
    public void shouldPropogateExceptionFromConnectorWhenDeleteLocationIsNotFound() {
        this.connection.error = new InvalidPathException();
        this.graph.delete(this.validUuid);
    }

    @Test
    public void shouldMoveNodesThroughMultipleMoveRequests() {
        ((Graph)((Graph.Conjunction)this.graph.move(this.validPath).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).and()).move(this.validUuid).into(this.validPathString);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)2));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNextRequestIsMove(Location.create((UUID)this.validUuid), Location.create((Path)this.createPath(this.validPathString)));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldMoveAndRenameNodesThroughMultipleMoveRequests() {
        ((Graph)((Graph.Conjunction)((Graph.Into)this.graph.move(this.validPath).as(this.validName)).into(this.validIdProperty1, new Property[]{this.validIdProperty2})).and()).move(this.validUuid).into(this.validPathString);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)2));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((Property)this.validIdProperty1, (Property[])new Property[]{this.validIdProperty2}));
        this.assertNextRequestIsMove(Location.create((UUID)this.validUuid), Location.create((Path)this.createPath(this.validPathString)));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldIgnoreIncompleteRequests() {
        this.graph.move(this.validPath);
        this.assertNoMoreRequests();
        this.graph.move(this.validPath).into(this.validUuid);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.assertNextRequestIsMove(Location.create((Path)this.validPath), Location.create((UUID)this.validUuid));
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldCreateWorkspaceUsingSpecificName() {
        this.graph.createWorkspace().named("something");
        this.assertNextRequestIsCreateWorkspace("something", CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
    }

    @Test
    public void shouldCreateWorkspaceAlteringNameIfRequired() {
        this.graph.createWorkspace().namedSomethingLike("something");
        this.assertNextRequestIsCreateWorkspace("something", CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
    }

    @Test
    public void shouldCreateWorkspaceByCloningExistingAndUsingSpecificName() {
        this.graph.createWorkspace().clonedFrom("original").named("something");
        this.assertNextRequestIsCloneWorkspace("original", "something", CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.DO_NOT_CLONE);
    }

    @Test
    public void shouldCreateWorkspaceByCloningExistingAndAlteringNameIfRequired() {
        this.graph.createWorkspace().clonedFrom("original").namedSomethingLike("something");
        this.assertNextRequestIsCloneWorkspace("original", "something", CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME, CloneWorkspaceRequest.CloneConflictBehavior.DO_NOT_CLONE);
    }

    @Test
    public void shouldUseExistingWorkspace() {
        this.graph.useWorkspace("something");
    }

    @Test
    public void shouldLockNodeButNotDescendants() {
        ((Graph.LockTimeout)this.graph.lock(this.validPath).only()).withDefaultTimeout();
        this.assertNextRequestIsLock(Location.create((Path)this.validPath), LockBranchRequest.LockScope.SELF_ONLY, 0L);
    }

    @Test
    public void shouldLockNodeAndItsDescendants() {
        ((Graph.LockTimeout)this.graph.lock(this.validPath).andItsDescendants()).withTimeoutOf(12345L);
        this.assertNextRequestIsLock(Location.create((Path)this.validPath), LockBranchRequest.LockScope.SELF_AND_DESCENDANTS, 12345L);
    }

    @Test
    public void shouldUnlockNode() {
        this.graph.unlock(this.validPath);
        this.assertNextRequestIsUnlock(Location.create((Path)this.validPath));
    }

    @Test
    public void shouldReadOnePropertyOnMultipleNodes() {
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(Location.create((Path)this.createPath("/x/y/a")));
        locations.add(Location.create((Path)this.createPath("/x/y/b")));
        locations.add(Location.create((Path)this.createPath("/x/y/c")));
        for (Location location : locations) {
            Property prop1 = this.context.getPropertyFactory().create(this.validName, new Object[]{"1"});
            Property prop2 = this.context.getPropertyFactory().create(this.createName("otherName"), new Object[]{"2"});
            this.setPropertiesToReadOn(location, prop1, prop2);
        }
        Map propertiesByLocation = this.graph.getProperty(this.validName).on(locations);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.extractRequestsFromComposite();
        for (Location location : locations) {
            Property prop = this.properties.get(location).iterator().next();
            this.assertNextRequestReadProperty(location, prop);
            Assert.assertThat(propertiesByLocation.get(location), (Matcher)Is.is((Object)prop));
        }
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldReadMultiplePropertiesOnMultipleNodes() {
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(Location.create((Path)this.createPath("/x/y/a")));
        locations.add(Location.create((Path)this.createPath("/x/y/b")));
        locations.add(Location.create((Path)this.createPath("/x/y/c")));
        Name name1 = this.createName("name1");
        Name name2 = this.createName("name2");
        for (Location location : locations) {
            Property prop1 = this.context.getPropertyFactory().create(name1, new Object[]{"1"});
            Property prop2 = this.context.getPropertyFactory().create(name2, new Object[]{"2"});
            this.setPropertiesToReadOn(location, prop1, prop2);
        }
        Map propertiesByLocation = this.graph.getProperties(new Name[]{name1, name2}).on(locations);
        Assert.assertThat((Object)this.numberOfExecutions, (Matcher)Is.is((Object)1));
        this.extractRequestsFromComposite();
        for (Location location : locations) {
            HashMap<Name, Property> expectedProps = new HashMap<Name, Property>();
            for (Property prop : this.properties.get(location)) {
                expectedProps.put(prop.getName(), prop);
            }
            Property prop1 = (Property)expectedProps.get(name1);
            Property prop2 = (Property)expectedProps.get(name2);
            this.assertNextRequestReadProperty(location, prop1);
            this.assertNextRequestReadProperty(location, prop2);
            Assert.assertThat(((Map)propertiesByLocation.get(location)).get(name1), (Matcher)Is.is((Object)prop1));
            Assert.assertThat(((Map)propertiesByLocation.get(location)).get(name2), (Matcher)Is.is((Object)prop2));
        }
        this.assertNoMoreRequests();
    }

    @Test
    public void shouldPerformSearchWhenConnectorSupportsQueries() {
        QueryResults.Columns columns = (QueryResults.Columns)Mockito.mock(QueryResults.Columns.class);
        Mockito.when((Object)columns.iterator()).thenAnswer((Answer)new Answer<Iterator<Column>>(){

            public Iterator<Column> answer(InvocationOnMock invocation) throws Throwable {
                return Collections.emptyList().iterator();
            }
        });
        List tuples = Collections.emptyList();
        QueryResults.Statistics stats = (QueryResults.Statistics)Mockito.mock(QueryResults.Statistics.class);
        this.nextColumns = columns;
        this.nextTuples = tuples;
        this.nextStatistics = stats;
        String fullTextSearchExpression = "term1 term2";
        QueryResults results = this.graph.search(fullTextSearchExpression, 10, 0);
        Assert.assertThat((Object)this.nextColumns, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(this.nextTuples, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.nextStatistics, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)results.getColumns(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)columns)));
        Assert.assertThat((Object)results.getTuples(), (Matcher)Is.is((Matcher)IsSame.sameInstance(tuples)));
        Assert.assertThat((Object)results.getStatistics(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)stats)));
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldFailToPerformSearchWhenConnectorDoesNotSupportsQueries() {
        this.nextColumns = null;
        this.nextTuples = null;
        this.nextStatistics = null;
        String fullTextSearchExpression = "term1 term2";
        this.graph.search(fullTextSearchExpression, 10, 0);
    }

    @Test
    public void shouldPerformQueryWhenConnectorSupportsQueries() {
        List<Object[]> tuples = Collections.singletonList(new Object[]{"v1", "v2", "v3"});
        QueryResults.Statistics statistics = (QueryResults.Statistics)Mockito.mock(QueryResults.Statistics.class);
        this.nextTuples = tuples;
        this.nextStatistics = statistics;
        TypeSystem typeSystem = this.context.getValueFactories().getTypeSystem();
        Schemata schemata = ImmutableSchemata.createBuilder((ExecutionContext)this.context, (TypeSystem)typeSystem).addTable("t1", new String[]{"c1", "c2", "c3"}).build();
        QueryCommand query = new SqlQueryParser().parseQuery("SELECT * FROM t1", typeSystem);
        QueryResults results = this.graph.query(query, schemata).execute();
        Assert.assertThat((Object)this.nextColumns, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(this.nextTuples, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.nextStatistics, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)results.getColumns(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)results.getTuples(), (Matcher)Is.is(tuples));
        Assert.assertThat((Object)results.getStatistics(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.assertNextRequestAccessQuery(this.graph.getCurrentWorkspaceName(), "t1", this.columns("t1", "c1", "c2", "c3"), Limit.NONE, new Constraint[0]);
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldFailToPerformQueryWhenConnectorDoesNotSupportsQueries() {
        this.nextColumns = null;
        this.nextTuples = null;
        this.nextStatistics = null;
        TypeSystem typeSystem = this.context.getValueFactories().getTypeSystem();
        Schemata schemata = ImmutableSchemata.createBuilder((ExecutionContext)this.context, (TypeSystem)typeSystem).addTable("t1", new String[]{"c1", "c2", "c3"}).build();
        QueryCommand query = new SqlQueryParser().parseQuery("SELECT * FROM t1", typeSystem);
        this.graph.query(query, schemata).execute();
    }

    protected QueryResults.Columns columns(String tableName, String ... columnNames) {
        List<Column> columnList = this.columnList(tableName, columnNames);
        List<String> columnTypes = this.typesFor(columnList);
        return new QueryResultColumns(columnList, columnTypes, false);
    }

    protected QueryResults.Columns columnsWithScores(String tableName, String ... columnNames) {
        List<Column> columnList = this.columnList(tableName, columnNames);
        List<String> columnTypes = this.typesFor(columnList);
        return new QueryResultColumns(columnList, columnTypes, true);
    }

    protected List<String> typesFor(List<Column> columns) {
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i != columns.size(); ++i) {
            types.add(PropertyType.STRING.getName());
        }
        return types;
    }

    protected List<Column> columnList(String tableName, String ... columnNames) {
        ArrayList<Column> columns = new ArrayList<Column>();
        SelectorName selectorName = new SelectorName(tableName);
        for (String columnName : columnNames) {
            columns.add(new Column(selectorName, columnName, columnName));
        }
        return columns;
    }

    class MockRepositoryConnection
    implements RepositoryConnection {
        public Throwable error = null;
        private final RequestProcessor processor = new Processor();

        MockRepositoryConnection() {
        }

        public void close() {
        }

        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            if (this.error != null) {
                request.setError(this.error);
                return;
            }
            if (!(request instanceof VerifyWorkspaceRequest)) {
                GraphTest.this.executedRequests.add(request);
                ++GraphTest.this.numberOfExecutions;
            }
            this.processor.process(request);
        }

        public CachePolicy getDefaultCachePolicy() {
            return null;
        }

        public String getSourceName() {
            return null;
        }

        public XAResource getXAResource() {
            return null;
        }

        public boolean ping(long time, TimeUnit unit) {
            return true;
        }

        public void setObserver(ChangeObserver observer) {
        }
    }

    class Processor
    extends RequestProcessor {
        protected Processor() {
            super(GraphTest.this.sourceName, GraphTest.this.context, null);
        }

        public void process(CopyBranchRequest request) {
            if (request.into().hasPath()) {
                Name childName = request.desiredName();
                if (childName == null) {
                    childName = GraphTest.this.createName("child");
                }
                Path childPath = GraphTest.this.context.getValueFactories().getPathFactory().create(request.into().getPath(), new Name[]{childName});
                Location newChild = this.actualLocationOf(Location.create((Path)childPath));
                request.setActualLocations(this.actualLocationOf(request.from()), newChild);
            } else {
                request.setActualLocations(this.actualLocationOf(request.from()), this.actualLocationOf(request.into()));
            }
        }

        public void process(CloneBranchRequest request) {
            if (request.into().hasPath()) {
                Name childName = request.desiredName();
                if (childName == null) {
                    childName = request.desiredSegment().getName();
                }
                Path childPath = GraphTest.this.context.getValueFactories().getPathFactory().create(request.into().getPath(), new Name[]{childName});
                Location newChild = this.actualLocationOf(Location.create((Path)childPath));
                request.setActualLocations(this.actualLocationOf(request.from()), newChild);
            } else {
                request.setActualLocations(this.actualLocationOf(request.from()), this.actualLocationOf(request.into()));
            }
        }

        public void process(CreateNodeRequest request) {
            Location parent = this.actualLocationOf(request.under());
            Name name = request.named();
            Path childPath = GraphTest.this.context.getValueFactories().getPathFactory().create(parent.getPath(), new Name[]{name});
            request.setActualLocationOfNode(Location.create((Path)childPath));
        }

        public void process(DeleteBranchRequest request) {
            request.setActualLocationOfNode(this.actualLocationOf(request.at()));
        }

        public void process(LockBranchRequest request) {
            request.setActualLocation(this.actualLocationOf(request.at()));
        }

        public void process(UnlockBranchRequest request) {
            request.setActualLocation(this.actualLocationOf(request.at()));
        }

        public void process(MoveBranchRequest request) {
            Name newName = request.desiredName();
            if (newName == null && request.from().hasPath()) {
                newName = request.from().getPath().getLastSegment().getName();
            }
            if (newName == null) {
                newName = (Name)GraphTest.this.context.getValueFactories().getNameFactory().create("d");
            }
            Path newPath = null;
            if (request.into().hasPath()) {
                newPath = GraphTest.this.context.getValueFactories().getPathFactory().create(request.into().getPath(), new Name[]{newName});
            } else if (request.from().hasPath()) {
                newPath = (Path)GraphTest.this.context.getValueFactories().getPathFactory().create("/a/b/c");
                newPath = GraphTest.this.context.getValueFactories().getPathFactory().create(newPath, new Name[]{newName});
            } else {
                newPath = (Path)GraphTest.this.context.getValueFactories().getPathFactory().create("/a/b/c");
                newPath = GraphTest.this.context.getValueFactories().getPathFactory().create(newPath, new Name[]{newName});
            }
            Path oldPath = null;
            if (request.from().hasPath()) {
                oldPath = request.from().getPath();
            } else {
                oldPath = (Path)GraphTest.this.context.getValueFactories().getPathFactory().create("/x/y/z");
                oldPath = GraphTest.this.context.getValueFactories().getPathFactory().create(oldPath, new Name[]{newName});
            }
            Location fromLocation = request.from().hasIdProperties() ? Location.create((Path)oldPath, (Iterable)request.from().getIdProperties()) : Location.create((Path)oldPath);
            Location intoLocation = request.into().hasIdProperties() ? Location.create((Path)newPath, (Iterable)request.into().getIdProperties()) : Location.create((Path)newPath);
            request.setActualLocations(fromLocation, intoLocation);
        }

        public void process(ReadAllChildrenRequest request) {
            if (GraphTest.this.children.containsKey(request.of())) {
                for (Location child : (List)GraphTest.this.children.get(request.of())) {
                    request.addChild(child);
                }
            }
            request.setActualLocationOfNode(this.actualLocationOf(request.of()));
        }

        public void process(ReadAllPropertiesRequest request) {
            if (GraphTest.this.properties.containsKey(request.at())) {
                for (Property property : (Collection)GraphTest.this.properties.get(request.at())) {
                    request.addProperty(property);
                }
            }
            request.setActualLocationOfNode(this.actualLocationOf(request.at()));
        }

        public void process(UpdatePropertiesRequest request) {
            request.setActualLocationOfNode(this.actualLocationOf(request.on()));
            request.setNewProperties(new Name[0]);
        }

        public void process(VerifyWorkspaceRequest request) {
            String workspaceName = request.workspaceName();
            if (workspaceName == null) {
                workspaceName = "default";
            }
            request.setActualWorkspaceName(workspaceName);
            request.setActualRootLocation(Location.create((Path)GraphTest.this.context.getValueFactories().getPathFactory().createRootPath()));
        }

        public void process(CreateWorkspaceRequest request) {
            String workspaceName = request.desiredNameOfNewWorkspace();
            if (workspaceName == null) {
                workspaceName = "default";
            }
            request.setActualWorkspaceName(workspaceName);
            request.setActualRootLocation(Location.create((Path)GraphTest.this.context.getValueFactories().getPathFactory().createRootPath()));
        }

        public void process(DestroyWorkspaceRequest request) {
        }

        public void process(GetWorkspacesRequest request) {
            request.setAvailableWorkspaceNames(Collections.singleton("Test workspace"));
        }

        public void process(CloneWorkspaceRequest request) {
            String workspaceName = request.desiredNameOfTargetWorkspace();
            assert (workspaceName != null);
            request.setActualWorkspaceName(workspaceName);
            request.setActualRootLocation(Location.create((Path)GraphTest.this.context.getValueFactories().getPathFactory().createRootPath()));
        }

        public void process(AccessQueryRequest request) {
            if (GraphTest.this.nextTuples == null) {
                super.process(request);
            }
            request.setResults(GraphTest.this.nextTuples, GraphTest.this.nextStatistics);
            GraphTest.this.nextColumns = null;
            GraphTest.this.nextTuples = null;
            GraphTest.this.nextStatistics = null;
        }

        public void process(FullTextSearchRequest request) {
            if (GraphTest.this.nextTuples == null) {
                super.process(request);
            }
            request.setResults(GraphTest.this.nextColumns, GraphTest.this.nextTuples, GraphTest.this.nextStatistics);
            GraphTest.this.nextColumns = null;
            GraphTest.this.nextTuples = null;
            GraphTest.this.nextStatistics = null;
        }

        private Location actualLocationOf(Location location) {
            if (location.hasPath()) {
                return location;
            }
            Path path = (Path)GraphTest.this.context.getValueFactories().getPathFactory().create("/a/b/c/d");
            return Location.create((Path)path, (Iterable)location.getIdProperties());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IsAnyRequest
    extends ArgumentMatcher<Request> {
        IsAnyRequest() {
        }

        public boolean matches(Object request) {
            return request instanceof Request;
        }
    }
}

