/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.graph.connector.RepositoryOperation;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.RepositorySourceLoadHarness;
import org.modeshape.graph.connector.TimeDelayingRepositorySource;

public class RepositoryConnectionPoolTest {
    private RepositoryConnectionPool pool;
    private RepositorySource source;
    private ExecutionContext context;

    @Before
    public void beforeEach() {
        this.source = new TimeDelayingRepositorySource("source 1");
        this.pool = new RepositoryConnectionPool(this.source, 1, 1, 100L, TimeUnit.SECONDS);
        this.context = null;
    }

    @After
    public void afterEach() throws Exception {
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldBeCreatedInRunningState() {
        Assert.assertThat((Object)this.pool.isShutdown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pool.isTerminating(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pool.isTerminated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void shouldShutdownWhenNoConnectionsWereCreatedOrUsed() throws InterruptedException {
        Assert.assertThat((Object)this.pool.isShutdown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pool.isTerminating(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pool.isTerminated(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)0L));
        for (int i = 0; i != 4; ++i) {
            this.pool.shutdown();
            Assert.assertThat((Object)(this.pool.isShutdown() || this.pool.isTerminating() || this.pool.isTerminated() ? 1 : 0), (Matcher)Is.is((Object)true));
            this.pool.awaitTermination(2L, TimeUnit.SECONDS);
            Assert.assertThat((Object)this.pool.isTerminated(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)0L));
            Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)0L));
        }
    }

    @Test
    public void shouldCreateConnectionAndRecoverWhenClosed() throws RepositorySourceException {
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)0L));
        RepositoryConnection conn = this.pool.getConnection();
        Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), (Matcher)Is.is((Object)1));
        conn.close();
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldAllowShutdownToBeCalledMultipleTimesEvenWhenShutdown() throws RepositorySourceException, InterruptedException {
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)0L));
        RepositoryConnection conn = this.pool.getConnection();
        Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), (Matcher)Is.is((Object)1));
        conn.close();
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), (Matcher)Is.is((Object)1));
        this.pool.shutdown();
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
        Assert.assertThat((Object)this.pool.isTerminated(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)1L));
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotCreateConnectionIfPoolIsNotRunning() throws RepositorySourceException, InterruptedException {
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
        Assert.assertThat((Object)this.pool.isTerminated(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)0L));
        this.pool.getConnection();
    }

    @Test
    public void shouldAllowConnectionsToBeClosedMoreThanOnceWithNoIllEffects() throws RepositorySourceException {
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)0L));
        RepositoryConnection conn = this.pool.getConnection();
        Assert.assertThat((Object)conn, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), (Matcher)Is.is((Object)1));
        conn.close();
        conn.close();
    }

    @Test
    public void shouldBlockClientsWhenNotEnoughConnections() throws Exception {
        int numConnectionsInPool = 1;
        int numClients = 2;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(10);
        RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 100L, TimeUnit.MILLISECONDS, operationFactory);
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldLimitClientsToRunSequentiallyWithOneConnectionInPool() throws Exception {
        int numConnectionsInPool = 1;
        int numClients = 3;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(10);
        RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 100L, TimeUnit.MILLISECONDS, operationFactory);
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldClientsToRunConncurrentlyWithTwoConnectionsInPool() throws Exception {
        int numConnectionsInPool = 2;
        int numClients = 10;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(10);
        RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 100L, TimeUnit.MILLISECONDS, operationFactory);
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Ignore(value="doesn't run on hudson")
    @Test
    public void shouldClientsToRunConncurrentlyWithMultipleConnectionInPool() throws Exception {
        int numConnectionsInPool = 10;
        int numClients = 50;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(20);
        List<Future<Integer>> results = RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 200L, TimeUnit.MILLISECONDS, operationFactory);
        int total = 0;
        for (Future<Integer> result : results) {
            Assert.assertThat((Object)result.isDone(), (Matcher)Is.is((Object)true));
            if (!result.isDone()) continue;
            total += result.get().intValue();
        }
        Assert.assertThat((Object)total, (Matcher)Is.is((Object)(20 * numClients)));
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldReturnTrueFromPingIfRunning() throws Exception {
        int numConnectionsInPool = 2;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        Assert.assertThat((Object)pool.ping(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)pool.ping(20L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldReturnFalseFromPingIfNotRunning() throws Exception {
        int numConnectionsInPool = 2;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
        Assert.assertThat((Object)pool.ping(), (Matcher)Is.is((Object)false));
    }

    @Test
    @FixFor(value={"MODE-1347"})
    public void shouldntBlockOnConcurrentOpenCloseConnectionScenario1() throws Exception {
        final RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        final Random rnd = new Random();
        int maxWaitSeconds = 10;
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int i = 0; i < pool.getMaximumPoolSize() * 2; ++i) {
            executorService.submit(new Callable<RepositoryConnection>(){

                @Override
                public RepositoryConnection call() throws Exception {
                    RepositoryConnection connection = pool.getConnection();
                    Assert.assertNotNull((Object)connection);
                    long waitMillis = TimeUnit.SECONDS.toMillis(rnd.nextInt(10));
                    Thread.sleep(waitMillis);
                    connection.close();
                    return connection;
                }
            });
        }
        ArrayList<Future<Void>> futureTasks = new ArrayList<Future<Void>>();
        for (int i = 0; i < pool.getMaximumPoolSize(); ++i) {
            futureTasks.add(executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RepositoryConnection connection = pool.getConnection();
                    Assert.assertNotNull((Object)connection);
                    long waitMillis = TimeUnit.SECONDS.toMillis(rnd.nextInt(10));
                    Thread.sleep(waitMillis);
                    return null;
                }
            }));
        }
        for (Future future : futureTasks) {
            future.get();
        }
        executorService.shutdown();
    }

    @Test
    @FixFor(value={"MODE-1347"})
    public void shouldntBlockOnConcurrentOpenCloseConnectionScenario2() throws Exception {
        int i;
        final RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        ExecutorService executorService = Executors.newCachedThreadPool();
        final ArrayList<Future<RepositoryConnection>> futureConnections = new ArrayList<Future<RepositoryConnection>>();
        for (i = 0; i <= pool.getMaximumPoolSize(); ++i) {
            Callable<RepositoryConnection> openConnectionTask = new Callable<RepositoryConnection>(){

                @Override
                public RepositoryConnection call() throws Exception {
                    RepositoryConnection connection = pool.getConnection();
                    Assert.assertNotNull((Object)connection);
                    return connection;
                }
            };
            futureConnections.add(executorService.submit(openConnectionTask));
        }
        executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((RepositoryConnection)((Future)futureConnections.get(0)).get()).close();
                return null;
            }
        });
        for (i = 1; i < futureConnections.size(); ++i) {
            ((Future)futureConnections.get(i)).get();
        }
        executorService.shutdown();
    }
}

