/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.i18n.MockI18n;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.graph.connector.RepositoryOperation;
import org.modeshape.graph.connector.RepositoryOperations;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.RootPath;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySourceLoadHarness {
    public static Future<Integer> execute(RepositoryConnectionPool pool, ExecutionContext context, long maxTime, TimeUnit maxTimeUnit) throws InterruptedException {
        int numTimes = 1;
        int numClients = 1;
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(numTimes);
        List<Future<Integer>> results = RepositorySourceLoadHarness.runLoadTest(context, pool, numClients, maxTime, maxTimeUnit, operationFactory);
        return results.get(0);
    }

    public static <T> List<Future<T>> runLoadTest(ExecutionContext context, RepositoryConnectionPool pool, int numClients, long maxTime, TimeUnit maxTimeUnit, RepositoryOperation.Factory<T> clientFactory) throws InterruptedException {
        ArrayList<RepositoryOperation<T>> clients = new ArrayList<RepositoryOperation<T>>();
        for (int i = 0; i != numClients; ++i) {
            clients.add(clientFactory.create());
        }
        return RepositorySourceLoadHarness.runLoadTest(context, pool, maxTime, maxTimeUnit, clients);
    }

    public static <T> List<Future<T>> runLoadTest(ExecutionContext context, RepositoryConnectionPool pool, long maxTime, TimeUnit maxTimeUnit, RepositoryOperation<T> ... clients) throws InterruptedException {
        ArrayList<RepositoryOperation<T>> clientCollection = new ArrayList<RepositoryOperation<T>>();
        for (RepositoryOperation<T> client : clients) {
            if (client == null) continue;
            clientCollection.add(client);
        }
        return RepositorySourceLoadHarness.runLoadTest(context, pool, maxTime, maxTimeUnit, clientCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> runLoadTest(ExecutionContext context, RepositoryConnectionPool pool, long maxTime, TimeUnit maxTimeUnit, Collection<RepositoryOperation<T>> clients) throws InterruptedException {
        List<Future<T>> list;
        Object threadFactory;
        assert (pool != null);
        assert (clients != null);
        assert (clients.size() > 0);
        ExecutorService clientPool = null;
        if (clients.size() == 1) {
            threadFactory = new NamedThreadFactory("load");
            clientPool = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
        } else {
            threadFactory = new TestThreadFactory(clients.size());
            clientPool = Executors.newFixedThreadPool(clients.size(), (ThreadFactory)threadFactory);
        }
        try {
            List<Future<T>> futures;
            List<Callable<T>> callables = RepositoryOperations.createCallables(context, pool, clients);
            list = futures = clientPool.invokeAll(callables, maxTime, maxTimeUnit);
            clientPool.shutdown();
        }
        catch (Throwable throwable) {
            clientPool.shutdown();
            if (!clientPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                String msg = "Unable to shutdown clients after 5 seconds";
                Logger.getLogger(RepositorySourceLoadHarness.class).error(MockI18n.passthrough, new Object[]{msg});
            }
            throw throwable;
        }
        if (!clientPool.awaitTermination(5L, TimeUnit.SECONDS)) {
            String msg = "Unable to shutdown clients after 5 seconds";
            Logger.getLogger(RepositorySourceLoadHarness.class).error(MockI18n.passthrough, new Object[]{msg});
        }
        return list;
    }

    public static RepositoryOperation.Factory<Integer> createMultipleLoadOperationFactory(final int callsPerOperation) {
        return new RepositoryOperation.Factory<Integer>(){

            @Override
            public RepositoryOperation<Integer> create() {
                return new CallLoadMultipleTimes(callsPerOperation);
            }
        };
    }

    public static int random(int seed) {
        seed ^= seed << 6;
        seed ^= seed >>> 21;
        seed ^= seed << 7;
        return seed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CallLoadMultipleTimes
    implements RepositoryOperation<Integer> {
        private final int count;

        public CallLoadMultipleTimes(int count) {
            Logger.getLogger(RepositorySourceLoadHarness.class).debug("Creating repository operation to call {0} times", new Object[]{count});
            this.count = count;
        }

        @Override
        public String getName() {
            return Thread.currentThread().getName() + "-CallLoadMultipleTimes";
        }

        @Override
        public Integer run(ExecutionContext context, RepositoryConnection connection) throws RepositorySourceException {
            Logger.getLogger(RepositorySourceLoadHarness.class).debug("Running {0} operation", new Object[]{this.getClass().getSimpleName()});
            int total = this.count;
            for (int i = 0; i != this.count; ++i) {
                int int1 = RepositorySourceLoadHarness.random(this.hashCode() ^ (int)System.nanoTime() * i);
                if (i % 2 == 0) {
                    Thread.yield();
                }
                connection.execute(context, (Request)new ReadNodeRequest(Location.create((Path)RootPath.INSTANCE), "workspace1"));
                int int2 = RepositorySourceLoadHarness.random(this.hashCode() ^ (int)System.nanoTime() + i);
                total += Math.min(Math.abs(Math.max(int1, int2) + int1 * int2 / 3), this.count);
            }
            Logger.getLogger(RepositorySourceLoadHarness.class).debug("Finishing {0} operation", new Object[]{this.getClass().getSimpleName()});
            return total < this.count ? total : this.count;
        }
    }

    protected static class TestThreadFactory
    implements ThreadFactory {
        protected final int totalNumberOfThreads;
        protected final CountDownLatch latch;

        public TestThreadFactory(int numberOfThreadsToWait) {
            this.latch = new CountDownLatch(numberOfThreadsToWait);
            this.totalNumberOfThreads = numberOfThreadsToWait;
        }

        public Thread newThread(Runnable runnable) {
            return new Thread(runnable){

                public void run() {
                    if (TestThreadFactory.this.totalNumberOfThreads > 1) {
                        try {
                            TestThreadFactory.this.latch.countDown();
                            TestThreadFactory.this.latch.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    super.run();
                }
            };
        }
    }
}

