/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.test;

import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;

public abstract class ReadableConnectorTest
extends AbstractConnectorTest {
    @After
    public void afterEach() throws Exception {
    }

    @Test
    public void shouldAlwaysBeAbleToReadRootNode() {
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((String)"Connector must always have a root node", (Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)"Root node must always have a path", (Object)root.getLocation().hasPath(), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)"Root node must never have a null path", (Object)root.getLocation().getPath(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)"Root node's path must be the root path", (Object)root.getLocation().getPath().isRoot(), (Matcher)Is.is((Object)true));
        List idProperties = root.getLocation().getIdProperties();
        if (idProperties == null) {
            Assert.assertThat((Object)root.getLocation().hasIdProperties(), (Matcher)Is.is((Object)false));
        } else {
            Assert.assertThat((Object)root.getLocation().hasIdProperties(), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldReturnEquivalentLocationForRootUponRepeatedCalls() {
        Node root = this.graph.getNodeAt("/");
        for (int i = 0; i != 10; ++i) {
            Node anotherRoot = this.graph.getNodeAt("/");
            Assert.assertThat((Object)anotherRoot.getLocation().isSame(root.getLocation()), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)anotherRoot.getLocation().getPath(), (Matcher)Is.is((Object)root.getLocation().getPath()));
            Assert.assertThat((Object)anotherRoot.getLocation().getIdProperties(), (Matcher)Is.is((Object)root.getLocation().getIdProperties()));
        }
    }

    @Test
    public void shouldFindRootByIdentificationProperties() {
        Node root = this.graph.getNodeAt("/");
        Location rootLocation = root.getLocation();
        if (rootLocation.hasIdProperties()) {
            List idProperties = rootLocation.getIdProperties();
            Assert.assertThat((String)"Root node's ID properties was null when there were supposed to be properties", (Object)idProperties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Property firstProperty = (Property)idProperties.get(0);
            Property[] additionalProperties = new Property[]{};
            if (idProperties.size() > 1) {
                List morePropertiesList = idProperties.subList(1, idProperties.size());
                Assert.assertThat((Object)morePropertiesList.isEmpty(), (Matcher)Is.is((Object)false));
                additionalProperties = morePropertiesList.toArray(new Property[morePropertiesList.size()]);
            }
            Node anotherRoot = this.graph.getNodeAt(firstProperty, additionalProperties);
            Assert.assertThat((Object)anotherRoot.getLocation().isSame(root.getLocation()), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)anotherRoot.getLocation().getPath(), (Matcher)Is.is((Object)root.getLocation().getPath()));
            Assert.assertThat((Object)anotherRoot.getLocation().getIdProperties(), (Matcher)Is.is((Object)root.getLocation().getIdProperties()));
        }
    }

    @Test
    public void shouldFindRootByUUID() {
        Node root = this.graph.getNodeAt("/");
        Location rootLocation = root.getLocation();
        UUID uuid = rootLocation.getUuid();
        if (uuid != null) {
            Node anotherRoot = this.graph.getNodeAt(uuid);
            Assert.assertThat((Object)anotherRoot.getLocation().isSame(root.getLocation()), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)anotherRoot.getLocation().getPath(), (Matcher)Is.is((Object)root.getLocation().getPath()));
            Assert.assertThat((Object)anotherRoot.getLocation().getIdProperties(), (Matcher)Is.is((Object)root.getLocation().getIdProperties()));
            Assert.assertThat((Object)anotherRoot.getLocation().getUuid(), (Matcher)Is.is((Object)root.getLocation().getUuid()));
        }
    }

    @Test
    public void shouldReadTheChildrenOfTheRootNode() {
        List children = (List)this.graph.getChildren().of("/");
        Assert.assertThat((Object)children, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        for (Location child : children) {
            Assert.assertThat((Object)child.hasPath(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)child.getPath().getParent().isRoot(), (Matcher)Is.is((Object)true));
            this.readNodeThoroughly(child);
        }
    }

    @Ignore
    @Test
    public void shouldReadSubgraphStartingAtRootAndWithMaximumDepthOfThree() {
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        SubgraphNode root = subgraph.getRoot();
        ReadableConnectorTest.assertSameNode((Node)root, this.graph.getNodeAt("/"));
        List children = (List)this.graph.getChildren().of("/");
        Assert.assertThat((Object)children, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        for (Location childLocation : children) {
            Node child = subgraph.getNode(childLocation);
            ReadableConnectorTest.assertSameNode(child, this.graph.getNodeAt(childLocation));
            List grandChildren = (List)this.graph.getChildren().of(childLocation);
            Assert.assertThat((Object)grandChildren, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            for (Location grandchildLocation : grandChildren) {
                Node grandchild = subgraph.getNode(grandchildLocation);
                ReadableConnectorTest.assertSameNode(grandchild, this.graph.getNodeAt(grandchildLocation));
                for (Location greatGrandchild : grandchild.getChildren()) {
                    Assert.assertThat((Object)subgraph.getNode(greatGrandchild), (Matcher)Is.is((Matcher)IsNull.nullValue()));
                }
            }
        }
    }

    @Test
    public void shouldReadIndividualPropertiesOfNodes() {
        for (Location childLocation : (List)this.graph.getChildren().of("/")) {
            Node child = this.graph.getNodeAt(childLocation);
            for (Property property : child.getProperties()) {
                Name name = property.getName();
                Property singleProperty = (Property)this.graph.getProperty(name).on(childLocation);
                Assert.assertThat((Object)singleProperty, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)singleProperty, (Matcher)Is.is((Object)property));
            }
        }
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToReadNodeThatDoesNotExist() {
        Path nonExistantChildName = this.findPathToNonExistentNodeUnder("/");
        Node node = this.graph.getNodeAt(nonExistantChildName);
        this.print(node.toString());
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldFailToReadPropertyOnNodeThatDoesNotExist() {
        Path nonExistantChildName = this.findPathToNonExistentNodeUnder("/");
        this.graph.getProperty("jcr:uuid").on(nonExistantChildName);
    }

    @Test
    public void shouldFailToReadPropertyThatDoesNotExistOnExistingNode() {
        for (Location childLocation : (List)this.graph.getChildren().of("/")) {
            String nonExistentPropertyName = "ab39dbyfg739_adf7bg";
            Property property = (Property)this.graph.getProperty(nonExistentPropertyName).on(childLocation);
            Assert.assertThat((Object)property, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    @Test
    public void shouldIncludeTimeLoadedInReadNodeRequests() {
        String workspaceName = this.graph.getCurrentWorkspaceName();
        ReadNodeRequest request = new ReadNodeRequest(this.location("/"), workspaceName);
        this.execute(request);
        Assert.assertThat((Object)request.getTimeLoaded(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldIncludeTimeLoadedInReadAllPropertiesRequests() {
        String workspaceName = this.graph.getCurrentWorkspaceName();
        ReadAllPropertiesRequest request = new ReadAllPropertiesRequest(this.location("/"), workspaceName);
        this.execute(request);
        Assert.assertThat((Object)request.getTimeLoaded(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldIncludeTimeLoadedInReadAllChildrenRequests() {
        String workspaceName = this.graph.getCurrentWorkspaceName();
        ReadAllChildrenRequest request = new ReadAllChildrenRequest(this.location("/"), workspaceName);
        this.execute(request);
        Assert.assertThat((Object)request.getTimeLoaded(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldIncludeTimeLoadedInReadBlockOfChildrenRequests() {
        String workspaceName = this.graph.getCurrentWorkspaceName();
        ReadBlockOfChildrenRequest request = new ReadBlockOfChildrenRequest(this.location("/"), workspaceName, 0, 100);
        this.execute(request);
        Assert.assertThat((Object)request.getTimeLoaded(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldIncludeTimeLoadedInReadNextBlockOfChildrenRequests() {
        String workspaceName = this.graph.getCurrentWorkspaceName();
        Location firstChild = (Location)((List)this.graph.getChildren().of("/")).get(0);
        ReadNextBlockOfChildrenRequest request = new ReadNextBlockOfChildrenRequest(firstChild, workspaceName, 100);
        this.execute(request);
        Assert.assertThat((Object)request.getTimeLoaded(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldIncludeTimeLoadedInReadPropertyRequests() {
        String workspaceName = this.graph.getCurrentWorkspaceName();
        Location firstChildLocation = (Location)((List)this.graph.getChildren().of("/")).get(0);
        Node firstChild = this.graph.getNodeAt(firstChildLocation);
        for (Property property : firstChild.getProperties()) {
            ReadPropertyRequest request = new ReadPropertyRequest(firstChildLocation, workspaceName, property.getName());
            this.execute(request);
            Assert.assertThat((Object)request.getTimeLoaded(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    public void shouldIncludeTimeLoadedInReadBranchRequests() {
        String workspaceName = this.graph.getCurrentWorkspaceName();
        ReadBranchRequest request = new ReadBranchRequest(this.location("/"), workspaceName, 2);
        this.execute(request);
        Assert.assertThat((Object)request.getTimeLoaded(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldReturnSameStructureForRepeatedReadBranchRequests() {
        Location root = this.graph.getCurrentWorkspace().getRoot();
        Subgraph subgraph1 = (Subgraph)this.graph.getSubgraphOfDepth(10).at(root);
        for (int i = 0; i != 4; ++i) {
            Subgraph subgraph2 = (Subgraph)this.graph.getSubgraphOfDepth(10).at(root);
            ReadableConnectorTest.assertEquivalentSubgraphs(subgraph1, subgraph2, true, true);
        }
    }
}

