/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.mimetype;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.mimetype.ExtensionBasedMimeTypeDetector;

public class ExtensionBasedMimeTypeDetectorTest {
    private ExtensionBasedMimeTypeDetector detector;
    private InputStream stream;

    @Before
    public void beforeEach() throws Exception {
        this.detector = new ExtensionBasedMimeTypeDetector();
        this.stream = null;
    }

    @Test
    public void shouldFindMimeTypeForExtenionsInStandardPropertiesFile() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.txt", this.stream), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void shouldFindMimeTypeForOneCharacterExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.gzip.Z", this.stream), (Matcher)Is.is((Object)"application/x-compress"));
    }

    @Test
    public void shouldFindMimeTypeForTwoCharacterExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.sh", this.stream), (Matcher)Is.is((Object)"application/x-sh"));
    }

    @Test
    public void shouldFindMimeTypeForThreeCharacterExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.png", this.stream), (Matcher)Is.is((Object)"image/png"));
    }

    @Test
    public void shouldNotFindMimeTypeForNameWithoutExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something", this.stream), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForNameUnknownExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.thisExtensionIsNotKnown", this.stream), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForZeroLengthName() {
        Assert.assertThat((Object)this.detector.mimeTypeOf(null, this.stream), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForNameContainingWhitespace() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("/t   /n  ", this.stream), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForNullName() {
        Assert.assertThat((Object)this.detector.mimeTypeOf(null, this.stream), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldFindMimeTypeForUppercaseExtenionsInStandardPropertiesFile() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.TXT", this.stream), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void shouldFindMimeTypeForNameWithTrailingWhitespace() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.txt \t", this.stream), (Matcher)Is.is((Object)"text/plain"));
    }
}

