/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.PathValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class BasicPathSegmentTest {
    public static final TextEncoder NO_OP_ENCODER = Path.NO_OP_ENCODER;
    private NamespaceRegistry registry;
    private ValueFactory<String> stringValueFactory;
    private NameValueFactory nameFactory;
    private PathValueFactory factory;
    private Name validName;
    private Path.Segment segment;
    private Path.Segment segment2;

    @Before
    public void beforeEach() {
        this.registry = new SimpleNamespaceRegistry();
        this.registry.register("mode", "http://www.modeshape.org/1.0");
        this.stringValueFactory = new StringValueFactory(this.registry, Path.DEFAULT_DECODER, Path.DEFAULT_ENCODER);
        this.nameFactory = new NameValueFactory(this.registry, Path.DEFAULT_DECODER, this.stringValueFactory);
        this.validName = this.nameFactory.create("mode:something");
        this.factory = new PathValueFactory(Path.DEFAULT_DECODER, this.stringValueFactory, (ValueFactory)this.nameFactory);
    }

    @Test
    public void shouldConsiderEqualTwoSegmentsWithSameNameAndIndex() {
        this.segment = new BasicPathSegment(this.validName);
        this.segment2 = new BasicPathSegment(this.validName);
        Assert.assertThat((Object)this.segment.equals(this.segment2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.segment.isSelfReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isParentReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.getName(), (Matcher)Is.is((Object)this.validName));
    }

    @Test
    public void shouldHaveIndexSpecifiedInConstructor() {
        this.segment = new BasicPathSegment(this.validName, 3);
        Assert.assertThat((Object)this.segment.getIndex(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.segment.hasIndex(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.segment.isSelfReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isParentReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.getName(), (Matcher)Is.is((Object)this.validName));
    }

    @Test
    public void shouldNotHaveIndexByDefault() {
        this.segment = new BasicPathSegment(this.validName);
        Assert.assertThat((Object)this.segment.getIndex(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.segment.hasIndex(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isSelfReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isParentReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.getName(), (Matcher)Is.is((Object)this.validName));
    }

    @Test
    public void shouldCreateSelfReferenceSegmentIfPassedSelfReferenceStringRegardlessOfIndex() {
        this.segment = this.factory.createSegment(".");
        Assert.assertThat((Object)this.segment.getIndex(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.segment.hasIndex(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isSelfReference(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.segment.isParentReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.getName().getLocalName(), (Matcher)Is.is((Object)"."));
        Assert.assertThat((Object)this.segment.getName().getNamespaceUri().length(), (Matcher)Is.is((Object)0));
        this.segment = this.factory.createSegment(".", 1);
        Assert.assertThat((Object)this.segment.getIndex(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.segment.hasIndex(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isSelfReference(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.segment.isParentReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.getName().getLocalName(), (Matcher)Is.is((Object)"."));
        Assert.assertThat((Object)this.segment.getName().getNamespaceUri().length(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCreateParentReferenceSegmentIfPassedParentReferenceStringRegardlessOfIndex() {
        this.segment = this.factory.createSegment("..");
        Assert.assertThat((Object)this.segment.getIndex(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.segment.hasIndex(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isSelfReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isParentReference(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.segment.getName().getLocalName(), (Matcher)Is.is((Object)".."));
        Assert.assertThat((Object)this.segment.getName().getNamespaceUri().length(), (Matcher)Is.is((Object)0));
        this.segment = this.factory.createSegment("..", 1);
        Assert.assertThat((Object)this.segment.getIndex(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.segment.hasIndex(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isSelfReference(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.segment.isParentReference(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.segment.getName().getLocalName(), (Matcher)Is.is((Object)".."));
        Assert.assertThat((Object)this.segment.getName().getNamespaceUri().length(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldConsiderSegmentCreatedWithSelfReferenceToBeEqualToStaticSingleton() {
        this.segment = this.factory.createSegment(".");
        Assert.assertThat((Object)this.segment.equals(Path.SELF_SEGMENT), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderSegmentCreatedWithParentReferenceToBeEqualToStaticSingleton() {
        this.segment = this.factory.createSegment("..");
        Assert.assertThat((Object)this.segment.equals(Path.PARENT_SEGMENT), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderSegmentWithSameNameSiblingIndexOfOneToBeEqualToSegmentWithSameNameButNoIndex() {
        this.segment = new BasicPathSegment(this.validName, 1);
        BasicPathSegment segment2 = new BasicPathSegment(this.validName, 1);
        Assert.assertThat((Object)this.segment, (Matcher)Is.is((Object)segment2));
    }

    @Test
    public void shouldConsiderSegmentWithSameNameSiblingIndexOfTwoOrMoreToNotBeEqualToSegmentWithSameNameButNoIndex() {
        this.segment = new BasicPathSegment(this.validName, 1);
        BasicPathSegment segment2 = new BasicPathSegment(this.validName, 2);
        Assert.assertThat((Object)this.segment, (Matcher)Is.is((Matcher)IsNot.not((Object)segment2)));
        segment2 = new BasicPathSegment(this.validName, 3);
        Assert.assertThat((Object)this.segment, (Matcher)Is.is((Matcher)IsNot.not((Object)segment2)));
    }

    @Test
    public void shouldUseDelimiterEncoderToEncodeDelimiterBetweenPrefixAndLocalPart() {
        Jsr283Encoder encoder = new Jsr283Encoder();
        this.validName = new BasicName("http://www.modeshape.org/1.0", "some:name:with:colons");
        this.segment = new BasicPathSegment(this.validName, 1);
        TextEncoder delimiterEncoder = new TextEncoder(){

            public String encode(String text) {
                if (":".equals(text)) {
                    return "\\:";
                }
                if ("{".equals(text)) {
                    return "\\{";
                }
                if ("}".equals(text)) {
                    return "\\}";
                }
                return text;
            }
        };
        Assert.assertThat((Object)this.segment.getString(this.registry, (TextEncoder)encoder, delimiterEncoder), (Matcher)Is.is((Object)"mode\\:some\uf03aname\uf03awith\uf03acolons"));
        Assert.assertThat((Object)this.segment.getString(null, (TextEncoder)encoder, delimiterEncoder), (Matcher)Is.is((Object)("\\{" + encoder.encode("http://www.modeshape.org/1.0") + "\\}some\uf03aname\uf03awith\uf03acolons")));
    }
}

