/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.PushSelectCriteria;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.Schemata;

public class PushSelectCriteriaTest
extends AbstractQueryTest {
    private PushSelectCriteria rule;
    private QueryContext context;

    @Before
    public void beforeEach() {
        ExecutionContext execContext = new ExecutionContext();
        this.context = new QueryContext(execContext, (Schemata)Mockito.mock(Schemata.class), execContext.getValueFactories().getTypeSystem());
        this.rule = PushSelectCriteria.INSTANCE;
    }

    @Test
    public void shouldPushDownAllSelectNodesThatApplyToSelectorBelowAccessNodeButAboveSourceNodeUsingSameSelector() {
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("Selector1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("Selector1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("Selector1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("Selector1")});
        PlanNode select4 = new PlanNode(PlanNode.Type.SELECT, select3, new SelectorName[]{this.selector("Selector1")});
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, select4, new SelectorName[]{this.selector("Selector1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, access, new SelectorName[]{this.selector("Selector1")});
        PlanNode result = this.rule.execute(this.context, project, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)project)));
        this.assertChildren(project, access);
        this.assertChildren(access, select1);
        this.assertChildren(select1, select2);
        this.assertChildren(select2, select3);
        this.assertChildren(select3, select4);
        this.assertChildren(select4, source);
        this.assertChildren(source, new PlanNode[0]);
    }

    @Test
    public void shouldNotPushDownSelectNodesThatUseDifferentSelectorNamesThanSourceNode() {
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("Selector1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("Selector2")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("Selector1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("Selector2")});
        PlanNode select4 = new PlanNode(PlanNode.Type.SELECT, select3, new SelectorName[]{this.selector("Selector1")});
        PlanNode access = new PlanNode(PlanNode.Type.ACCESS, select4, new SelectorName[]{this.selector("Selector1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, access, new SelectorName[]{this.selector("Selector1")});
        PlanNode result = this.rule.execute(this.context, project, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)project)));
        this.assertChildren(project, select1);
        this.assertChildren(select1, select3);
        this.assertChildren(select3, access);
        this.assertChildren(access, select2);
        this.assertChildren(select2, select4);
        this.assertChildren(select4, source);
        this.assertChildren(source, new PlanNode[0]);
    }

    @Test
    public void shouldPushDownAllSelectNodesThatApplyToOneSelectorToBelowAccessNodeForThatSelector() {
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("Selector1"), this.selector("Selector2")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("Selector1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("Selector2")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("Selector1"), this.selector("Selector2")});
        PlanNode select4 = new PlanNode(PlanNode.Type.SELECT, select3, new SelectorName[]{this.selector("Selector1")});
        PlanNode join = new PlanNode(PlanNode.Type.JOIN, select4, new SelectorName[]{this.selector("Selector1"), this.selector("Selector2")});
        PlanNode s1Access = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("Selector1")});
        PlanNode s1Source = new PlanNode(PlanNode.Type.SOURCE, s1Access, new SelectorName[]{this.selector("Selector1")});
        PlanNode s2Access = new PlanNode(PlanNode.Type.ACCESS, join, new SelectorName[]{this.selector("Selector2")});
        PlanNode s2Source = new PlanNode(PlanNode.Type.SOURCE, s2Access, new SelectorName[]{this.selector("Selector2")});
        join.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        PlanNode result = this.rule.execute(this.context, project, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)project)));
        this.assertChildren(project, select3);
        this.assertChildren(select3, join);
        this.assertChildren(join, s1Access, s2Access);
        this.assertChildren(s1Access, select1);
        this.assertChildren(select1, select4);
        this.assertChildren(select4, s1Source);
        this.assertChildren(s2Access, select2);
        this.assertChildren(select2, s2Source);
        this.assertChildren(s2Source, new PlanNode[0]);
        this.assertChildren(s1Source, new PlanNode[0]);
    }
}

